import 'package:flutter/material.dart';
import 'package:gen_rentals/Utility/Reusablewidgets.dart';
import '../../Utility/AppColors.dart';
import 'package:flutter_svg/flutter_svg.dart';

class PaymentSuccessfulScreen extends StatefulWidget {
  const PaymentSuccessfulScreen({super.key});

  @override
  State<PaymentSuccessfulScreen> createState() => _PaymentSuccessfulScreenState();
}

class _PaymentSuccessfulScreenState extends State<PaymentSuccessfulScreen> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppColors.backgroundRegular,
      body: SafeArea(
        child: SingleChildScrollView(
          child: Container(
            padding: const EdgeInsets.symmetric(horizontal: 18, vertical: 14),
            decoration: const BoxDecoration(
              gradient: LinearGradient(
                begin: Alignment.topCenter,
                end: Alignment.bottomCenter,
                colors: [
                  Color(0xFFFFFFFF),
                  Color(0xFFFFFFFF),
                  AppColors.backgroundRegular,
                  AppColors.backgroundRegular,
                  AppColors.backgroundRegular
                ],
              ),
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                const SizedBox(height: 40),

                // Success Icon
                Container(
                  width: double.infinity,
                  height: 140,
                  color: Colors.white,
                  child: Image.asset(
                    'assets/images/success_pay_gif.gif',
                    height: 80,
                    width: 80,
                  ),
                ),

                const SizedBox(height: 24),

                // Success Title
                const Text(
                  "Payment Successful",
                  style: TextStyle(
                    fontFamily: "Poppins",
                    fontSize: 24,
                    fontWeight: FontWeight.w500,
                    color: AppColors.normalText,
                  ),
                ),

                const SizedBox(height: 8),

                // Success Message
                Text(
                  "Now enjoy a seamless,\nuninterrupted rental service.",
                  textAlign: TextAlign.center,
                  style: TextStyle(
                    fontFamily: "Poppins",
                    fontSize: 16,
                    fontWeight: FontWeight.w400,
                    color: AppColors.subtitleText,
                    height: 1.5,
                  ),
                ),

                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    const SizedBox(height: 25),

                    const SectionHeading(title: "Payment Details"),

                    // Payment Details Section
                    _buildSection(
                      children: [
                        _buildDetailRow(title: "Date", value: "8th Oct, 2025"),
                        _buildDetailRow(title: "Payment Mode", value: "Credit Card **56"),
                        _buildDetailRow(
                          title: "Payment Status",
                          value: "Paid",
                          valueStyle: const TextStyle(
                            color: Color(0xFF4CAF50),
                            fontWeight: FontWeight.w600,
                          ),
                        ),
                      ],
                    ),

                    const SizedBox(height: 10),

                    const SectionHeading(title: "Bill Details"),
                    // Bill Details Section
                    _buildSection(
                      children: [
                        _buildDetailRow(title: "Total Amount", value: "₹421"),
                        _buildDetailRow(title: "Bill Cycle", value: "7th Sep, 2025 – 7th Oct, 2025"),
                        _buildDetailRow(title: "Bill Generated Date", value: "8th Oct, 2025"),
                        _buildDetailRow(title: "Payable Amount", value: "₹421"),
                        _buildDetailRow(title: "Paid Date/Due Date", value: "7th Oct, 2025"),
                      ],
                    ),
                  ],
                ),

                const SizedBox(height: 25),

                // Back to Home Button
                SizedBox(
                  width: double.infinity,
                  child: ElevatedButton(
                    onPressed: () {
                      // Add navigation logic here
                      Navigator.pop(context);
                    },
                    style: ElevatedButton.styleFrom(
                      backgroundColor: AppColors.buttonColor,
                      foregroundColor: Colors.white,
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(30),
                      ),
                      padding: const EdgeInsets.symmetric(vertical: 16),
                    ),
                    child: const Padding(
                      padding: EdgeInsets.symmetric(horizontal: 22),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          Text(
                            "Back to Home",
                            style: TextStyle(
                              color: Color(0xFFFFFFFF),
                              fontSize: 16,
                              fontWeight: FontWeight.w500,
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                ),

                const SizedBox(height: 20),
              ],
            ),
          ),
        ),
      ),
    );
  }

  Widget _buildSection({
    required List<Widget> children,
  }) {
    return Container(
      width: double.infinity,
      padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
      decoration: BoxDecoration(
        color: const Color(0xFFF8F9FA),
        borderRadius: BorderRadius.circular(18),
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: children,
      ),
    );
  }

  Widget _buildDetailRow({
    required String title,
    required String value,
    TextStyle? valueStyle,
  }) {
    return Padding(
      padding: const EdgeInsets.symmetric(vertical: 8),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Text(
            title,
            style: const TextStyle(
              fontFamily: "Poppins",
              fontSize: 14,
              fontWeight: FontWeight.w400,
              color: Color(0xFF777777),
            ),
          ),
          Row(
            children: [
              if (value == "Paid")
                SvgPicture.asset(
                  "assets/svg/success_ic.svg",
                  height: 18,
                  width: 18,
                ),
              if (value == "Pending")
                SvgPicture.asset(
                  "assets/svg/failed_ic.svg",
                  height: 18,
                  width: 18,
                ),
              const SizedBox(width: 4),
              Text(
                value,
                style: valueStyle ?? const TextStyle(
                  fontFamily: "Poppins",
                  fontSize: 14,
                  fontWeight: FontWeight.w400,
                  color: AppColors.normalText,
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
