import 'package:flutter/foundation.dart';
import '../Models/DashboardResponse.dart';
import '../Services/api_calling.dart';

class DashboardProvider with ChangeNotifier {
  DashboardResponse? _dashboardData;
  bool _isLoading = false;
  String? _errorMessage;

  // Getters
  DashboardResponse? get dashboardData => _dashboardData;
  bool get isLoading => _isLoading;
  String? get errorMessage => _errorMessage;

  /// Fetch Dashboard API
  Future<void> fetchDashboard({
    required String accId,
    required String sessionId,
  }) async {
    _isLoading = true;
    _errorMessage = null;
    notifyListeners();

    try {
      final response =
      await ApiCalling.fetchDashboardApi(accId, sessionId);

      if (response != null) {
        _dashboardData = response;
      } else {
        _errorMessage = "No data received from server.";
      }
    } catch (e) {
      _errorMessage = "Failed to load dashboard: $e";
    }

    _isLoading = false;
    notifyListeners();
  }

  /// To clear data (optional)
  void clearDashboard() {
    _dashboardData = null;
    _errorMessage = null;
    notifyListeners();
  }
}
