class OrderDetailsBillResponse {
  List<Bill>? bill;
  int? error;
  String? message;

  OrderDetailsBillResponse({this.bill, this.error, this.message});

  OrderDetailsBillResponse.fromJson(Map<String, dynamic> json) {
    if (json['bill'] != null) {
      bill = <Bill>[];
      json['bill'].forEach((v) {
        bill!.add(new Bill.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.bill != null) {
      data['bill'] = this.bill!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}

class Bill {
  String? totalAmount;
  String? datetime;
  String? billNarration;
  String? billId;

  Bill({this.totalAmount, this.datetime, this.billNarration, this.billId});

  Bill.fromJson(Map<String, dynamic> json) {
    totalAmount = json['total_amount'];
    datetime = json['datetime'];
    billNarration = json['bill_narration'];
    billId = json['bill_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['total_amount'] = this.totalAmount;
    data['datetime'] = this.datetime;
    data['bill_narration'] = this.billNarration;
    data['bill_id'] = this.billId;
    return data;
  }
}
