class OrderDetailsMainResponse {
  List<Bill>? bill;
  int? error;
  String? message;

  OrderDetailsMainResponse({this.bill, this.error, this.message});

  OrderDetailsMainResponse.fromJson(Map<String, dynamic> json) {
    if (json['bill'] != null) {
      bill = <Bill>[];
      json['bill'].forEach((v) {
        bill!.add(new Bill.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.bill != null) {
      data['bill'] = this.bill!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}

class Bill {
  String? dispAddress;
  String? tenure;

  Bill({this.dispAddress, this.tenure});

  Bill.fromJson(Map<String, dynamic> json) {
    dispAddress = json['disp_address'];
    tenure = json['tenure'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['disp_address'] = this.dispAddress;
    data['tenure'] = this.tenure;
    return data;
  }
}
