class RentalPaymentDetailsResponse {
  List<Bill>? bill;
  int? error;
  String? message;

  RentalPaymentDetailsResponse({this.bill, this.error, this.message});

  RentalPaymentDetailsResponse.fromJson(Map<String, dynamic> json) {
    if (json['bill'] != null) {
      bill = <Bill>[];
      json['bill'].forEach((v) {
        bill!.add(new Bill.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.bill != null) {
      data['bill'] = this.bill!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}

class Bill {
  String? narration;
  String? amount;
  String? mode;
  String? ref;
  String? datetime;

  Bill({this.narration, this.amount, this.mode, this.ref, this.datetime});

  Bill.fromJson(Map<String, dynamic> json) {
    narration = json['narration'];
    amount = json['amount'];
    mode = json['mode'];
    ref = json['ref'];
    datetime = json['datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['narration'] = this.narration;
    data['amount'] = this.amount;
    data['mode'] = this.mode;
    data['ref'] = this.ref;
    data['datetime'] = this.datetime;
    return data;
  }
}
