class BillListResponse {
  int? error;
  List<Bills>? bills;
  LatestBill? latestBill;
  String? message;
  int? sessionExists;

  BillListResponse(
      {this.error,
        this.bills,
        this.latestBill,
        this.message,
        this.sessionExists});

  BillListResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['bills'] != null) {
      bills = <Bills>[];
      json['bills'].forEach((v) {
        bills!.add(new Bills.fromJson(v));
      });
    }
    latestBill = json['latest_bill'] != null
        ? new LatestBill.fromJson(json['latest_bill'])
        : null;
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    if (this.bills != null) {
      data['bills'] = this.bills!.map((v) => v.toJson()).toList();
    }
    if (this.latestBill != null) {
      data['latest_bill'] = this.latestBill!.toJson();
    }
    data['message'] = this.message;
    data['session_exists'] = this.sessionExists;
    return data;
  }
}

class Bills {
  String? id;
  String? billNumber;
  String? orderId;
  String? narration;
  String? totalPrice;
  String? billDate;

  Bills(
      {this.id,
        this.billNumber,
        this.orderId,
        this.narration,
        this.totalPrice,
        this.billDate});

  Bills.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    billNumber = json['bill_number'];
    orderId = json['order_id'];
    narration = json['narration'];
    totalPrice = json['total_price'];
    billDate = json['bill_date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['bill_number'] = this.billNumber;
    data['order_id'] = this.orderId;
    data['narration'] = this.narration;
    data['total_price'] = this.totalPrice;
    data['bill_date'] = this.billDate;
    return data;
  }
}

class LatestBill {
  String? id;
  String? billNumber;
  String? orderId;
  String? narration;
  String? totalPrice;
  String? billDate;
  String? billPaid;

  LatestBill(
      {this.id,
        this.billNumber,
        this.orderId,
        this.narration,
        this.totalPrice,
        this.billDate,
        this.billPaid});

  LatestBill.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    billNumber = json['bill_number'];
    orderId = json['order_id'];
    narration = json['narration'];
    totalPrice = json['total_price'];
    billDate = json['bill_date'];
    billPaid = json['bill_paid'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['bill_number'] = this.billNumber;
    data['order_id'] = this.orderId;
    data['narration'] = this.narration;
    data['total_price'] = this.totalPrice;
    data['bill_date'] = this.billDate;
    data['bill_paid'] = this.billPaid;
    return data;
  }
}
