// In your widget or screen


import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';

import '../Utility/AdvancedSnackbar.dart';
import '../Utility/AppColors.dart';
import '../Utility/CustomSnackbar.dart';

class MyHomePage extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(title: Text('Snackbar Demo')),
      body: Center(
        child: Column(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            // Simple usage
            ElevatedButton(
              onPressed: () {
                CustomSnackBar.showSuccess(
                  context: context,
                  title: "Payment Successful",
                  message: "Your payment of \$99.99 has been processed successfully.",
                  action: SnackBarAction(
                    label: "VIEW RECEIPT",
                    onPressed: () {
                      // Handle action
                    },
                  ),
                );
              },
              child: Text('Show Success'),
            ),

            ElevatedButton(
              onPressed: () {
                CustomSnackBar.showError(
                  context: context,
                  message: "Network connection lost. Please check your internet.",
                  action: SnackBarAction(
                    label: "RETRY",
                    onPressed: () {
                      // Retry logic
                    },
                  ),
                );
              },
              child: Text('Show Error with Action'),
            ),

            // Advanced usage
            ElevatedButton(
              onPressed: () {
                AnimatedSnackBar.success(
                  context: context,
                  title: "Payment Successful",
                  message: "Your order has been processed successfully!",
                );
              },
              child: Text('Show Advanced Snackbar'),
            ),

            // Custom snackbar
            ElevatedButton(
              onPressed: () {
                CustomSnackBar.showError(
                  context: context,
                  message: "Network connection lost. Please check your internet.",
                  action: SnackBarAction(
                    label: "RETRY",
                    onPressed: () {
                      // Retry logic
                    },
                  ),
                );
              },
              child: Text('Show Custom Snackbar'),
            ),
          ],
        ),
      ),
    );
  }
}