import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:gen_rentals/Services/api_calling.dart';
import 'dart:convert';

import '../Models/SubscribeOrderDetailsResponse.dart';

class SubscribeOrderDetailsProvider with ChangeNotifier {
  SubscribeOrderDetailsResponse? _orderDetails;
  bool _isLoading = false;
  String _errorMessage = '';

  // Getters
  SubscribeOrderDetailsResponse? get orderDetails => _orderDetails;
  bool get isLoading => _isLoading;
  String get errorMessage => _errorMessage;

  /// Fetch Subscribe Order Details
  Future<void> fetchSubscribeOrderDetails(
      String sessionId,
      String orderId,
      String accId,
      ) async {
    _isLoading = true;
    _errorMessage = '';
    notifyListeners();

    try {
      final response = await ApiCalling.fetchSubsOrderDetailApi(
        sessionId,
        orderId,
        accId,
      );

      if (response != null) {
        // Check if error is "0" which means success in your API
        if (response.error == "0") {
          _orderDetails = response;
          _errorMessage = '';
        }
        // Handle other error cases
        else if (response.error != null && response.error!.isNotEmpty && response.error != "0") {
          _errorMessage = response.message ?? 'An error occurred';
          _orderDetails = null;
        }
        // Handle message-based errors
        else if (response.message != null &&
            response.message!.isNotEmpty &&
            !response.message!.toLowerCase().contains('success')) {
          _errorMessage = response.message!;
          _orderDetails = null;
        }
        // Default success case
        else {
          _orderDetails = response;
          _errorMessage = '';
        }
      } else {
        _errorMessage = 'Failed to load order details';
        _orderDetails = null;
      }
    } catch (e) {
      _errorMessage = 'An error occurred: $e';
      _orderDetails = null;
      debugPrint("❌ Provider Error (fetchSubscribeOrderDetails): $e");
    } finally {
      _isLoading = false;
      notifyListeners();
    }
  }

// ... rest of your provider code
}