class OrderDetailsProductResponse {
  List<Products>? products;
  int? error;
  String? message;

  OrderDetailsProductResponse({this.products, this.error, this.message});

  OrderDetailsProductResponse.fromJson(Map<String, dynamic> json) {
    if (json['products'] != null) {
      products = <Products>[];
      json['products'].forEach((v) {
        products!.add(new Products.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.products != null) {
      data['products'] = this.products!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}

class Products {
  String? pname;
  String? qty;
  String? totalAmount;
  String? type;

  Products({this.pname, this.qty, this.totalAmount, this.type});

  Products.fromJson(Map<String, dynamic> json) {
    pname = json['pname'];
    qty = json['qty'];
    totalAmount = json['total_amount'];
    type = json['type'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['pname'] = this.pname;
    data['qty'] = this.qty;
    data['total_amount'] = this.totalAmount;
    data['type'] = this.type;
    return data;
  }
}
