import 'dart:convert';
import 'package:flutter/foundation.dart';
import 'package:gen_rentals/Models/CommonResponse.dart';
import 'package:gen_rentals/Models/TicketChatDisplayResponse.dart';
import 'package:gen_rentals/Models/billListResponse.dart';
import 'package:gen_rentals/Models/billProductResponse.dart';
import 'package:gen_rentals/Models/orderDetailsBillResponse.dart';
import 'package:gen_rentals/Models/orderDetailsMainResponse.dart';
import 'package:gen_rentals/Models/orderDetailsProductResponse.dart';
import 'package:gen_rentals/Models/orderListResponse.dart';
import 'package:gen_rentals/Models/ticketListResponse.dart';
import 'package:gen_rentals/Notifier/billDetailsResponse.dart';
import '../Models/DashboardResponse.dart';
import '../Models/RentalPaymentDetailsResponse.dart';
import '../Models/rentalAccountResponse.dart';
import '../Models/rentalContactResponse.dart';
import '../Notifier/RentalContactProvider .dart';
import 'api_URLs.dart';
import 'api_post_request.dart';


class ApiCalling {


  /// Fetch rental contact by mobile number
  static Future<FetchMobileResponse?> fetchRentalMobileApi(
      String mob,
      ) async {
    debugPrint("############################### Api calling ");
    try {
      Map<String, String> data = {
        "mob": mob,
      };
      final res = await post(data, fetchMobileUrl, {});

      if (res != null) {
        return FetchMobileResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error: $e");
      return null;
    }
  }

  static Future<FetchMobileResponse?> fetchMobileOtpApi(
      String mob,
      String otp
      ) async {
    debugPrint("############################### Api calling ");
    try {
      Map<String, String> data = {
        "mob": mob,
        "otp": otp,
      };
      final res = await post(data, fetchOtpUrl, {});

      if (res != null) {
        return FetchMobileResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error: $e");
      return null;
    }
  }


  /// Fetch Rental Account Info
  static Future<RentalAccountResponse?> fetchRentalAccountInfoApi(
      String sessionId,
      String empId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
      };

      final res = await post(data, getRentalAccInfoUrl, {});

      if (res != null) {
        return RentalAccountResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetchRentalAccountInfo): $e");
      return null;
    }
  }

  /// Fetch Bill List
  static Future<BillListResponse?> fetchBillListApi(
      String sessionId,
      String empId,
      String accId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
        "acc_id": accId,
      };

      final res = await post(data, billListUrl, {});

      if (res != null) {
        return BillListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetchBillList): $e");
      return null;
    }
  }

  /// Fetch Bill Details
  static Future<BillDetailsResponse?> fetchBillDetailsApi(
      String sessionId,
      String empId,
      String billId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
        "bill_id": billId,
      };

      final res = await post(data, billDetailsUrl, {});

      if (res != null) {
        return BillDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetchBillDetails): $e");
      return null;
    }
  }


  /// Fetch Bill Product
  static Future<BillProductResponse?> fetchBillProductApi(
      String sessionId,
      String empId,
      String accId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
        "acc_id": accId,
      };

      final res = await post(data, billProductUrl, {});

      if (res != null) {
        return BillProductResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetchBillProduct): $e");
      return null;
    }
  }

  /// Fetch Order Detail Bill
  static Future<OrderDetailsBillResponse?> fetchOrderDetailBillApi(
      String sessionId,
      String empId,
      String orderId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
        "ord_id": orderId,
      };

      final res = await post(data, orderDetailsBillUrl, {});

      if (res != null) {
        return OrderDetailsBillResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetchOrderDetailBill): $e");
      return null;
    }
  }

  /// Fetch Order List
  static Future<OrderListResponse?> fetchOrderListApi(
      String sessionId,
      String empId,
      String accId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
        "acc_id": accId,
      };

      final res = await post(data, orderListUrl, {});

      if (res != null) {
        return OrderListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetchOrderList): $e");
      return null;
    }
  }


  /// Fetch Order Details Product
  static Future<OrderDetailsProductResponse?> fetchOrderDetailProductApi(
      String sessionId,
      String empId,
      String orderId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
        "order_id": orderId,
      };

      final res = await post(data, orderDetailsProductUrl, {});

      if (res != null) {
        return OrderDetailsProductResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetchOrderDetailProduct): $e");
      return null;
    }
  }

  /// Fetch Order Details Main
  static Future<OrderDetailsMainResponse?> fetchOrderDetailMainApi(
      String sessionId,
      String empId,
      String orderId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
        "ord_id": orderId,
      };

      final res = await post(data, orderDetailsMainUrl, {});

      if (res != null) {
        return OrderDetailsMainResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetchOrderDetailMain): $e");
      return null;
    }
  }

  /// Fetch Rental Payment Details
  static Future<RentalPaymentDetailsResponse?> fetchRentalPaymentDetailsApi(
      String sessionId,
      String empId,
      String billId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
        "bill_id": billId,
      };

      final res = await post(data, rentalPaymentDetailsUrl, {});

      if (res != null) {
        return RentalPaymentDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetchRentalPaymentDetails): $e");
      return null;
    }
  }


  /// Fetch Ticket List
  static Future<TicketListResponse?> fetchTicketListApi(
      String sessionId,
      String empId,
      String accId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
        "acc_id": accId,
      };

      final res = await post(data, ticketListUrl, {});

      if (res != null) {
        return TicketListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetchTicketList): $e");
      return null;
    }
  }

  /// Fetch Ticket Chat Display
  static Future<TicketChatDisplayResponse?> fetchTicketChatDisplayApi(
      String sessionId,
      String empId,
      String ticId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
        "tic_id": ticId,
      };

      final res = await post(data, ticketChatDisplayUrl, {});

      if (res != null) {
        return TicketChatDisplayResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetchTicketChatDisplay): $e");
      return null;
    }
  }

  /// Fetch Tag Order
  static Future<CommonResponse?> fetchTagOrderApi(
      String sessionId,
      String empId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,

      };

      final res = await post(data, tagOrderUrl, {});

      if (res != null) {
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetchTagOrder): $e");
      return null;
    }
  }

  /// Fetch Raise Ticket
  static Future<CommonResponse?> fetchRaiseTicketApi(
      String sessionId,
      String empId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,

      };

      final res = await post(data, raiseTicketUrl, {});

      if (res != null) {
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (raise Ticket): $e");
      return null;
    }
  }

  /// Fetch CheckInOut Submit
  static Future<CommonResponse?> fetchCheckInOutSubmitApi(
      String sessionId,
      String empId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,

      };

      final res = await post(data, checkInOutSubmitUrl, {});

      if (res != null) {
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (CheckInOutSubmit): $e");
      return null;
    }
  }

  /// Fetch Balance
  static Future<CommonResponse?> fetchBalanceApi(
      String sessionId,
      String empId,
      String accId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
        "acc_id": accId,
      };

      final res = await post(data, balanceUrl, {});

      if (res != null) {
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetch Balance): $e");
      return null;
    }
  }

  /// Add Payment
  static Future<CommonResponse?> fetchAddPaymentApi(
      String sessionId,
      String empId,
      String amount,
      String orderId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
        "amount": amount,
        "order_id": orderId,
      };

      final res = await post(data, addPaymentUrl, {});

      if (res != null) {
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (AddPaymentApi): $e");
      return null;
    }
  }


  /// Add Fcm Token
  static Future<CommonResponse?> fetchAddFcmTokenApi(
      String sessionId,
      String empId,
      String amount,
      String orderId,
      ) async {
    try {
      Map<String, String> data = {
        "session_id": sessionId,
        "emp_id": empId,
        "amount": amount,
        "order_id": orderId,
      };

      final res = await post(data, addFcmTokenUrl, {});

      if (res != null) {
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetch Add Payment Api): $e");
      return null;
    }
  }

  /// Fetch Dashboard
  static Future<DashboardResponse?> fetchDashboardApi(
      String accId,
      ) async {
    debugPrint("Dashboard Api called ##############");
    try {
      Map<String, String> data = {
        "acc_id": accId,
      };

      debugPrint("Account Id : $accId");

      final res = await post(data, dashboardUrl, {});
      debugPrint(res?.body);

      if (res != null) {
        return DashboardResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint("❌ API Error (fetch Balance): $e");
      return null;
    }
  }



}
