class BillListResponse {
  List<Bills>? bills;
  int? error;
  String? message;

  BillListResponse({this.bills, this.error, this.message});

  BillListResponse.fromJson(Map<String, dynamic> json) {
    if (json['bills'] != null) {
      bills = <Bills>[];
      json['bills'].forEach((v) {
        bills!.add(new Bills.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.bills != null) {
      data['bills'] = this.bills!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}

class Bills {
  String? datetime;
  String? billNarration;
  String? totalAmount;
  String? billId;
  String? type;

  Bills(
      {this.datetime,
        this.billNarration,
        this.totalAmount,
        this.billId,
        this.type});

  Bills.fromJson(Map<String, dynamic> json) {
    datetime = json['datetime'];
    billNarration = json['bill_narration'];
    totalAmount = json['total_amount'];
    billId = json['bill_id'];
    type = json['type'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['datetime'] = this.datetime;
    data['bill_narration'] = this.billNarration;
    data['total_amount'] = this.totalAmount;
    data['bill_id'] = this.billId;
    data['type'] = this.type;
    return data;
  }
}
