class DashboardResponse {
  String? error;
  String? raname;
  String? balanceAmount;
  String? message;
  List<Products>? products;

  DashboardResponse(
      {this.error,
        this.raname,
        this.balanceAmount,
        this.message,
        this.products});

  DashboardResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    raname = json['raname'];
    balanceAmount = json['balance_amount'];
    message = json['message'];
    if (json['products'] != null) {
      products = <Products>[];
      json['products'].forEach((v) {
        products!.add(new Products.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['raname'] = this.raname;
    data['balance_amount'] = this.balanceAmount;
    data['message'] = this.message;
    if (this.products != null) {
      data['products'] = this.products!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Products {
  String? orderid;
  String? productName;
  String? productImage;
  String? plan;
  String? rentedDate;
  String? expiringInColor;
  String? expiringText;
  String? address;
  bool? hasPendingPayment;
  String? pendingPaymentText;

  Products(
      {this.orderid,
        this.productName,
        this.productImage,
        this.plan,
        this.rentedDate,
        this.expiringInColor,
        this.expiringText,
        this.address,
        this.hasPendingPayment,
        this.pendingPaymentText});

  Products.fromJson(Map<String, dynamic> json) {
    orderid = json['orderid'];
    productName = json['productName'];
    productImage = json['productImage'];
    plan = json['plan'];
    rentedDate = json['rentedDate'];
    expiringInColor = json['ExpiringInColor'];
    expiringText = json['expiringText'];
    address = json['address'];
    hasPendingPayment = json['hasPendingPayment'];
    pendingPaymentText = json['pendingPaymentText'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['orderid'] = this.orderid;
    data['productName'] = this.productName;
    data['productImage'] = this.productImage;
    data['plan'] = this.plan;
    data['rentedDate'] = this.rentedDate;
    data['ExpiringInColor'] = this.expiringInColor;
    data['expiringText'] = this.expiringText;
    data['address'] = this.address;
    data['hasPendingPayment'] = this.hasPendingPayment;
    data['pendingPaymentText'] = this.pendingPaymentText;
    return data;
  }
}
