class BillProductResponse {
  List<Bp>? bp;
  int? error;
  String? message;

  BillProductResponse({this.bp, this.error, this.message});

  BillProductResponse.fromJson(Map<String, dynamic> json) {
    if (json['bp'] != null) {
      bp = <Bp>[];
      json['bp'].forEach((v) {
        bp!.add(new Bp.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.bp != null) {
      data['bp'] = this.bp!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}

class Bp {
  String? pname;
  String? qty;
  String? totalAmount;

  Bp({this.pname, this.qty, this.totalAmount});

  Bp.fromJson(Map<String, dynamic> json) {
    pname = json['pname'];
    qty = json['qty'];
    totalAmount = json['total_amount'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['pname'] = this.pname;
    data['qty'] = this.qty;
    data['total_amount'] = this.totalAmount;
    return data;
  }
}
