import 'package:flutter/material.dart';
import 'package:gen_rentals/Utility/AppColors.dart';
import 'package:flutter_svg/flutter_svg.dart';
import '../Utility/Reusablewidgets.dart';

class BillDetailListScreen extends StatefulWidget {
  const BillDetailListScreen({super.key});

  @override
  State<BillDetailListScreen> createState() => _BillDetailListScreenState();
}

class _BillDetailListScreenState extends State<BillDetailListScreen> {
  @override
  Widget build(BuildContext context) {
    return SafeArea(
      top: false,
      child: Scaffold(
        appBar: AppBar(
          automaticallyImplyLeading: false,
          backgroundColor: Colors.white,
          title: Row(
            children: [
              InkResponse(
                onTap: () => Navigator.pop(context, true),
                child: SvgPicture.asset(
                  "assets/svg/continue_left_ic.svg",
                  height: 25,
                ),
              ),
              const SizedBox(width: 10),
              const Text(
                "Bill List",
                style: TextStyle(
                  fontSize: 16,
                  fontFamily: "Plus Jakarta Sans",
                  fontWeight: FontWeight.w600,
                  color: Colors.black87,
                ),
              ),
            ],
          ),
        ),
        backgroundColor: AppColors.backgroundRegular,
        body: Container(
          padding: const EdgeInsets.symmetric(horizontal: 14, vertical: 14),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              SectionHeading(title: 'Latest Bill', padding: EdgeInsets.symmetric(horizontal: 0, vertical: 6),),

              const SizedBox(height: 12),

              // Latest Bill Card
              InkResponse(
                onTap:  () => showPaymentBottomSheet(context),
                child: Container(
                  width: double.infinity,
                  padding: const EdgeInsets.all(20),
                  decoration: BoxDecoration(
                    borderRadius: BorderRadius.circular(16), // Slightly smaller radius
                    gradient: const LinearGradient(
                      begin: Alignment.topLeft,
                      end: Alignment.bottomRight,
                      colors: [
                        Color(0xFFE9FFDD),
                        Color(0xFFB5FFD1),
                      ],
                    ),
                  ),
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Text(
                            "₹24,800",
                            style: TextStyle(
                              fontFamily: "Poppins",
                              color: AppColors.cardAmountText,
                              fontSize: 34,
                              fontWeight: FontWeight.w500,
                            ),
                          ),
                          Container(
                            padding: const EdgeInsets.symmetric(horizontal: 12, vertical: 6),
                            decoration: BoxDecoration(
                              // color: Colors.white.withOpacity(0.12),
                              borderRadius: BorderRadius.circular(12),
                            ),
                            child: Row(
                              children: [
                                SvgPicture.asset(
                                  "assets/svg/success_ic.svg",
                                  height: 18,
                                  width: 18,
                                ),
                                const SizedBox(width: 6),
                                Text(
                                  "Bill Paid",
                                  style: TextStyle(
                                    fontFamily: "Poppins",
                                    color: const Color(0xFF212121),
                                    fontSize: 14,
                                    fontWeight: FontWeight.w400,
                                  ),
                                ),
                              ],
                            ),
                          ),
                        ],
                      ),
                      const SizedBox(height: 16),

                      // Divider
                      Container(
                        height: 1,
                        color: const Color(0xFF777777).withOpacity(0.3),
                      ),
                      const SizedBox(height: 12),

                      // Bill Cycle
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Text(
                            "Invoice raised against",
                            style: TextStyle(
                              fontFamily: "Poppins",
                              color: AppColors.normalText,
                              fontWeight: FontWeight.w400,
                              fontSize: 12,
                            ),
                          ),
                          Text(
                            "#1253", // Fixed date range
                            style: TextStyle(
                              fontFamily: "Poppins",
                              color: AppColors.amountText,
                              fontWeight: FontWeight.w400, // Medium for dates
                              fontSize: 12,
                            ),
                          ),
                        ],
                      ),

                      SizedBox(height: 4,),
                      Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Text(
                            "order ID: 1253",
                            style: TextStyle(
                              fontFamily: "Poppins",
                              color: AppColors.normalText,
                              fontWeight: FontWeight.w400,
                              fontSize: 12,
                            ),
                          ),
                          Text(
                            "7th Oct 2025", // Fixed date range
                            style: TextStyle(
                              fontFamily: "Poppins",
                              color: AppColors.normalText,
                              fontWeight: FontWeight.w400, // Medium for dates
                              fontSize: 12,
                            ),
                          ),
                        ],
                      ),
                    ],
                  ),
                ),
              ),

              const SizedBox(height: 24),

              const SectionHeading(
                title: 'All Previous Bills',
                padding: EdgeInsets.symmetric(vertical: 8),
              ),
              const SizedBox(height: 8),

              // Bill List
              Expanded(
                child: ListView(
                  children: [
                    _buildBillItem(
                      fromDate: "7th Sep 2025",
                      toDate: "7th Oct 2025",
                      amount: "4,220",
                    ),
                    const SizedBox(height: 8),
                    _buildBillItem(
                      fromDate: "7th Aug 2025",
                      toDate: "7th Sep 2025",
                      amount: "5,448",
                    ),
                    const SizedBox(height: 8),
                    _buildBillItem(
                      fromDate: "7th Jul 2025",
                      toDate: "7th Aug 2025",
                      amount: "5,448",
                    ),
                  ],
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }

  Widget _buildBillItem({
    String orderId = "#1253",
    String title = "Invoice raised against",
    required String fromDate,
    required String toDate,
    required String amount,
  }) {
    return Container(
      padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
      decoration: BoxDecoration(
        color: Colors.grey.shade50,
        borderRadius: BorderRadius.circular(18),
        // border: Border.all(
        //   color: Colors.grey.shade200,
        //   width: 1,
        // ),
        // boxShadow: [
        //   BoxShadow(
        //     color: Colors.black.withOpacity(0.05),
        //     blurRadius: 8,
        //     offset: const Offset(0, 2),
        //   ),
        // ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [

          Text(
            orderId,
            style: TextStyle(
              fontFamily: "Poppins",
              color: AppColors.amountText,
              fontWeight: FontWeight.w400,
              fontSize: 12,
            ),
          ),
          const SizedBox(height: 2),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Text(
                title,
                style: TextStyle(
                  fontFamily: "Poppins",
                  color: AppColors.normalText,
                  fontWeight: FontWeight.w400,
                  fontStyle: FontStyle.normal,
                  fontSize: 14,
                ),
              ),

              Text(
                "₹$amount",
                style: TextStyle(
                  fontFamily: "Poppins",
                  color: AppColors.amountText,
                  fontSize: 18,
                  fontWeight: FontWeight.w500,
                ),
              ),

            ],
          ),
          const SizedBox(height: 2),
          Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Text(
                "$fromDate - $toDate",
                style: TextStyle(
                  fontFamily: "Poppins",
                  color: AppColors.normalText,
                  fontWeight: FontWeight.w400,
                  fontStyle: FontStyle.normal,
                  fontSize: 14,
                ),
              ),

              Text(
                "₹$amount",
                style: TextStyle(
                  fontFamily: "Poppins",
                  color: AppColors.amountText,
                  fontSize: 18,
                  fontWeight: FontWeight.w500,
                ),
              ),

            ],
          ),
        ],
      ),
    );
  }

  void showPaymentBottomSheet(BuildContext context) {
    showModalBottomSheet(
      context: context,
      isScrollControlled: true,
      backgroundColor: Colors.transparent,
      builder: (BuildContext context) {
        return Container(
          decoration: const BoxDecoration(
            color: Colors.white,
            borderRadius: BorderRadius.only(
              topLeft: Radius.circular(24),
              topRight: Radius.circular(24),
            ),
          ),
          child: Padding(
            padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
            child: Column(
              mainAxisSize: MainAxisSize.min,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                // Header - Drag handle
                Center(
                  child: Container(
                    width: 40,
                    height: 4,
                    decoration: BoxDecoration(
                      color: Colors.grey.shade300,
                      borderRadius: BorderRadius.circular(2),
                    ),
                  ),
                ),
                const SizedBox(height: 20),

                Row(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Text(
                      "₹4218",
                      style: TextStyle(
                        fontFamily: "Poppins",
                        fontSize: 32,
                        fontWeight: FontWeight.w500,
                        color: AppColors.cardAmountText,
                      ),
                    ),
                    Row(
                      children: [
                        SvgPicture.asset(
                          "assets/svg/success_ic.svg",
                          height: 18,
                          width: 18,
                        ),
                        const SizedBox(width: 6),
                        const Text(
                          "Bill Paid",
                          style: TextStyle(
                            fontFamily: "Poppins",
                            color: Color(0xFF212121),
                            fontSize: 14,
                            fontWeight: FontWeight.w400,
                          ),
                        ),
                      ],
                    ),
                  ],
                ),

                const SizedBox(height: 10),
                const Divider(height: 1, color: Color(0xFFEEEEEE)),
                const SizedBox(height: 6),

                const SectionHeading(title: "Bill Details"),

                _buildDetailRow(title: "Total Amount", value: "₹421"),
                _buildDetailRow(title: "Bill Cycle", value: "7th Sep,2025 - 7th Oct, 2025"),
                _buildDetailRow(title: "Bill Generated Date", value: "8th Oct, 2025"),
                _buildDetailRow(title: "Payable Amount", value: "₹421"),
                _buildDetailRow(title: "Paid Date/Due Date", value: "7th Oct, 2025"),

                const SizedBox(height: 6),
                const Divider(height: 1, color: Color(0xFFEEEEEE)),
                const SizedBox(height: 14),

                // Buttons Row
                Row(
                  children: [
                    // Download Bill Button - White background
                    Expanded(
                      child: Container(
                        margin: const EdgeInsets.only(right: 8),
                        child: ElevatedButton(
                          onPressed: () {
                            // Handle download bill
                          },
                          style: ElevatedButton.styleFrom(
                            backgroundColor: Colors.white, // White background
                            foregroundColor: const Color(0xFF008CDE), // Blue text
                            side: const BorderSide(
                              color: AppColors.subtitleText, // Blue border
                              width: 1,
                            ),
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(30),
                            ),
                            padding: const EdgeInsets.symmetric(vertical: 16),
                            elevation: 0,
                          ),
                          child: const Padding(
                            padding: EdgeInsets.symmetric(horizontal: 10),
                            child: Text(
                              "Download Bill",
                              style: TextStyle(
                                color: AppColors.normalText,
                                fontSize: 16,
                                fontWeight: FontWeight.w500,
                              ),
                            ),
                          ),
                        ),
                      ),
                    ),

                    // Continue Payment Button - Blue background
                    Expanded(
                      child: Container(
                        margin: const EdgeInsets.only(left: 8),
                        child: ElevatedButton(
                          onPressed: () {
                            // Handle continue payment
                          },
                          style: ElevatedButton.styleFrom(
                            backgroundColor: const Color(0xFF008CDE),
                            foregroundColor: Colors.white,
                            shape: RoundedRectangleBorder(
                              borderRadius: BorderRadius.circular(30),
                            ),
                            padding: const EdgeInsets.symmetric(vertical: 16),
                          ),
                          child: Padding(
                            padding: const EdgeInsets.symmetric(horizontal: 10),
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              children: [
                                const Text(
                                  "Pay Now",
                                  style: TextStyle(
                                    color: Color(0xFFFFFFFF),
                                    fontSize: 16,
                                    fontWeight: FontWeight.w500,
                                  ),
                                ),
                                const SizedBox(width: 8),
                                SvgPicture.asset(
                                  "assets/svg/continue_ic.svg",
                                  color: const Color(0xFFFFFFFF),
                                  height: 20,
                                  width: 20,
                                ),
                              ],
                            ),
                          ),
                        ),
                      ),
                    ),
                  ],
                ),

                const SizedBox(height: 8),
              ],
            ),
          ),
        );
      },
    );
  }

  Widget _buildDetailRow({
    required String title,
    required String value,
    TextStyle? valueStyle,
  }) {
    return Padding(
      padding: const EdgeInsets.symmetric(vertical: 8, horizontal: 12),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Text(
            title,
            style: const TextStyle(
              fontFamily: "Poppins",
              fontSize: 14,
              fontWeight: FontWeight.w400,
              color: Color(0xFF777777),
            ),
          ),
          Row(
            children: [
              if (value == "Paid")
                SvgPicture.asset(
                  "assets/svg/success_ic.svg",
                  height: 18,
                  width: 18,
                ),
              if (value == "Pending")
                SvgPicture.asset(
                  "assets/svg/failed_ic.svg",
                  height: 18,
                  width: 18,
                ),
              const SizedBox(width: 4),
              Text(
                value,
                style: valueStyle ?? const TextStyle(
                  fontFamily: "Poppins",
                  fontSize: 14,
                  fontWeight: FontWeight.w400,
                  color: AppColors.normalText,
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }

}