class SubscribeOrderDetailsResponse {
  String? orderid;
  String? orderNum;
  String? rentedDate;
  String? expiringInColor;
  String? expiringText;
  List<Products>? products;
  String? error;
  String? message;

  SubscribeOrderDetailsResponse(
      {this.orderid,
        this.orderNum,
        this.rentedDate,
        this.expiringInColor,
        this.expiringText,
        this.products,
        this.error,
        this.message});

  SubscribeOrderDetailsResponse.fromJson(Map<String, dynamic> json) {
    orderid = json['orderid'];
    orderNum = json['order_num'];
    rentedDate = json['rentedDate'];
    expiringInColor = json['ExpiringInColor'];
    expiringText = json['expiringText'];
    if (json['products'] != null) {
      products = <Products>[];
      json['products'].forEach((v) {
        products!.add(new Products.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['orderid'] = this.orderid;
    data['order_num'] = this.orderNum;
    data['rentedDate'] = this.rentedDate;
    data['ExpiringInColor'] = this.expiringInColor;
    data['expiringText'] = this.expiringText;
    if (this.products != null) {
      data['products'] = this.products!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}

class Products {
  String? id;
  String? idName;
  String? prodName;
  String? totalPrice;
  String? per;
  String? dispatchDate;
  String? receivedDate;

  Products(
      {this.id,
        this.idName,
        this.prodName,
        this.totalPrice,
        this.per,
        this.dispatchDate,
        this.receivedDate});

  Products.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    idName = json['id_name'];
    prodName = json['prod_name'];
    totalPrice = json['total_price'];
    per = json['per'];
    dispatchDate = json['dispatch_date'];
    receivedDate = json['received_date'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['id_name'] = this.idName;
    data['prod_name'] = this.prodName;
    data['total_price'] = this.totalPrice;
    data['per'] = this.per;
    data['dispatch_date'] = this.dispatchDate;
    data['received_date'] = this.receivedDate;
    return data;
  }
}
