class RentalAccountResponse {
  List<Account>? account;
  int? error;
  String? message;

  RentalAccountResponse({this.account, this.error, this.message});

  RentalAccountResponse.fromJson(Map<String, dynamic> json) {
    if (json['account'] != null) {
      account = <Account>[];
      json['account'].forEach((v) {
        account!.add(new Account.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.account != null) {
      data['account'] = this.account!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}

class Account {
  String? id;
  String? name;
  String? address;

  Account({this.id, this.name, this.address});

  Account.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    address = json['address'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['id'] = this.id;
    data['name'] = this.name;
    data['address'] = this.address;
    return data;
  }
}
