import 'package:flutter/material.dart';
import 'package:gen_rentals/Utility/Reusablewidgets.dart';
import '../../Utility/AppColors.dart';
import 'package:flutter_svg/flutter_svg.dart';

import '../../Utility/SharedpreferencesService.dart';
import '../DashboardScreen.dart';

class PaymentSuccessFaillScreen extends StatefulWidget {
  final String total;
  final String date;
  final String payMode;
  final String status;




   const PaymentSuccessFaillScreen({
     super.key,
     required this.total,
     required this.date,
     required this.payMode,
     required this.status,
  });

  @override
  State<PaymentSuccessFaillScreen> createState() => _PaymentSuccessFaillScreenState();
}

class _PaymentSuccessFaillScreenState extends State<PaymentSuccessFaillScreen> {
  final prefs = SharedPreferencesService.instance;
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppColors.backgroundRegular,
      body: SafeArea(
        child: SingleChildScrollView(
          child: Container(
            padding: const EdgeInsets.symmetric(horizontal: 18, vertical: 14),
            decoration: const BoxDecoration(
              gradient: LinearGradient(
                begin: Alignment.topCenter,
                end: Alignment.bottomCenter,
                colors: [
                  Color(0xFFFFFFFF),
                  Color(0xFFFFFFFF),
                  AppColors.backgroundRegular,
                  AppColors.backgroundRegular,
                  AppColors.backgroundRegular
                ],
              ),
            ),
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.center,
              children: [
                const SizedBox(height: 40),

                // Success Icon
                if (widget.status == "Success")
                Container(
                  width: double.infinity,
                  height: 140,
                  color: Colors.white,
                  child: Image.asset(
                    'assets/images/success_pay_gif.gif',
                    height: 80,
                    width: 80,
                  ),
                ),
                if (widget.status == "Fail")
                  Container(
                    width: double.infinity,
                    height: 140,
                    color: Colors.white,
                    child: Image.asset(
                      'assets/images/failed_pay_gif.gif',
                      height: 80,
                      width: 80,
                    ),
                  ),


                const SizedBox(height: 24),

                // Success Title
                if (widget.status == "Success")
                const Text(
                  "Payment Successful",
                  style: TextStyle(
                    fontSize: 24,
                    fontWeight: FontWeight.w500,
                    color: AppColors.normalText,
                  ),
                ),
                if (widget.status == "Fail")
                  const Text(
                    "Payment Failed",
                    style: TextStyle(
                      fontSize: 24,
                      fontWeight: FontWeight.w500,
                      color: AppColors.normalText,
                    ),
                  ),

                const SizedBox(height: 8),

                // Success Message
                if (widget.status == "Success")
                Text(
                  "Now enjoy a seamless,\nuninterrupted rental service.",
                  textAlign: TextAlign.center,
                  style: TextStyle(
                    fontFamily: "Poppins",
                    fontSize: 16,
                    fontWeight: FontWeight.w400,
                    color: AppColors.subtitleText,
                    height: 1.5,
                  ),
                ),
                if (widget.status == "Fail")
                  Text(
                    "There may be an issue with your,\n Payment, please try again.",
                    textAlign: TextAlign.center,
                    style: TextStyle(
                      fontFamily: "Poppins",
                      fontSize: 16,
                      fontWeight: FontWeight.w400,
                      color: AppColors.subtitleText,
                      height: 1.5,
                    ),
                  ),


                const SizedBox(height: 22),
                Text(
                  "₹${widget.total}",
                  style: TextStyle(
                    fontSize: 34,
                    fontWeight: FontWeight.w500,
                    color: AppColors.normalText,
                  ),
                ),
                const SizedBox(height: 9),
                Divider(),
                Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    const SizedBox(height: 25),

                    SectionHeading(
                        title: "Payment Details",
                      textStyle: TextStyle(
                        fontSize: 16,
                        fontWeight: FontWeight.w500,
                        color: AppColors.normalText,
                      ),
                    ),

                    // Payment Details Section
                    _buildSection(
                      children: [
                        _buildDetailRow(title: "Date", value: "8th Oct, 2025"),
                        _buildDetailRow(title: "Payment Mode", value: widget.payMode),
                      ],
                    ),

                    const SizedBox(height: 10),
                    const SizedBox(height: 2),
                    Divider(),
                    Padding(
                      padding: const EdgeInsets.all(8.0),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          const SectionHeading(
                            title: "Total",
                            textStyle: TextStyle(
                              fontSize: 16,
                              fontWeight: FontWeight.w500,
                              color: AppColors.normalText,
                            ),
                          ),
                          Text(
                            "₹${widget.total}",
                            style: const TextStyle(
                              fontSize: 14,
                              fontWeight: FontWeight.w500,
                              color: AppColors.normalText,
                            ),
                          )
                        ],
                      ),
                    )
                  ],
                ),

                const SizedBox(height: 110),
                if (widget.status == "Fail")
                SizedBox(
                  width: double.infinity,
                  child: ElevatedButton(
                    onPressed: () {
                      // Add navigation logic here
                      Navigator.pop(context);
                    },
                    style: ElevatedButton.styleFrom(
                      backgroundColor: AppColors.buttonColor,
                      foregroundColor: Colors.white,
                      shape: RoundedRectangleBorder(
                        borderRadius: BorderRadius.circular(30),
                      ),
                      padding: const EdgeInsets.symmetric(vertical: 16),
                    ),
                    child: Padding(
                      padding: const EdgeInsets.symmetric(horizontal: 22),
                      child: Text(
                        "Pay Now",
                        style: TextStyle(
                          fontFamily: "Poppins",
                          color: Color(0xFFFFFFFF),
                          fontSize: 16,
                          fontWeight: FontWeight.w500,
                        ),
                      ),
                    ),
                  ),
                ),

                const SizedBox(height: 20),
              ],
            ),
          ),
        ),
      ),
      bottomNavigationBar: Padding(
        padding: const EdgeInsets.all(16.0),
        child: SizedBox(
          width: double.infinity,
          child: ElevatedButton(
            onPressed: () async {
              final String? savedAccId = await prefs.getString("accId");
              final String? savedSessionId = await prefs.getString("session_id");
              // Add navigation logic here
              Navigator.pop(context);
              Navigator.push(
                  context,
                  MaterialPageRoute(
                      builder: (context) => DashboardScreen(sessionId: savedSessionId!, accId: savedAccId.toString(),)
                  )
                //route
              );
            },
            style: ElevatedButton.styleFrom(
              backgroundColor: widget.status == "Fail" ? AppColors.backgroundRegular : AppColors.buttonColor,
              foregroundColor: Colors.white,
              shape: RoundedRectangleBorder(
                borderRadius: BorderRadius.circular(30),
              ),
              padding: const EdgeInsets.symmetric(vertical: 16),
            ),
            child: Padding(
              padding: const EdgeInsets.symmetric(horizontal: 22),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.center,
                children: [
                  SvgPicture.asset(
                    "assets/svg/homes_ic.svg",
                    color: widget.status == "Fail" ? Colors.blue : Color(0xFFFFFFFF),
                    height: 22,
                    width: 22,
                  ),
                  SizedBox(width: 12),
                  Text(
                    "Back to Home",
                    style: TextStyle(
                      fontFamily: "Poppins",
                      color: widget.status == "Fail" ? Colors.blue : Color(0xFFFFFFFF),
                      fontSize: 16,
                      fontWeight: FontWeight.w500,
                    ),
                  ),
                ],
              ),
            ),
          ),
        ),
      ),
    );
  }

  Widget _buildSection({
    required List<Widget> children,
  }) {
    return Container(
      width: double.infinity,
      padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 6),
      decoration: BoxDecoration(
        color: const Color(0x11F8F9FA),
        borderRadius: BorderRadius.circular(18),
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: children,
      ),
    );
  }

  Widget _buildDetailRow({
    required String title,
    required String value,
    TextStyle? valueStyle,
  }) {
    return Padding(
      padding: const EdgeInsets.symmetric(vertical: 8),
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Text(
            title,
            style: const TextStyle(
              fontFamily: "Poppins",
              fontSize: 14,
              fontWeight: FontWeight.w400,
              color: Color(0xFF777777),
            ),
          ),
          Row(
            children: [
              if (value == "Paid")
                SvgPicture.asset(
                  "assets/svg/success_ic.svg",
                  height: 18,
                  width: 18,
                ),
              if (value == "Pending")
                SvgPicture.asset(
                  "assets/svg/failed_ic.svg",
                  height: 18,
                  width: 18,
                ),
              const SizedBox(width: 4),
              Text(
                value,
                style: valueStyle ?? const TextStyle(
                  fontFamily: "Poppins",
                  fontSize: 14,
                  fontWeight: FontWeight.w500,
                  color: AppColors.normalText,
                ),
              ),
            ],
          ),
        ],
      ),
    );
  }
}
