class DashboardResponse {
  String? error;
  String? mobNum;
  String? raname;
  String? balanceAmount;
  String? message;
  List<Orders>? orders;
  int? sessionExists;

  DashboardResponse(
      {this.error,
        this.mobNum,
        this.raname,
        this.balanceAmount,
        this.message,
        this.orders,
        this.sessionExists});

  DashboardResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    mobNum = json['mob_num'];
    raname = json['raname'];
    balanceAmount = json['balance_amount'];
    message = json['message'];
    if (json['orders'] != null) {
      orders = <Orders>[];
      json['orders'].forEach((v) {
        orders!.add(new Orders.fromJson(v));
      });
    }
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['mob_num'] = this.mobNum;
    data['raname'] = this.raname;
    data['balance_amount'] = this.balanceAmount;
    data['message'] = this.message;
    if (this.orders != null) {
      data['orders'] = this.orders!.map((v) => v.toJson()).toList();
    }
    data['session_exists'] = this.sessionExists;
    return data;
  }
}

class Orders {
  String? orderid;
  String? orderNum;
  String? productImage;
  String? rentedDate;
  String? expiringInColor;
  String? expiringText;
  bool? hasPendingPayment;
  String? pendingPaymentText;
  List<String>? products;

  Orders(
      {this.orderid,
        this.orderNum,
        this.productImage,
        this.rentedDate,
        this.expiringInColor,
        this.expiringText,
        this.hasPendingPayment,
        this.pendingPaymentText,
        this.products});

  Orders.fromJson(Map<String, dynamic> json) {
    orderid = json['orderid'];
    orderNum = json['order_num'];
    productImage = json['productImage'];
    rentedDate = json['rentedDate'];
    expiringInColor = json['ExpiringInColor'];
    expiringText = json['expiringText'];
    hasPendingPayment = json['hasPendingPayment'];
    pendingPaymentText = json['pendingPaymentText'];
    products = json['products'].cast<String>();
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['orderid'] = this.orderid;
    data['order_num'] = this.orderNum;
    data['productImage'] = this.productImage;
    data['rentedDate'] = this.rentedDate;
    data['ExpiringInColor'] = this.expiringInColor;
    data['expiringText'] = this.expiringText;
    data['hasPendingPayment'] = this.hasPendingPayment;
    data['pendingPaymentText'] = this.pendingPaymentText;
    data['products'] = this.products;
    return data;
  }
}
