import 'package:flutter/material.dart';

class SectionHeading extends StatelessWidget {
  final String title;
  final TextStyle? textStyle;
  final EdgeInsetsGeometry padding;

  const SectionHeading({
    Key? key,
    required this.title,
    this.textStyle = const TextStyle(fontSize: 16, fontWeight: FontWeight.w500, fontFamily: "Poppins"),
    this.padding = const EdgeInsets.symmetric(horizontal: 12.0, vertical: 8.0),
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: padding,
      child: Text(
        title,
        style: textStyle ??
            Theme.of(context).textTheme.titleMedium?.copyWith(
              fontWeight: FontWeight.bold,
            ),
      ),
    );
  }
}
