import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';

import '../Utility/AppColors.dart';

class TransactionsScreen extends StatefulWidget {
  const TransactionsScreen({super.key});

  @override
  State<TransactionsScreen> createState() => _TransactionsScreenState();
}

class _TransactionsScreenState extends State<TransactionsScreen> {
  // Dummy data for transactions
  final List<Map<String, dynamic>> transactions = [
    {
      "type": "debit",
      "title": "Payment for June Rent",
      "date": "25 Dec 2025",
      "amount": "₹5,390.00",
      "ref": "₹1,12,300"
    },
    {
      "type": "debit",
      "title": "Payment for June Rent",
      "date": "25 Dec 2025",
      "amount": "₹2,512.00",
      "ref": "₹26,300"
    },
    {
      "type": "credit",
      "title": "Refund of Deposit Amount",
      "date": "25 Dec 2025",
      "amount": "₹19,790.00",
      "ref": "₹1,26,300"
    },
    {
      "type": "debit",
      "title": "Payment for June Rent",
      "date": "25 Dec 2025",
      "amount": "₹5,390.00",
      "ref": "₹1,12,300"
    },
    {
      "type": "debit",
      "title": "Payment for June Rent",
      "date": "25 Dec 2025",
      "amount": "₹2,512.00",
      "ref": "₹26,300"
    },
    {
      "type": "credit",
      "title": "Refund of Deposit Amount",
      "date": "25 Dec 2025",
      "amount": "₹19,790.00",
      "ref": "₹1,26,300"
    },
  ];

  @override
  Widget build(BuildContext context) {
    return SafeArea(
      top: false,
      child: Scaffold(
        backgroundColor: AppColors.backgroundRegular,
        appBar: AppBar(
          backgroundColor: Colors.white,
          elevation: 0,
          titleSpacing: 0,
          title: Row(
            children: [
              InkResponse(
                onTap: () => Navigator.pop(context),
                child: SvgPicture.asset(
                  "assets/svg/continue_left_ic.svg",
                  height: 25,
                  width: 25,
                ),
              ),
              const SizedBox(width: 12),
              const Text(
                "Transactions",
                style: TextStyle(
                  fontSize: 16,
                  fontFamily: "Poppins",
                  fontWeight: FontWeight.w500,
                  color: Colors.black,
                ),
              ),
            ],
          ),
        ),
        // Main content
        body: SingleChildScrollView(
          padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 16),
          child: Column(
            children: [
              SizedBox(height: 4,),
              // Balance Card
              Container(
                width: double.infinity,
                padding: const EdgeInsets.symmetric(vertical: 24, horizontal: 16),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(20),
                  gradient: const LinearGradient(
                    colors: [
                      Color(0xFFE9FFEF),
                      Color(0xFFD6FFDF),
                    ],
                    begin: Alignment.topLeft,
                    end: Alignment.bottomRight,
                  ),
                ),
                child: Column(
                  children: [
                    Text(
                      "₹12,596",
                      style: TextStyle(
                        fontFamily: "Poppins",
                        fontWeight: FontWeight.w500,
                        fontSize: 34,
                        color: AppColors.cardAmountText,
                      ),
                    ),
                    const SizedBox(height: 4),
                    Text(
                      "Balance Amount",
                      style: TextStyle(
                        fontFamily: "Poppins",
                        fontWeight: FontWeight.w400,
                        fontSize: 14,
                        color: AppColors.cardAmountText,
                      ),
                    ),
                    const SizedBox(height: 10),
                    Container(
                      height: 1,
                      color: const Color(0xFF777777).withOpacity(0.3),
                    ),
                    const SizedBox(height: 14),

                    // Credited / Debited info
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceEvenly,
                      children: [
                        _buildAmountSummary(
                          icon: "assets/svg/cross_down_arrow.svg",
                          color: Colors.white,
                          amount: "₹26,300",
                          label: "Credited Amount",
                        ),
                        _buildAmountSummary(
                          icon: "assets/svg/cross_up_arrow.svg",
                          color: Colors.white,
                          amount: "₹26,300",
                          label: "Debited Amount",
                        ),
                      ],
                    ),
                  ],
                ),
              ),

              const SizedBox(height: 16),

              // Transaction list
              Column(
                children: transactions.map((t) {
                  return _buildTransactionItem(
                    type: t["type"],
                    title: t["title"],
                    date: t["date"],
                    amount: t["amount"],
                    ref: t["ref"],
                  );
                }).toList(),
              ),
            ],
          ),
        ),
      ),
    );
  }

  Widget _buildAmountSummary({
    required String icon,
    required Color color,
    required String amount,
    required String label,
  }) {
    return Row(
      children: [
        // Icon and title row
        Container(
          width: 50,
          height: 50,
          decoration: BoxDecoration(
            color: color.withOpacity(0.9),
            borderRadius: BorderRadius.circular(30),
          ),
          child: Center( // Add this Center widget
            child: SvgPicture.asset(
              icon,
              height: 20,
              width: 20,
              // Remove fit: BoxFit.none
            ),
          ),
        ),
        const SizedBox(width: 8),
        Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Text(
              amount,
              style: TextStyle(
                fontFamily: "Poppins",
                fontWeight: FontWeight.w400,
                fontSize: 14,
                color: Colors.black,
              ),
            ),
            Text(
              label,
              style: TextStyle(
                fontFamily: "Poppins",
                fontWeight: FontWeight.w400,
                fontSize: 12,
                color: Colors.grey.shade600,
              ),
            ),
          ],
        ),
      ],
    );
  }

  Widget _buildTransactionItem({
    required String type,
    required String title,
    required String date,
    required String amount,
    required String ref,
  }) {
    final isCredit = type == "credit";
    return Container(
      margin: const EdgeInsets.only(bottom: 12),
      padding: const EdgeInsets.symmetric(vertical: 10, horizontal: 14),
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(14),
        // border: Border.all(color: Colors.grey.shade200, width: 1),
        // boxShadow: [
        //   BoxShadow(
        //     color: Colors.black.withOpacity(0.02),
        //     blurRadius: 5,
        //     offset: const Offset(0, 1),
        //   ),
        // ],
      ),
      child: Row(
        children: [
          // Icon and title row
          Container(
            width: 50,
            height: 50,
            decoration: BoxDecoration(
              color: isCredit ? Colors.green.withOpacity(0.09) : Colors.red.withOpacity(0.09),
              borderRadius: BorderRadius.circular(30),
            ),
            child: Center( // Add this Center widget
              child: SvgPicture.asset(
                isCredit ? "assets/svg/cross_down_arrow.svg" : "assets/svg/cross_up_arrow.svg",
                height: 20,
                width: 20,
                // Remove fit: BoxFit.none
              ),
            ),
          ),

          // Container(
          //   padding: const EdgeInsets.all(8),
          //   decoration: BoxDecoration(
          //     color: isCredit
          //         ? const Color(0xFFE8F9EE)
          //         : const Color(0xFFFFEBEB),
          //     shape: BoxShape.circle,
          //   ),
          //   child: Icon(
          //     isCredit ? Icons.arrow_downward_rounded : Icons.arrow_upward_rounded,
          //     color: isCredit ? Colors.green : Colors.red,
          //     size: 20,
          //   ),
          // ),
          const SizedBox(width: 12),
          Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Text(
                  title,
                  overflow: TextOverflow.ellipsis,
                  style: const TextStyle(
                    fontFamily: "Poppins",
                    fontWeight: FontWeight.w400,
                    fontSize: 14,
                    color: Colors.black,
                  ),
                ),
                const SizedBox(height: 4),
                Text(
                  date,
                  style: TextStyle(
                    fontFamily: "Poppins",
                    fontWeight: FontWeight.w400,
                    fontSize: 12,
                    color: Colors.grey.shade600,
                  ),
                ),
              ],
            ),
          ),
          const SizedBox(width: 12),
          Column(
            crossAxisAlignment: CrossAxisAlignment.end,
            children: [
              Text(
                amount,
                style: TextStyle(
                  fontFamily: "Poppins",
                  fontWeight: FontWeight.w400,
                  fontSize: 14,
                  color: Colors.black,
                ),
              ),
              const SizedBox(height: 4),
              Row(
                children: [
                  Text(
                    ref,
                    style: TextStyle(
                      fontFamily: "Poppins",
                      fontWeight: FontWeight.w400,
                      fontSize: 12,
                      color: Colors.grey.shade600,
                    ),
                  ),
                  const SizedBox(width: 4),//
                  SvgPicture.asset(
                    "assets/svg/rupee_coin_ic.svg",
                    height: 14,
                    width: 14,
                    // Remove fit: BoxFit.none
                  ),
                ],
              ),
            ],
          ),
        ],
      ),
    );
  }
}
