import 'dart:convert';

import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:gen_rentals/Screens/BillDetailListScreen.dart';
import 'package:gen_rentals/Utility/Reusablewidgets.dart';

import '../Utility/AppColors.dart';

class ProductsDetailScreen extends StatelessWidget {
  const ProductsDetailScreen({super.key});

  @override
  Widget build(BuildContext context) {
    double screenWidth = MediaQuery.of(context).size.width;
    double screenHeight = MediaQuery.of(context).size.height;
    double bottomPadding = MediaQuery.of(context).padding.bottom;

    return SafeArea(
      top: false,
      child: Scaffold(
        body: Container(
          color: const Color(0xFFF3F3F3),
          height: screenHeight,
          child: SingleChildScrollView(
            child: Column(
              children: [
                // Top background image section
                Stack(
                  children: [
                    // Background image
                    Container(
                      width: double.infinity,
                      decoration: BoxDecoration(
                        gradient: const LinearGradient(
                          begin: Alignment.topCenter,
                          end: Alignment.bottomCenter,
                          colors: [
                            Colors.white54,
                            Color(0xFFF3F3F3),
                          ],
                        ),
                      ),
                      child: Image.asset(
                        'assets/images/sky_blue_bg.jpg',
                        width: double.infinity,
                        height: 400,
                        fit: BoxFit.cover,
                      ),
                    ),

                    // Content overlay
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        // Header with profile
                        Container(
                          width: double.infinity,
                          height: 450,
                          decoration: const BoxDecoration(
                            gradient: LinearGradient(
                              begin: Alignment.topCenter,
                              end: Alignment.bottomCenter,
                              colors: [
                                Color(0x22FFFFFF),
                                Color(0x33FFFFFF),
                                Color(0x88FFFFFF),
                                Color(0xFFF3F3F3),
                                Color(0xFFF3F3F3),
                              ],
                            ),
                          ),
                          child: Column(
                            children: [
                              const SizedBox(height: 50),
                              // Instead of SizedBox(width: 280) - consider using Spacer()
                              Row(
                                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                children: [
                                  SvgPicture.asset(
                                    "assets/svg/continue_left_ic.svg",
                                    height: 50,
                                    width: 50,
                                  ),
                                  // Removed SizedBox(width: 280)
                                  Container(
                                    width: 50,
                                    height: 50,
                                    decoration: BoxDecoration(
                                      color: Colors.white.withOpacity(0.19),
                                      shape: BoxShape.circle,
                                      border: Border.all(
                                        color: Colors.white.withOpacity(0.5),
                                        width: 2,
                                      ),
                                    ),
                                    child: const Icon(
                                      Icons.person,
                                      color: Colors.white,
                                      size: 30,
                                    ),
                                  ),
                                ],
                              ),
                              Column(
                                crossAxisAlignment: CrossAxisAlignment.center,
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Image.asset(
                                    'assets/images/gen2_img.png',
                                    height: 250,
                                    width: 250,
                                  ),
                                  const Text(
                                    "Genesis 85kVA",
                                    style: TextStyle(
                                      fontFamily: "Poppins",
                                      color: Colors.black,
                                      fontSize: 30,
                                      fontWeight: FontWeight.w500,
                                    ),
                                  ),

                                  Container(
                                    padding: const EdgeInsets.symmetric(horizontal: 10, vertical: 6),
                                    decoration: BoxDecoration(
                                      borderRadius: BorderRadius.circular(8),
                                      gradient: const LinearGradient(
                                        begin: Alignment.topLeft,
                                        end: Alignment.bottomRight,
                                        colors: [
                                          Color(0xFFE9FFDD),
                                          Color(0xFFB5FFD1),
                                        ],
                                      ),
                                    ),
                                    child: Text(
                                      "2 months left",
                                      style: const TextStyle(
                                        color: Colors.black87,
                                        fontSize: 12,
                                        fontStyle: FontStyle.normal,
                                        fontWeight: FontWeight.w400,
                                      ),
                                    ),
                                  ),

                                  SizedBox(height: 4,),
                                  const Text(
                                    "Rented on 7th July, 2025",
                                    style: TextStyle(
                                      fontFamily: "Poppins",
                                      color: Colors.grey,
                                      fontSize: 16,
                                      fontWeight: FontWeight.w400,
                                    ),
                                  ),
                                ],
                              ),
                            ],
                          ),
                        ),

                        const SizedBox(height: 10),

                        // Main content section
                        Container(
                          padding: const EdgeInsets.symmetric(horizontal: 20),
                          child: Column(
                            children: [
                              // Balance Amount Card
                              Container(
                                width: double.infinity,
                                padding: const EdgeInsets.all(20),
                                decoration: BoxDecoration(
                                  color: Colors.white,
                                  borderRadius: BorderRadius.circular(16),
                                ),
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    InkResponse(
                                      onTap: () {
                                        Navigator.push(
                                          context,
                                          MaterialPageRoute(builder: (context) => BillDetailListScreen()),
                                        );
                                      },
                                      child: Row(
                                        children: [
                                          const Text(
                                            "Balance Amount",
                                            style: TextStyle(
                                              fontFamily: "Poppins",
                                              color: AppColors.warningText,
                                              fontSize: 14,
                                              fontWeight: FontWeight.w400,
                                            ),
                                          ),
                                          const SizedBox(width: 4),
                                          SvgPicture.asset(
                                            "assets/svg/continue_ic.svg",
                                            color: AppColors.warningText,
                                            height: 18,
                                            width: 18,
                                          ),
                                        ],
                                      ),
                                    ),
                                    const SizedBox(height: 8),
                                    Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [
                                        const Text(
                                          "₹24,800",
                                          style: TextStyle(
                                            fontFamily: "Poppins",
                                            color: AppColors.cardAmountText,
                                            fontSize: 32,
                                            fontWeight: FontWeight.w500,
                                          ),
                                        ),
                                        InkResponse(
                                          onTap:  () => showPaymentBottomSheet(context),
                                          child: Text(
                                            "Pay Now",
                                            style: TextStyle(
                                              fontFamily: "Poppins",
                                              color: AppColors.amountText,
                                              fontSize: 14,
                                              fontWeight: FontWeight.w500,
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                    const SizedBox(height: 2),
                                    Text(
                                      "Last Paid on 12th Sep, 2025",
                                      style: TextStyle(
                                        fontFamily: "Poppins",
                                        color: AppColors.subtitleText,
                                        fontSize: 12,
                                        fontWeight: FontWeight.w400,
                                        // fontStyle: FontStyle.italic,
                                      ),
                                    ),

                                    SvgPicture.asset(
                                      "assets/svg/line_ic.svg",
                                      color: AppColors.subtitleText,
                                      height: 18,
                                      width: 18,
                                    ),
                                    // After spacer
                                    Row(
                                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                                      children: [

                                        Column(
                                          crossAxisAlignment: CrossAxisAlignment.start,
                                          children: [
                                            Text(
                                              "Plan",
                                              style: TextStyle(
                                                fontFamily: "Poppins",
                                                color: AppColors.subtitleText,
                                                fontWeight: FontWeight.w400,
                                                fontStyle: FontStyle.normal,
                                                fontSize: 12,
                                              ),
                                            ),
                                            Text(
                                              "₹3600",
                                              style: const TextStyle(
                                                fontFamily: "Poppins",
                                                color: Color(0xFF008CDE),
                                                fontSize: 18,
                                                fontStyle: FontStyle.normal,
                                                fontWeight: FontWeight.w500,
                                              ),
                                            ),
                                          ],
                                        ),

                                        Column(
                                          crossAxisAlignment: CrossAxisAlignment.start,
                                          children: [
                                            Text(
                                              "Deposit",
                                              style: TextStyle(
                                                fontFamily: "Poppins",
                                                color: AppColors.subtitleText,
                                                fontWeight: FontWeight.w400,
                                                fontStyle: FontStyle.normal,
                                                fontSize: 12,
                                              ),
                                            ),
                                            Text(
                                              "₹5483",
                                              style: const TextStyle(
                                                fontFamily: "Poppins",
                                                color: AppColors.cardAmountText,
                                                fontSize: 18,
                                                fontStyle: FontStyle.normal,
                                                fontWeight: FontWeight.w500,
                                              ),
                                            ),
                                          ],
                                        ),

                                        Column(
                                          crossAxisAlignment: CrossAxisAlignment.start,
                                          children: [
                                            Text(
                                              "Tenure",
                                              style: TextStyle(
                                                fontFamily: "Poppins",
                                                color: AppColors.subtitleText,
                                                fontWeight: FontWeight.w400,
                                                fontStyle: FontStyle.normal,
                                                fontSize: 12,
                                              ),
                                            ),
                                            Text(
                                              "6 Months",
                                              style: const TextStyle(
                                                fontFamily: "Poppins",
                                                color: AppColors.cardAmountText,
                                                fontSize: 18,
                                                fontStyle: FontStyle.normal,
                                                fontWeight: FontWeight.w500,
                                              ),
                                            ),
                                          ],
                                        )
                                      ],
                                    )
                                  ],
                                ),
                              ),

                              const SizedBox(height: 18),

                              Container(
                                width: double.infinity,
                                color: Colors.transparent,
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    const SizedBox(height: 2),
                                    SectionHeading(title: "Generator Overview", padding: EdgeInsets.symmetric(vertical: 4),),
                                    Text(
                                      "A diesel generator converts fuel into electricity using an engine to drive an alternator. They provide backup power for homes and businesses and serve as primary sources in remote areas.",
                                      style: TextStyle(
                                        fontFamily: "Poppins",
                                        color: AppColors.subtitleText,
                                        fontWeight: FontWeight.w400,
                                        fontStyle: FontStyle.normal,
                                        fontSize: 12,
                                      ),
                                    ),

                                  ],
                                )
                              ),
                              const SizedBox(height: 20),

                              // Feature cards grid
                              Container(
                                width: double.infinity,
                                color: Colors.transparent,
                                child: Column(
                                  children: [
                                    // First row of feature cards
                                    Row(
                                      children: [
                                        // Any Requirements Card
                                        Expanded(
                                          child: _buildFeatureCard(
                                            title: "85 kVA",
                                            description: "PRIME POWER",
                                            icon: "assets/svg/power_ic.svg",
                                            color: Colors.orange,
                                          ),
                                        ),
                                        const SizedBox(width: 16),
                                        // Subscribed Products Card
                                        Expanded(
                                          child: _buildFeatureCard(
                                            title: "1500 RPM",
                                            description: "ENGINE SPEED",
                                            icon: "assets/svg/rpm_ic.svg",
                                            color: Colors.blue,
                                          ),
                                        ),
                                      ],
                                    ),

                                    const SizedBox(height: 16),

                                    // Second row of feature cards
                                    Row(
                                      children: [
                                        // Have Complaints Card
                                        Expanded(
                                          child: _buildFeatureCard(
                                            title: "75 dB",
                                            description: "LOW NOISE LEVEL",
                                            icon: "assets/svg/noise_ic.svg",
                                            color: Colors.green,
                                          ),
                                        ),
                                        const SizedBox(width: 16),
                                        // Know Your Payments Card
                                        Expanded(
                                          child: _buildFeatureCard(
                                            title: "24 Hr",
                                            description: "LONGER RUNTIME",
                                            icon: "assets/svg/clock_ic.svg",
                                            color: Colors.purple,
                                          ),
                                        ),
                                      ],
                                    ),

                                    const SizedBox(height: 20),
                                  ],
                                ),
                              ),
                            ],
                          ),
                        ),
                      ],
                    ),
                  ],
                ),
              ],
            ),
          ),
        ),
      ),
    );
  }


  Widget _buildFeatureCard({
    required String title,
    required String description,
    required String icon,
    required Color color,
  }) {
    return Container(
      padding: const EdgeInsets.symmetric(horizontal: 12, vertical: 10),
      decoration: BoxDecoration(
        color: Colors.grey.shade50,
        borderRadius: BorderRadius.circular(12),
        border: Border.all(
          color: Colors.grey.shade200,
          width: 1,
        ),
        // boxShadow: [
        //   BoxShadow(
        //     color: Colors.black.withOpacity(0.05),
        //     blurRadius: 8,
        //     offset: const Offset(0, 2),
        //   ),
        // ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          // Icon and title row
          Container(
            width: 45,
            height: 45,
            decoration: BoxDecoration(
              color: color.withOpacity(0.1),
              borderRadius: BorderRadius.circular(12),
            ),
            child: Center( // Add this Center widget
              child: SvgPicture.asset(
                icon,
                height: 25,
                width: 25,
                // Remove fit: BoxFit.none
              ),
            ),
          ),
          const SizedBox(height: 4),
          Text(
            title,
            style: TextStyle(
              color: AppColors.nearDarkText,
              fontSize: 14,
              fontWeight: FontWeight.w600,
            ),
          ),
          const SizedBox(height: 4),
          // Description
          Text(
            description,
            style: TextStyle(
              color: AppColors.subtitleText,
              fontFamily: "Poppins",
              fontWeight: FontWeight.w400,
              fontSize: 12,
            ),
          ),
        ],
      ),
    );
  }
  void showPaymentBottomSheet(BuildContext context) {
    showModalBottomSheet(
      context: context,
      isScrollControlled: true,
      backgroundColor: Colors.transparent,
      builder: (BuildContext context) {
        return SafeArea(
          bottom: true,
          child: Container(
            decoration: const BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.only(
                topLeft: Radius.circular(24),
                topRight: Radius.circular(24),
              ),
            ),
            child: Padding(
              padding: const EdgeInsets.symmetric(horizontal: 16, vertical: 14),
              child: Column(
                mainAxisSize: MainAxisSize.min,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  // Header - Drag handle
                  Center(
                    child: Container(
                      width: 40,
                      height: 4,
                      decoration: BoxDecoration(
                        color: Colors.grey.shade300,
                        borderRadius: BorderRadius.circular(2),
                      ),
                    ),
                  ),
                  const SizedBox(height: 20),

                  // Pay Amount Section
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    children: [
                      const Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          Text(
                            "Pay",
                            style: TextStyle(
                              fontSize: 16,
                              fontWeight: FontWeight.w400,
                              color: Color(0xFF777777),
                            ),
                          ),
                          SizedBox(height: 4),
                          Text(
                            "₹4218",
                            style: TextStyle(
                              fontSize: 24,
                              fontWeight: FontWeight.w600,
                              color: Colors.black,
                            ),
                          ),
                        ],
                      ),

                      // Rent Amount Section
                      Column(
                        crossAxisAlignment: CrossAxisAlignment.end,
                        children: [
                          const Text(
                            "Rent Amount",
                            style: TextStyle(
                              fontSize: 14,
                              fontWeight: FontWeight.w400,
                              color: Color(0xFF777777),
                            ),
                          ),
                          const SizedBox(height: 4),
                          GestureDetector(
                            onTap: () {
                              // Handle view bill details
                            },
                            child: Text(
                              "View Bill Details",
                              style: TextStyle(
                                fontSize: 14,
                                fontWeight: FontWeight.w500,
                                color: Color(0xFF008CDE),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ],
                  ),

                  const SizedBox(height: 10),
                  const Divider(height: 1, color: Color(0xFFEEEEEE)),
                  const SizedBox(height: 18),

                  // Continue Payment Button
                  SizedBox(
                    width: double.infinity,
                    child: ElevatedButton(
                      onPressed: () {
                        // Handle continue payment
                      },
                      style: ElevatedButton.styleFrom(
                        backgroundColor: const Color(0xFF008CDE),
                        foregroundColor: Colors.white,
                        disabledBackgroundColor: const Color(0xFF266E99),
                        shape: RoundedRectangleBorder(
                          borderRadius: BorderRadius.circular(30),
                        ),
                        padding: const EdgeInsets.symmetric(vertical: 16),
                      ),
                      child: Padding(
                        padding: const EdgeInsets.symmetric(horizontal: 22),
                        child: Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            const Text(
                              "Continue Payment",
                              style: TextStyle(
                                color: Color(0xFFFFFFFF),
                                fontSize: 16,
                              ),
                            ),
                            SvgPicture.asset(
                              "assets/svg/continue_ic.svg",
                              color: Color(0xFFFFFFFF),
                              height: 25,
                              width: 25,
                            ),
                          ],
                        ),
                      ),
                    ),
                  ),

                ],
              ),
            ),
          ),
        );
      },
    );
  }

}