class TicketListResponse {
  List<Ticket>? ticket;
  int? error;
  String? message;

  TicketListResponse({this.ticket, this.error, this.message});

  TicketListResponse.fromJson(Map<String, dynamic> json) {
    if (json['ticket'] != null) {
      ticket = <Ticket>[];
      json['ticket'].forEach((v) {
        ticket!.add(new Ticket.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.ticket != null) {
      data['ticket'] = this.ticket!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    return data;
  }
}

class Ticket {
  String? tid;
  String? datetime;
  String? status;
  String? subject;

  Ticket({this.tid, this.datetime, this.status, this.subject});

  Ticket.fromJson(Map<String, dynamic> json) {
    tid = json['tid'];
    datetime = json['datetime'];
    status = json['status'];
    subject = json['subject'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['tid'] = this.tid;
    data['datetime'] = this.datetime;
    data['status'] = this.status;
    data['subject'] = this.subject;
    return data;
  }
}
