class DashboardResponse {
  int? error;
  String? message;
  int? exist;
  String? city;
  String? raname;
  String? mob;
  String? mail;
  String? address;
  String? state;
  String? accId;
  int? otp;
  List<Products>? products;

  DashboardResponse(
      {this.error,
        this.message,
        this.exist,
        this.city,
        this.raname,
        this.mob,
        this.mail,
        this.address,
        this.state,
        this.accId,
        this.otp,
        this.products});

  DashboardResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    message = json['message'];
    exist = json['exist'];
    city = json['city'];
    raname = json['raname'];
    mob = json['mob'];
    mail = json['mail'];
    address = json['address'];
    state = json['state'];
    accId = json['acc_id'];
    otp = json['otp'];
    if (json['products'] != null) {
      products = <Products>[];
      json['products'].forEach((v) {
        products!.add(new Products.fromJson(v));
      });
    }
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['error'] = this.error;
    data['message'] = this.message;
    data['exist'] = this.exist;
    data['city'] = this.city;
    data['raname'] = this.raname;
    data['mob'] = this.mob;
    data['mail'] = this.mail;
    data['address'] = this.address;
    data['state'] = this.state;
    data['acc_id'] = this.accId;
    data['otp'] = this.otp;
    if (this.products != null) {
      data['products'] = this.products!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class Products {
  String? orderid;
  String? productName;
  String? productImage;
  String? plan;
  String? rentedDate;
  String? expiringInColor;
  String? expiringText;
  String? address;
  bool? hasPendingPayment;
  String? pendingPaymentText;

  Products(
      {this.orderid,
        this.productName,
        this.productImage,
        this.plan,
        this.rentedDate,
        this.expiringInColor,
        this.expiringText,
        this.address,
        this.hasPendingPayment,
        this.pendingPaymentText});

  Products.fromJson(Map<String, dynamic> json) {
    orderid = json['orderid'];
    productName = json['productName'];
    productImage = json['productImage'];
    plan = json['plan'];
    rentedDate = json['rentedDate'];
    expiringInColor = json['ExpiringInColor'];
    expiringText = json['expiringText'];
    address = json['address'];
    hasPendingPayment = json['hasPendingPayment'];
    pendingPaymentText = json['pendingPaymentText'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['orderid'] = this.orderid;
    data['productName'] = this.productName;
    data['productImage'] = this.productImage;
    data['plan'] = this.plan;
    data['rentedDate'] = this.rentedDate;
    data['ExpiringInColor'] = this.expiringInColor;
    data['expiringText'] = this.expiringText;
    data['address'] = this.address;
    data['hasPendingPayment'] = this.hasPendingPayment;
    data['pendingPaymentText'] = this.pendingPaymentText;
    return data;
  }
}
