import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import '../../Models/hrmModels/rewardListResponse.dart';
import '../../services/api_calling.dart';
import '../HomeScreenNotifier.dart';

class RewardListProvider extends ChangeNotifier {
  rewardListResponse? _response;
  bool _isLoading = false;
  String? _errorMessage;

  /// Getters
  rewardListResponse? get response => _response;
  bool get isLoading => _isLoading;
  String? get errorMessage => _errorMessage;

  /// Fetch Reward List
  Future<void> fetchRewardList(BuildContext context) async {
    _isLoading = true;
    _errorMessage = null;
    _response = null;
    notifyListeners();

    try {
      final provider = Provider.of<HomescreenNotifier>(context, listen: false);
      final result = await ApiCalling.rewardListAPI(
        provider.empId,
        provider.session,
      );

      if (result != null) {
        _response = result;
      } else {
        _errorMessage = "No reward data found!";
      }
    } catch (e) {
      _errorMessage = "Something went wrong: $e";
    }

    _isLoading = false;
    notifyListeners();
  }
}
