import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import '../../Models/hrmModels/casualLeaveHistoryResponse.dart';
import '../../services/api_calling.dart';
import '../HomeScreenNotifier.dart';

class CasualLeaveHistoryProvider extends ChangeNotifier {
  /// --- Variables ---
  List<CasualLeaveHistory> casualLeaveHistoryList = [];
  bool isLoading = false;
  String? errorMessage;

  /// --- Fetch Casual Leave History ---
  Future<void> fetchCasualLeaveHistory(BuildContext context) async {
    isLoading = true;
    errorMessage = null;
    notifyListeners();

    try {
      final homeProvider = Provider.of<HomescreenNotifier>(context, listen: false);

      final response = await ApiCalling.casualLeaveHistoryAPI(
        homeProvider.session,
        homeProvider.empId,
      );

      if (response != null) {
        if (response.error != null && response.error != "0") {
          errorMessage = response.message ?? "Something went wrong";
          casualLeaveHistoryList = [];
        } else {
          casualLeaveHistoryList = response.casualLeaveHistory ?? [];
        }
      } else {
        errorMessage = "No response from server";
      }
    } catch (e) {
      errorMessage = "Failed to load leave history: $e";
    } finally {
      isLoading = false;
      notifyListeners();
    }
  }

  /// --- Clear data (optional) ---
  void clearHistory() {
    casualLeaveHistoryList.clear();
    errorMessage = null;
    notifyListeners();
  }
}
