import 'package:flutter/cupertino.dart';
import 'package:generp/Notifiers/HomeScreenNotifier.dart';
import 'package:generp/services/api_calling.dart';
import 'package:provider/provider.dart';

import '../Models/FollowUpResponse.dart';
import '../Models/ViewVisitDetailsResponseNew.dart';
import '../Utils/commonServices.dart';

class Visitdetailsprovider extends ChangeNotifier {
  bool _showMoreDetails = false;

  CustomerDetails _customerDetails = CustomerDetails();
  GeneratorDetails _generatorDetails = GeneratorDetails();
  ComplaintDetailsNew _complaintDetailsNew = ComplaintDetailsNew();
  List<Followuplist> _followupList = [];
  bool _isLoading = false;

  CustomerDetails get customerDetails => _customerDetails;
  GeneratorDetails get generatorDetails => _generatorDetails;
  ComplaintDetailsNew get complaintDetailsNew => _complaintDetailsNew;
  List<Followuplist> get followUpList => _followupList;
  bool get isLoading => _isLoading;
  bool get showMoreDetails => _showMoreDetails;

  set showMoreDetails(bool value) {
    _showMoreDetails = value;
    notifyListeners();
  }

  Future<void> LoadVisitDetailsAPI(BuildContext context, ComplaintID) async {
    try {
      var HomeProvider = Provider.of<HomescreenNotifier>(
        context,
        listen: false,
      );
      final data = await ApiCalling.loadVisitDetailsAPI(
        HomeProvider.empId,
        HomeProvider.session,
        ComplaintID,
      );

      if (data != null) {
        if (data.error == 0) {
          // complaintdetails = data.complaintDetails!;
          _customerDetails = data.customerDetails!;
          _generatorDetails = data.generatorDetails!;
          _complaintDetailsNew = data.complaintDetailsNew!;
          _isLoading = false;
          notifyListeners();
        } else {
          toast(context, "Something Went Wrong, Please try again!");
          print("error");
        }
      } else {
        toast(context, "No response From the server, Please try Again!");
        print("error2");
      }
    } on Error catch (e) {
      print(e.toString());
    }
  }

  Future<void> LoadFollowupListAPI(BuildContext context, ComplaintID) async {
    try {
      var HomeProvider = Provider.of<HomescreenNotifier>(
        context,
        listen: false,
      );
      final data = await ApiCalling.loadFollowupListAPI(
        HomeProvider.empId,
        HomeProvider.session,
        ComplaintID,
      );

      if (data != null) {
        if (data.error == 0) {
          // complaintdetails = data.complaintDetails!;
          _followupList = data.list ?? [];
          _isLoading = false;
          notifyListeners();
        } else {
          toast(context, "Something Went Wrong, Please try again!");
          print("error");
        }
      } else {
        toast(context, "No response From the server, Please try Again!");
        print("error2");
      }
    } on Error catch (e) {
      print(e.toString());
    }
  }
}
