import 'package:flutter/material.dart';
import 'package:generp/Notifiers/HomeScreenNotifier.dart';
import 'package:generp/Utils/SharedpreferencesService.dart';
import 'package:generp/screens/LoginScreen.dart';
import 'package:generp/services/api_calling.dart';
import 'package:provider/provider.dart';

class Serviceengineerdashboardprovider extends ChangeNotifier {
  int _avgRating = 0;
  int _pendingComplaints = 0;
  int _todayVisits = 0;
  int _thisMonthsVisits = 0;
  String _paymentCollectionWalletBalanceAmount = "";
  String _monthlyPaymentCollectionAmount = "";
  bool _isLoading = false;

  int get avgRating => _avgRating;
  int get pendingComplaints => _pendingComplaints;
  int get todayVisits => _todayVisits;
  int get thisMonthsVisits => _thisMonthsVisits;
  String get paymentCollectionWalletBalanceAmount =>
      _paymentCollectionWalletBalanceAmount;
  String get monthlyPaymentCollectionAmount => _monthlyPaymentCollectionAmount;
  bool get isLoading => _isLoading;

  Future<void> LoadTechnicianDashboard(BuildContext context) async {
    var HomeProvider = Provider.of<HomescreenNotifier>(context, listen: false);
    try {
      final data = await ApiCalling.loadTechnicianDashboardApi(
        HomeProvider.empId,
        HomeProvider.session,
      );

      if (data != null) {
        if (data.sessionExists == 1) {
          if (data.error == 0) {
            _avgRating = data.avgRating!;
            _pendingComplaints = data.pendingComplaints!;
            _todayVisits = data.todayVisits!;
            _thisMonthsVisits = data.thisMonthsVisits!;
            _paymentCollectionWalletBalanceAmount =
                data.paymentCollectionWalletBalanceAmount!;
            _monthlyPaymentCollectionAmount =
                data.monthlyPaymentCollectionAmount!;
            _isLoading = false;
            notifyListeners();
          } else {}
        } else if (data.sessionExists == 0) {
          SharedpreferencesService().clearPreferences();
          Navigator.push(
            context,
            MaterialPageRoute(builder: (context) => LoginScreen()),
          );
        }
      } else {
        print("Something went wrong, Please try again.");
      }
    } on Exception catch (e) {
      print("$e");
    }
  }
}
