class TPCListResponse {
  List<TpcAgentList>? tpcAgentList;
  String? error;
  String? message;

  TPCListResponse({this.tpcAgentList, this.error, this.message});

  TPCListResponse.fromJson(Map<String, dynamic> json) {
    if (json['tpc_agent_list'] != null) {
      tpcAgentList = <TpcAgentList>[];
      json['tpc_agent_list'].forEach((v) {
        tpcAgentList!.add(TpcAgentList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (tpcAgentList != null) {
      data['tpc_agent_list'] = tpcAgentList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class TpcAgentList {
  String? id;
  String? name;
  String? mobileNumber;
  String? idProofDirFilePath;
  String? idProofViewFileName;
  String? bankName;
  String? bankBeneficiaryName;
  String? bankAccountNo;
  String? bankIfscCode;
  String? note;
  String? enteredEmpId;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? tpcAgentId;
  String? enteredEmpName;
  String? issuedAmount;

  TpcAgentList({
    this.id,
    this.name,
    this.mobileNumber,
    this.idProofDirFilePath,
    this.idProofViewFileName,
    this.bankName,
    this.bankBeneficiaryName,
    this.bankAccountNo,
    this.bankIfscCode,
    this.note,
    this.enteredEmpId,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.tpcAgentId,
    this.enteredEmpName,
    this.issuedAmount,
  });

  TpcAgentList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    name = json['name'];
    mobileNumber = json['mobile_number'];
    idProofDirFilePath = json['id_proof_dir_file_path'];
    idProofViewFileName = json['id_proof_view_file_name'];
    bankName = json['bank_name'];
    bankBeneficiaryName = json['bank_beneficiary_name'];
    bankAccountNo = json['bank_account_no'];
    bankIfscCode = json['bank_ifsc_code'];
    note = json['note'];
    enteredEmpId = json['entered_emp_id'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    tpcAgentId = json['tpc_agent_id'];
    enteredEmpName = json['entered_emp_name'];
    issuedAmount = json['issued_amount'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['name'] = name;
    data['mobile_number'] = mobileNumber;
    data['id_proof_dir_file_path'] = idProofDirFilePath;
    data['id_proof_view_file_name'] = idProofViewFileName;
    data['bank_name'] = bankName;
    data['bank_beneficiary_name'] = bankBeneficiaryName;
    data['bank_account_no'] = bankAccountNo;
    data['bank_ifsc_code'] = bankIfscCode;
    data['note'] = note;
    data['entered_emp_id'] = enteredEmpId;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['tpc_agent_id'] = tpcAgentId;
    data['entered_emp_name'] = enteredEmpName;
    data['issued_amount'] = issuedAmount;
    return data;
  }
}
