class EditPaymentDetailsAdjustedOrdersViewResponse {
  List<EditPaidList>? paidList;
  List<EditOrderList>? editOrderList;
  String? error;
  String? message;

  EditPaymentDetailsAdjustedOrdersViewResponse({
    this.paidList,
    this.editOrderList,
    this.error,
    this.message,
  });

  EditPaymentDetailsAdjustedOrdersViewResponse.fromJson(
    Map<String, dynamic> json,
  ) {
    if (json['paid_list'] != null) {
      paidList = <EditPaidList>[];
      json['paid_list'].forEach((v) {
        paidList!.add(EditPaidList.fromJson(v));
      });
    }
    if (json['order_list'] != null) {
      editOrderList = <EditOrderList>[];
      json['order_list'].forEach((v) {
        editOrderList!.add(EditOrderList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (paidList != null) {
      data['paid_list'] = paidList!.map((v) => v.toJson()).toList();
    }
    if (editOrderList != null) {
      data['order_list'] = editOrderList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class EditPaidList {
  String? accId;
  String? orderId;
  String? orderPaymentId;
  String? orderNumber;
  String? orderAmount;
  String? paidAmount;
  String? balanceAmount;
  String? adjustedAmount;

  EditPaidList({
    this.accId,
    this.orderId,
    this.orderPaymentId,
    this.orderNumber,
    this.orderAmount,
    this.paidAmount,
    this.balanceAmount,
    this.adjustedAmount,
  });

  EditPaidList.fromJson(Map<String, dynamic> json) {
    accId = json['acc_id'];
    orderId = json['order_id'];
    orderPaymentId = json['order_payment_id'];
    orderNumber = json['order_number'];
    orderAmount = json['order_amount'];
    paidAmount = json['paid_amount'];
    balanceAmount = json['balance_amount'];
    adjustedAmount = json['adjusted_amount'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['acc_id'] = accId;
    data['order_id'] = orderId;
    data['order_payment_id'] = orderPaymentId;
    data['order_number'] = orderNumber;
    data['order_amount'] = orderAmount;
    data['paid_amount'] = paidAmount;
    data['balance_amount'] = balanceAmount;
    data['adjusted_amount'] = adjustedAmount;
    return data;
  }
}

class EditOrderList {
  String? orderId;
  String? orderNumber;
  String? totalAmount;
  String? balanceAmount;
  String? createdDatetime;

  EditOrderList({
    this.orderId,
    this.orderNumber,
    this.totalAmount,
    this.balanceAmount,
    this.createdDatetime,
  });

  EditOrderList.fromJson(Map<String, dynamic> json) {
    orderId = json['order_id'];
    orderNumber = json['order_number'];
    totalAmount = json['total_amount'];
    balanceAmount = json['balance_amount'];
    createdDatetime = json['created_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['order_id'] = orderId;
    data['order_number'] = orderNumber;
    data['total_amount'] = totalAmount;
    data['balance_amount'] = balanceAmount;
    data['created_datetime'] = createdDatetime;
    return data;
  }
}
