class leaveApplicationDetailsResponse {
  RequestDetails? requestDetails;
  String? error;
  String? message;
  int? sessionExists;

  leaveApplicationDetailsResponse({
    this.requestDetails,
    this.error,
    this.message,
    this.sessionExists,
  });

  leaveApplicationDetailsResponse.fromJson(Map<String, dynamic> json) {
    requestDetails =
        json['request_details'] != null
            ? RequestDetails.fromJson(json['request_details'])
            : null;
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (requestDetails != null) {
      data['request_details'] = requestDetails!.toJson();
    }
    data['error'] = error;
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class RequestDetails {
  String? id;
  String? appliedDate;
  String? fromDate;
  String? toDate;
  String? fromTime;
  String? toTime;
  String? reason;
  String? leaveType;
  String? status;
  String? requestedTo;
  String? approvedBy;
  String? approvedDate;
  String? approvalRemarks;

  RequestDetails({
    this.id,
    this.appliedDate,
    this.fromDate,
    this.toDate,
    this.fromTime,
    this.toTime,
    this.reason,
    this.leaveType,
    this.status,
    this.requestedTo,
    this.approvedBy,
    this.approvedDate,
    this.approvalRemarks,
  });

  RequestDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    appliedDate = json['applied_date'];
    fromDate = json['from_date'];
    toDate = json['to_date'];
    fromTime = json['from_time'];
    toTime = json['to_time'];
    reason = json['reason'];
    leaveType = json['leave_type'];
    status = json['status'];
    requestedTo = json['requested_to'];
    approvedBy = json['approved_by'];
    approvedDate = json['approved_date'];
    approvalRemarks = json['approval_remarks'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['applied_date'] = appliedDate;
    data['from_date'] = fromDate;
    data['to_date'] = toDate;
    data['from_time'] = fromTime;
    data['to_time'] = toTime;
    data['reason'] = reason;
    data['leave_type'] = leaveType;
    data['status'] = status;
    data['requested_to'] = requestedTo;
    data['approved_by'] = approvedBy;
    data['approved_date'] = approvedDate;
    data['approval_remarks'] = approvalRemarks;
    return data;
  }
}
