import 'dart:convert';
import 'dart:io';
import 'package:flutter/cupertino.dart';
import 'package:generp/Models/MissedCheckoutStripResponse.dart';
import 'package:generp/Models/ViewVisitDetailsResponseNew.dart';
import 'package:generp/Models/commonModels/DistrictsResponse.dart';
import 'package:generp/Models/commonModels/SubLocationsResponse.dart';
import 'package:generp/Models/commonModels/commonAccessiblePagesResponse.dart';
import 'package:generp/Models/commonModels/commonAddAccountsViewResponse.dart';
import 'package:generp/Models/crmModels/AccessiblePagesResponse.dart';
import 'package:generp/Models/crmModels/GetDistrictOnStateResponse.dart';
import 'package:generp/Models/crmModels/GetSegmentOnTeamResponse.dart';
import 'package:generp/Models/crmModels/GetSourceOnReferenceResponse.dart';
import 'package:generp/Models/crmModels/GetSubLocOnDistrictResponse.dart';
import 'package:generp/Models/crmModels/LeadListContactPopUpResponse.dart';
import 'package:generp/Models/crmModels/LeadListViewResponse.dart';
import 'package:generp/Models/crmModels/ProspectListViewResponse.dart';
import 'package:generp/Models/crmModels/SubmitLeadListFilterResponse.dart';
import 'package:generp/Models/crmModels/crmDashboardQuotationResponse.dart';
import 'package:generp/Models/crmModels/crmDownloadGenQuoteResponse.dart';
import 'package:generp/Models/crmModels/crmLeadDetailsGenerateQuotationSubmitResponse.dart';
import 'package:generp/Models/crmModels/crmNewLeadsProspectsSubmitResponse.dart';
import 'package:generp/Models/crmModels/crmNewLeadsProspectsViewResponse.dart';
import 'package:generp/Models/crmModels/crmProspectDetailsAddFollowUpAppointmentResponse.dart';
import 'package:generp/Models/crmModels/crmProspectDetailsAddLeadsResponse.dart';
import 'package:generp/Models/crmModels/crmProspectDetailsResponse.dart';
import 'package:generp/Models/financeModels/ValidateGstNumResponse.dart';
import 'package:generp/Models/financeModels/addDirectPaymentResponse.dart';
import 'package:generp/Models/financeModels/paymentRequisitionPaymentsListResponse.dart';
import 'package:generp/Models/hrmModels/advanceListResponse.dart';
import 'package:generp/Models/hrmModels/attendanceRequestListResponse.dart';
import 'package:generp/Models/hrmModels/casualLeaveHistoryResponse.dart';
import 'package:generp/Models/hrmModels/contactListResponse.dart';
import 'package:generp/Models/hrmModels/jobDescriptionResponse.dart';
import 'package:generp/Models/hrmModels/leaveApplicationDetailsResponse.dart';
import 'package:generp/Models/hrmModels/leaveApplicationLIstResponse.dart';
import 'package:generp/Models/hrmModels/rewardListResponse.dart';
import 'package:generp/Models/hrmModels/tourExpensesAddViewResponse.dart';
import 'package:generp/Models/hrmModels/tourExpensesDetailsResponse.dart';
import 'package:generp/Models/hrmModels/tourExpensesListResponse.dart';
import 'package:generp/Models/ordersModels/PendingTPCAgentListResponse.dart';
import 'package:generp/Models/ordersModels/TPCAgentDetailsResponse.dart';
import 'package:generp/Models/ordersModels/TPCListResponse.dart';
import 'package:generp/Models/ordersModels/orderDashboardResponse.dart';
import 'package:generp/services/api_names.dart';
import 'package:generp/services/api_post_request.dart';
import 'package:http/http.dart' as http;
import 'package:path_provider/path_provider.dart';

import '../Models/AccountSuggestionResponse.dart';
import '../Models/AddContactResponse.dart';
import '../Models/AttendanceListResponse.dart';
import '../Models/CheckInResponse.dart';
import '../Models/CheckOutResponse.dart';
import '../Models/ComplaintsSelectionResponse.dart';
import '../Models/DashboardResponse.dart';
import '../Models/DayWiseAttendance.dart';
import '../Models/FollowUpResponse.dart';
import '../Models/Inventory_Part_details_response.dart';
import '../Models/LoginQRResponse.dart';
import '../Models/LogoutResponse.dart';
import '../Models/NearbyGeneratorsResponse.dart';
import '../Models/PaymentCollectionResponse.dart';
import '../Models/PaymentCollectionValidateOTPResponse.dart';
import '../Models/PaymentCollectionWalletResponse.dart';
import '../Models/ProfileResponse.dart';
import '../Models/SessionResponse.dart';
import '../Models/StatusResponse.dart';
import '../Models/SubmitComplaintResponse.dart';
import '../Models/TagGeneratorResponse.dart';
import '../Models/TagLocationResponse.dart';
import '../Models/TechnicianAddPaymentCollectionResponse.dart';
import '../Models/TechnicianDashboardResponse.dart';
import '../Models/TechnicianLoadNumbersResponse.dart';
import '../Models/TechniciansPendingComplaintsResponse.dart';
import '../Models/TodayVisitResponse.dart';
import '../Models/UpdateComplaintResponse.dart';
import '../Models/UpdatePasswordResponse.dart';
import '../Models/VersionsResponse.dart';
import '../Models/ViewVisitDetailsResponse.dart';
import '../Models/commonModels/commonAddAccountsSubmitResponse.dart';
import '../Models/crmModels/appointmentCalendarResponse.dart';
import '../Models/crmModels/crmAddFollowUpResponse.dart';
import '../Models/crmModels/crmDashboardFollowUpResponse.dart';
import '../Models/crmModels/crmDashboardResponse.dart';
import '../Models/crmModels/crmPendingTasksResponse.dart';
import '../Models/crmModels/crmSelectedProductDetailsResponse.dart';
import '../Models/crmModels/crmUniversalSearchResponse.dart';
import '../Models/financeModels/ValidateBankAccountDetailsResponse.dart';
import '../Models/financeModels/paymentRequestionBankDetailsResponse.dart';
import '../Models/commonModels/commonAccountLedgerFilterResponse.dart';
import '../Models/commonModels/commonAccountLedgerResponse.dart';
import '../Models/commonModels/commonAccountdetailsResponse.dart';
import '../Models/commonModels/commonAccountlistResponse.dart';
import '../Models/crmModels/LeadDetailsResponse.dart';
import '../Models/crmModels/NearbyOpenLeadsResponse.dart';
import '../Models/crmModels/SubmitProspectListFilterResponse.dart';
import '../Models/crmModels/crmLeadDetailsEditAccountViewResponse.dart';
import '../Models/crmModels/crmLeadDetailsEditProductsViewResponse.dart';
import '../Models/crmModels/crmLeadDetailsGenerateQuotationViewResponse.dart';
import '../Models/crmModels/crmProspectDetailsEditAccountViewResponse.dart';
import '../Models/financeModels/addPaymentRequestionResponse.dart';
import '../Models/financeModels/addReceiptPaymentResponse.dart';
import '../Models/financeModels/paymentRequesitionListsResponse.dart';
import '../Models/financeModels/paymentRequisitionDetailsResponse.dart';
import '../Models/financeModels/paymentRequisitionPaymentsDetailsResponse.dart';
import '../Models/financeModels/paymentRequisitionPaymentsReceiptsDetailsResponse.dart';
import '../Models/financeModels/paymentRequisitionPaymentsReceiptsListResponse.dart';
import '../Models/generatorComplaintResponse.dart';
import '../Models/hrmModels/attendanceRequestDetailsResponse.dart';
import '../Models/hrmModels/hrmAccessiblePagesResponse.dart';
import '../Models/hrmmodels/ogresponse.dart';
import '../Models/loadGeneratorDetailsResponse.dart';
import '../Models/financeModels/financeDashboardPagesResponse.dart';
import '../Models/ordersModels/AddOrderPaymentSelectAccountResponse.dart';
import '../Models/ordersModels/AddOrderPaymentSelectOrderResponse.dart';
import '../Models/ordersModels/AddOrderViewResponse.dart';
import '../Models/ordersModels/EditPaymentDetailsAdjustedOrdersViewResponse.dart';
import '../Models/ordersModels/addOrderAccontDetailsResponse.dart';
import '../Models/ordersModels/addOrderPaymentViewResponse.dart';
import '../Models/ordersModels/addOrderTpcAgentListResponse.dart';
import '../Models/ordersModels/commonResponse.dart';
import '../Models/ordersModels/orderPendingTasksListResponse.dart';
import '../Models/ordersModels/ordersAccessiblePagesResponse.dart';
import '../Models/ordersModels/ordersDetailsByModeResponse.dart';
import '../Models/ordersModels/ordersDetailsDispatchOrderViewResponse.dart';
import '../Models/ordersModels/ordersDetailsEditOrderViewResponse.dart';
import '../Models/ordersModels/ordersListByModeFilterResponse.dart';
import '../Models/ordersModels/ordersListByModeResponse.dart';
import '../Models/ordersModels/ordersPdiIdByEngNumberResponse.dart';
import '../Models/ordersModels/paymentDetailsByModeFilterResponse.dart';
import '../Models/ordersModels/paymentListByModeFilterResponse.dart';
import '../Models/ordersModels/paymentListByModeResponse.dart';
import '../Models/ordersModels/technicianAddPaymentResendOTPResponse.dart';
import '../Notifiers/financeProvider/approveRejectPaymentRequestResponse.dart';
import '../Utils/commonServices.dart';
import 'package:http_parser/http_parser.dart';

class ApiCalling {
  static Future download_files(empId, session, url, cntxt) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, url, {});
      if (res != null) {
        final bytes = res.bodyBytes;
        var directory = "";
        if (Platform.isAndroid) {
          directory = "/storage/emulated/0/Download";
          var directory0 = Directory(directory);
          if (!directory0.existsSync()) {
            // If the directory does not exist, create it
            directory0.createSync(recursive: true);
            debugPrint('Directory created: $directory0');
          } else {
            debugPrint('Directory already exists: $directory0');
          }
          // final androiddirectory = await getDownloadsDirectory();
          // directory = androiddirectory!.path;
        } else if (Platform.isIOS) {
          final iosDirectory = await getApplicationSupportDirectory();
          directory = iosDirectory.path;
        }

        final contentDisposition = res.headers['content-disposition'];
        debugPrint(
          "contentDisposition ${contentDisposition?.split('filename=')[1]}",
        );

        // final filename = contentDisposition != null
        //     ? contentDisposition.split('filename=')[1]
        //     : 'file';
        var filename = (contentDisposition?.split('filename=')[1])?.replaceAll(
          '"',
          "",
        );
        // ignore: unnecessary_brace_in_string_interps
        final file = File('${directory}/${filename}');
        await file.writeAsBytes(bytes);
        toast(
          cntxt,
          "File saved to your downloads as $filename to $directory, Successfully",
        );
        debugPrint('File saved successfully');
        return jsonDecode(res.body);
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<VersionsResponse?> checkAppVersionApi() async {
    try {
      final response = await post({}, getAppVersionUrl, {});
      if (response != null) {
        print(response.body);
        return VersionsResponse.fromJson(jsonDecode(response.body));
      } else {
        return null;
      }
    } catch (e) {
      return null;
    }
  }

  static Future<SessionResponse?> CheckSessionExistsApi(empId, session) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      // print(data);
      final res = await post(data, getEmployeeSessionDetailsUrl, {});
      if (res != null) {
        // print("check_session: ${res.body}");
        return SessionResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<MissedCheckoutStripResponse?> missedCheckoutStripApi(empId, session) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      // print(data);
      final res = await post(data, missedCheckoutUrl, {});
      if (res != null) {
        print("Api call data: ${res.body}");
        return MissedCheckoutStripResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<StatusResponse?> LoginFunctionApi(
    email,
    password,
    token,
    deviceID,
    deviceInfo,
  ) async {
    try {
      Map<String, String> data = {
        'email_id': (email).toString(),
        'password': (password).toString(),
        'token_id': (token).toString(),
        'device_id': (deviceID).toString(),
        'device_details': (deviceInfo).toString(),
      };
      final res = await post(data, loginUrl, {});
      if (res != null) {
        // debugPrint("Login: ${res.body}");
        // print(data);
        return StatusResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<UpdatePasswordResponse?> UpdatePasswordApi(
    empId,
    session,
    password,
    confPassword,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'password': (password).toString(),
        'confirm_password': (confPassword).toString(),
      };
      final res = await post(data, updatePasswordUrl, {});
      if (res != null) {
        debugPrint("update password ${res.body}");
        debugPrint("update password $data");
        return UpdatePasswordResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<DashboardResponse?> DashboardFunctionApi(empId, session) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, employeeDashboardUrl, {});
      if (res != null) {
        // debugPrint("Dashboard: ${res.body}");
        return DashboardResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<ProfileResponse?> ProfileFunctionApi(empId, session) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, employeeProfileUrl, {});
      if (res != null) {
        // debugPrint("profile-details: ${res.body}");

        return ProfileResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<LoginQRResponse?> QRLoginRequestAPI(
    empId,
    session,
    type,
    token,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'type': (type).toString(),
        'token': (token).toString(),
      };
      final res = await post(data, qrCodeLoginUrl, {});
      if (res != null) {
        // debugPrint(res.body);
        return LoginQRResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<LogoutResponse?> LogoutFunctionApi(empId, session) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, logoutAppUrl, {});
      if (res != null) {
        // debugPrint(res.body);

        return LogoutResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CheckInResponse?> CheckInApi(
    empId,
    sessioId,
    location,
    latlngs,
    checkInPic,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (sessioId).toString(),
        'posit': (latlngs).toString(),
        'location': (location).toString(),
      };
      var res;
      // if (check_in_pic != null) {
      res = await postImage(data, employeeChekInUrl, {}, checkInPic);
      res = jsonDecode(res);
      // } else {
      //   // res = await post(data, employeeChekInUrl, {});
      //   // res = jsonDecode(res.body);
      // }
      if (res != null) {
        return CheckInResponse.fromJson(res);
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CheckOutResponse?> CheckOutApi(
    empId,
    sessioId,
    location,
    latlngs,
    checkOutPic,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (sessioId).toString(),
        'location': (location).toString(),
        'posit': (latlngs).toString(),
      };
      var res;
      // if (image != null) {
      //   res = await postImage2(data, {}, employeeCheckOutUrl, image);
      //   res = jsonDecode(res);
      // } else {
      //   res = await post(data, employeeCheckOutUrl, {});
      //   res = jsonDecode(res);
      // }
      // if (res != null) {
      //   return CheckOutResponse.fromJson(res);
      // } else {
      //   debugPrint("Null Response");
      //   return null;
      // }
      // if (check_out_pic != null) {
      res = await postImageNew(
        data,
        {},
        employeeCheckOutUrl,
        checkOutPic,
        'check_out_pic',
      );
      if (res != null) {
        res = jsonDecode(res);
      }

      // } else {
      //   res = await post(data, employeeCheckOutUrl, {});
      //   res = jsonDecode(res.body);
      // }
      return CheckOutResponse.fromJson(res);
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<AttendanceDashboard?> AttendanceListApi(empId, session) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, employeeAttendanceDashboardUrl, {});
      if (res != null) {
        // debugPrint(res.body);
        return AttendanceDashboard.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static LoadAttendanceDetails(empId, session, month, year) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'year': (year).toString(),
        'month': month.toString(),
      };
      final res = await post(data, employeeMonthwiseAttendanceUrl, {});
      if (res != null) {
        // debugPrint("montly attendance: ${res.body}");
        // return AttendanceHistory.fromJson(jsonDecode(res.body));
        return res.body;
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<AttendanceDaywiseResponse?> DateWiseAttendanceApi(
    empId,
    session,
    date,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'date': (date).toString(),
      };
      final res = await post(data, employeeDayAttendanceDetailsUrl, {});
      if (res != null) {
        // debugPrint("Attendacnce API /; ${res.body}");
        return AttendanceDaywiseResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  ///gen tracker

  static Future<loadGeneratorDetailsResponse?> LoadGeneratorDetailsAPI(
    empId,
    session,
    genHashId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'gen_hash_id': (genHashId).toString(),
      };
      final res = await post(data, genTrackerGeneratorDetailsUrl, {});
      if (res != null) {
        debugPrint("gen details222: ${jsonDecode(res.body)['complaint_list']}");
        return loadGeneratorDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<generatorComplaintResponse?> LoadGeneratorComplaintListAPI(
    empId,
    session,
    genId,
    openStatus,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'gen_id': (genId).toString(),
        'open_status': (openStatus).toString(),
      };
      final res = await post(data, genTrackerGeneratorComplaintsUrl, {});
      if (res != null) {
        // debugPrint(res.body);
        return generatorComplaintResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<TagLocationResponse?> TagLocationAPI(
    empId,
    session,
    genHashId,
    location,
    attachment,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'gen_hash_id': (genHashId).toString(),
        'location': (location).toString(),
      };
      print("Tag Loation: $data");
      var res;
      if (attachment != null) {
        res = await postImageNew(
          data,
          {},
          genTrackerTagLocationUrl,
          attachment,
          "attachment",
        );
        res = jsonDecode(res);
        return TagLocationResponse.fromJson(res);
      } else {
        res = await post(data, genTrackerTagLocationUrl, {});
        if (res != null) {
          // debugPrint(res.body);
          return TagLocationResponse.fromJson(jsonDecode(res.body));
        } else {
          debugPrint("Null Response");
          return null;
        }
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<TagGeneratorResponse?> TagGeneratorAPI(
    empId,
    session,
    genHashId,
    engineNo,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'gen_hash_id': (genHashId).toString(),
        'engine_no': (engineNo).toString(),
      };
      final res = await post(data, genTrackerTagGeneratorUrl, {});
      if (res != null) {
        // debugPrint(res.body);
        return TagGeneratorResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<TagGeneratorResponse?> TagGeneratorCheckAPI(
    empId,
    session,
    genHashId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'gen_hash_id': (genHashId).toString(),
      };
      final res = await post(data, genTrackerCheckTagGeneratorUrl, {});
      if (res != null) {
        // debugPrint(res.body);
        return TagGeneratorResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<SubmitComplaintResponse?> SubmitGeneratorComplaintAPI(
    empId,
    session,
    complaintTypeId,
    complaintCategoryId,
    complaintDescId,
    runningHrs,
    genId,
    complaintNote,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'complaint_type_id': (complaintTypeId).toString(),
        'complaint_category_id': (complaintCategoryId).toString(),
        'complaint_desc_id': (complaintDescId).toString(),
        'running_hrs': (runningHrs).toString(),
        'gen_id': (genId).toString(),
        'complaint_note': (complaintNote).toString(),
      };
      final res = await post(data, genTrackerRegisterComplaint, {});
      if (res != null) {
        // debugPrint(res.body);
        return SubmitComplaintResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<ComplaintsSelectionResponse?> ComplaintSelectionAPI(
    empId,
    session,
    genHashId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'gen_hash_id': (genHashId).toString(),
      };
      final res = await post(data, complaintsSelectionUrl, {});
      if (res != null) {
        // debugPrint(res.body);
        return ComplaintsSelectionResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  ///Inventory Module API's

  static Future<Inventory_Part_details_response?> LoadPartDetailsAPI(
    empId,
    session,
    partId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'part_id': (partId).toString(),
      };
      final res = await post(data, inventoryPartDetailsUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return Inventory_Part_details_response.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<loadGeneratorDetailsResponse?> InventoryUpdateStockAPI(
    empId,
    session,
    qty,
    descr,
    partId,
    tranType,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'qty': (qty).toString(),
        'descr': (descr).toString(),
        'product_id': (partId).toString(),
        'tran_type': (tranType).toString(),
      };
      final res = await post(data, inventoryStockUpdateUrl, {});
      if (res != null) {
        print("Issue Receive $data");
        debugPrint(res.body);
        return loadGeneratorDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  ///technician
  static Future<loadGeneratorDetailsResponse?>
  LoadTechnicianGeneratorDetailsAPI(empId, session, genId) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'gen_id': (genId).toString(),
      };
      final res = await post(data, technicianGeneratorDetailsUrl, {});

      if (res != null) {
        print("genderrails:${jsonDecode(res.body)}");
        return loadGeneratorDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<TechnicianResponse?> loadTechnicianDashboardApi(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, technicianDashboardUrl, {});
      if (res != null) {
        // debugPrint(res.body);
        return TechnicianResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<TodayVisitResponse?> getTodayVisitsListAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, technicianTodayVisitsUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return TodayVisitResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<TodayVisitResponse?> getMonthVisitsListAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, technicianMonthlyVisitsUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return TodayVisitResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<NearbyGeneratorsResponse?> loadNearbyGeneratorsAPI(
    empId,
    session,
    techLoc,
    radius,
    status,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'tech_loc': (techLoc).toString(),
        'radius': (radius).toString(),
        'status': (status).toString(),
      };
      final res = await post(data, technicianNearbyGeneratorsUrl, {});
      if (res != null) {
        // print(data);
        // debugPrint(res.body);
        return NearbyGeneratorsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<AccountSuggestionResonse?> AccountSuggestionAPI(
    empId,
    session,
    searchString,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'search_string': (searchString).toString(),
      };
      final res = await post(data, technicianAccountSearchUrl, {});
      if (res != null) {
        // debugPrint(res.body);
        return AccountSuggestionResonse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<TechnicianPendingComplaintsResponse?>
  LoadTechnicianComplaintsAPI(empId, session) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, technicianPendingComplaintUrl, {});
      if (res != null) {
        // debugPrint(res.body);
        return TechnicianPendingComplaintsResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<TechnicianLoadNumbersResponse?> LoadContactsTechnicianAPI(
    empId,
    session,
    type,
    genId,
    accountId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'type': (type).toString(),
        'gen_id': (genId).toString(),
        'account_id': (accountId).toString(),
      };
      print(data);
      final res = await post(data, technicianAddPaymentUrl, {});
      if (res != null) {
        // debugPrint(res.body);
        return TechnicianLoadNumbersResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<TechnicianAddPaymentCollectionResponse?>
  TechnicianUpdatepaymentAPI(
    empId,
    session,
    refType,
    refId,
    paymentModeId,
    paymentRefNo,
    amount,
    otpValidatedName,
    otpValidatedMobileNumber,
    paymentProof,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'ref_type': (refType).toString(),
        'ref_id': (refId).toString(),
        'payment_mode_id': (paymentModeId).toString(),
        'payment_ref_no': (paymentRefNo).toString(),
        'amount': (amount).toString(),
        'otp_validated_name': (otpValidatedName).toString(),
        'otp_validated_mobile_number': (otpValidatedMobileNumber).toString(),
      };
      var res;
      // if (payment_proof != null) {
      //   res = await postImage3(
      //     data,
      //     {},
      //     technicianAddPaymentCollectionUrl,
      //     payment_proof,
      //   );
      //   res = jsonDecode(res);
      // } else {
      //   res = await post(data, technicianAddPaymentCollectionUrl, {});
      //   res = jsonDecode(res);
      // }
      // if (res != null) {
      //   return TechnicianAddPaymentCollectionResponse.fromJson(res);
      // } else {
      //   debugPrint("Null Response");
      //   return null;
      // }
      print("send otp:$data");
      if (paymentProof != null) {
        res = await postImageNew(
          data,
          {},
          technicianAddPaymentCollectionUrl,
          paymentProof,
          'payment_proof',
        );

        print("Add Payment $res");
        res = jsonDecode(res);
      } else {
        print("Add Payment $res");
        res = await post(data, technicianAddPaymentCollectionUrl, {});
        res = jsonDecode(res.body);
        // return TechnicianAddPaymentCollectionResponse.fromJson(res);
      }
      return TechnicianAddPaymentCollectionResponse.fromJson(res);
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<PaymentCollectionValidateOTPResponse?>
  TechnicianPaymentOTPValidateAPI(
    empId,
    session,
    paymentCollectionId,
    otp,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'payment_collection_id': (paymentCollectionId).toString(),
        'otp': (otp).toString(),
      };
      final res = await post(data, technicianPaymentCollectionOtpUrl, {});
      if (res != null) {
        debugPrint("OTP${res.body}");
        return PaymentCollectionValidateOTPResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<Technicianaddpaymentresendotpresponse?>
  TechnicianPaymentOTPResendAPI(empId, session, paymentCollectionId) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'payment_collection_id': (paymentCollectionId).toString(),
      };
      final res = await post(data, technicianAddPaymentResendOTPUrl, {});
      if (res != null) {
        debugPrint("OTP${res.body}");
        return Technicianaddpaymentresendotpresponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<PaymentCollectionResponse?> paymentCollectionListAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, technicianPaymentCollectionUrl, {});
      if (res != null) {
        // debugPrint(res.body);
        return PaymentCollectionResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<PaymentCollectionWalletResponse?> loadTransactionsListAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, technicianWalletCollectionUrl, {});
      if (res != null) {
        // debugPrint(res.body);
        return PaymentCollectionWalletResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<ViewVisitDetailsResponseNew?> loadVisitDetailsAPI(
    empId,
    session,
    compId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'comp_id': (compId).toString(),
      };
      final res = await post(data, technicianComplaintDetailsUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return ViewVisitDetailsResponseNew.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<FollowupListResponse?> loadFollowupListAPI(
    empId,
    session,
    compId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'comp_id': (compId).toString(),
      };
      final res = await post(data, technicianComplaintFollowUpUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return FollowupListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<AddContactResponse?> AddContactAPI(
    empId,
    session,
    genId,
    name,
    designation,
    mob1,
    mob2,
    tel,
    mail,
    type,
    accountId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'gen_id': (genId).toString(),
        'name': (name).toString(),
        'designation': (designation).toString(),
        'mob1': (mob1).toString(),
        'mob2': (mob2).toString(),
        'tel': (tel).toString(),
        'mail': (mail).toString(),
        'type': (type).toString(),
        'account_id': (accountId).toString(),
      };
      print("add: $data");
      final res = await post(data, technicianAddContactUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return AddContactResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<UpdateComplaintResponse?> UpdateComplaintAPI(
    empId,
    session,
    complaintId,
    inTime,
    feedback,
    fsrNo,
    runningHrs,
    complaintStatus,
    fsrFile,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'complaint_id': (complaintId).toString(),
        'in_time': (inTime).toString(),
        'feedback': (feedback).toString(),
        'fsr_no': (fsrNo).toString(),
        'running_hrs': (runningHrs).toString(),
        'complaint_status': (complaintStatus).toString(),
      };
      // print(data);
      // print(fsr_file);
      var res;
      if (fsrFile != null) {
        res = await postImageNew(
          data,
          {},
          technicianUpdateVisitUrl,
          fsrFile,
          'fsr_file',
        );
        res = jsonDecode(res);
        return UpdateComplaintResponse.fromJson(res);
      } else {
        res = await post(data, technicianUpdateVisitUrl, {});
        res = jsonDecode(res.body);
        return UpdateComplaintResponse.fromJson(res);
      }

      // debugPrint(res);
      if (res != null) {
        // debugPrint(res);
        return UpdateComplaintResponse.fromJson(res);
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  ///finance Module
  static Future<financeDashboardPagesResponse?> financeDashboardPagesAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, financeDashboardPagesUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return financeDashboardPagesResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<financeDashboardPagesResponse?>
  addFormfinanceFormAccessPagesAPI(empId, session) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, financeAddFormPagesAccessUrl, {});
      if (res != null) {
        debugPrint("adjf:${res.body}");
        return financeDashboardPagesResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<addPaymentRequestionResponse?> addPaymentRequestionViewAPI(
    empId,
    session,
    mode,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
      };
      final res = await post(data, addPaymentRequestionViewUrl, {});
      if (res != null) {
        // print("add view:${data}");
        // debugPrint(res.body);
        return addPaymentRequestionResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<addDirectPaymentResponse?> addDirectPaymentRequestionViewAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, addDirectPaymentRequestionViewUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return addDirectPaymentResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<addReceiptPaymentResponse?> addReceiptPaymentRequestionViewAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, addPaymentReceiptViewUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return addReceiptPaymentResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> addPaymentRequestionSubmitAPI(
    empId,
    sessionId,
    type,
    accountId,
    requestingPurpose,
    description,
    amount,
    paymentModeId,
    bankName,
    bankBranchName,
    bankAccNumber,
    bankIfscCode,
    accHolderName,
    bankUpiId,
    approvalAssigneeEmpId,
    attachment,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': empId.toString(),
        'session_id': sessionId.toString(),
        'type': type.toString(),
        'account_id': accountId.toString(),
        'requesting_purpose': requestingPurpose.toString(),
        'description': description.toString(),
        'amount': amount.toString(),
        'payment_mode_id': paymentModeId.toString(),
        'bank_name': bankName.toString(),
        'bank_branch_name': bankBranchName.toString(),
        'bank_acc_number': bankAccNumber.toString(),
        'bank_ifsc_code': bankIfscCode.toString(),
        'acc_holder_name': accHolderName.toString(),
        'bank_upi_id': bankUpiId.toString(),
        'approval_assignee_emp_id': approvalAssigneeEmpId.toString(),
      };

      var res;
      print(data);
      if (attachment != null) {
        res = await postImageNew(
          data,
          {},
          addPaymentRequestionSubmitUrl,
          attachment,
          "attachment",
        );
        res = jsonDecode(res);
        return CommonResponse.fromJson(res);
      } else {
        res = await post(data, addPaymentRequestionSubmitUrl, {});
        res = jsonDecode(res.body);
        return CommonResponse.fromJson(res);
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<addDirectPaymentResponse?> addDirectPaymentRequestionSubmitAPI(
    empId,
    sessionId,
    fromAccountId,
    toAccountId,
    description,
    paymentModeId,
    amount,
    paymentDate,
    paymentReferenceNumber,
    bankName,
    bankBranchName,
    bankAccNumber,
    bankIfscCode,
    accHolderName,
    bankUpiId,
    attachment,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': empId.toString(),
        'session_id': sessionId.toString(),
        'from_account_id': fromAccountId.toString(),
        'to_account_id': toAccountId.toString(),
        'description': description.toString(),
        'payment_mode_id': paymentModeId.toString(),
        'amount': amount.toString(),
        'payment_date': paymentDate.toString(),
        'payment_reference_number': paymentReferenceNumber.toString(),
        'bank_name': bankName.toString(),
        'bank_branch_name': bankBranchName.toString(),
        'bank_acc_number': bankAccNumber.toString(),
        'bank_ifsc_code': bankIfscCode.toString(),
        'acc_holder_name': accHolderName.toString(),
        'bank_upi_id': bankUpiId.toString(),
      };
      print(data);
      print(attachment);
      var res;
      if (attachment != null) {
        res = await postImageNew(
          data,
          {},
          addDirectPaymentRequestionSubmitUrl,
          attachment,
          "attachment",
        );
        res = jsonDecode(res);
        return addDirectPaymentResponse.fromJson(res);
      } else {
        res = await post(data, addDirectPaymentRequestionSubmitUrl, {});
        res = jsonDecode(res.body);
        print(res);
        return addDirectPaymentResponse.fromJson(res);
      }
      if (res != null) {
        return res;
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<addReceiptPaymentResponse?>
  addReceiptPaymentRequestionSubmitAPI(
    empId,
    sessionId,
    fromAccountId,
    toAccountId,
    description,
    paymentModeId,
    amount,
    receiptDate,
    paymentReferenceNumber,
    bankName,
    bankBranchName,
    bankAccNumber,
    bankIfscCode,
    accHolderName,
    bankUpiId,
    attachment,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': empId.toString(),
        'session_id': sessionId.toString(),
        'from_account_id': fromAccountId.toString(),
        'to_account_id': toAccountId.toString(),
        'description': description.toString(),
        'payment_mode_id': paymentModeId.toString(),
        'amount': amount.toString(),
        'receipt_date': receiptDate.toString(),
        'payment_reference_number': paymentReferenceNumber.toString(),
        'bank_name': bankName.toString(),
        'bank_branch_name': bankBranchName.toString(),
        'bank_acc_number': bankAccNumber.toString(),
        'bank_ifsc_code': bankIfscCode.toString(),
        'acc_holder_name': accHolderName.toString(),
        'bank_upi_id': bankUpiId.toString(),
      };

      var res;
      if (attachment != null) {
        res = await postImageNew(
          data,
          {},
          addPaymentReceiptSubmitUrl,
          attachment,
          "attachment",
        );
        res = jsonDecode(res);
      } else {
        res = await post(data, addPaymentReceiptSubmitUrl, {});
        res = jsonDecode(res.body);
        // return addReceiptPaymentResponse.fromJson(res);
      }
      return addReceiptPaymentResponse.fromJson(res);
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<paymentRequesitionListsResponse?> paymentRequestionListsAPI(
    empId,
    session,
    mode,
    fromDate,
    toDate,
    pageNumber,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
        'from': fromDate.toString(),
        'to': toDate.toString(),
        'page_number': pageNumber.toString(),
      };
      print(data);
      final res = await post(data, paymentRequestionListUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return paymentRequesitionListsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<paymentRequisitionDetailsResponse?> paymentRequestionDetailsAPI(
    empId,
    session,
    paymentRequestId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'payment_request_id': (paymentRequestId).toString(),
      };
      final res = await post(data, paymentRequestionDetailsUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return paymentRequisitionDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  /// validate Gst Number Api
  static Future<ValidateGstNumResponse?> validateGstNumberApi(
      empId,
      session,
      gstNumber,
      ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'gst_number': (gstNumber).toString(),
      };
      final res = await post(data, validateGstNumberUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return ValidateGstNumResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello validateGstNumberApi $e ');
      return null;
    }
  }

  /// validate bank account details api
  static Future<ValidateBankAccountDetailsResponse?> validateBankAccountDetailsApi(
      empId,
      session,
      accountNum,
      ifscCode
      ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'account_number': (accountNum).toString(),
        'ifsc_code': (ifscCode).toString(),
      };
      final res = await post(data, validateBankAccountDetailsUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return ValidateBankAccountDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello validateBankAccountDetails $e ');
      return null;
    }
  }

  static Future<paymentRequestionBankDetailsResponse?>
  paymentRequestionBankDetailsAPI(empId, session, accountId) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'account_id': (accountId).toString(),
      };
      final res = await post(data, paymentRequestBankDetailsUrl, {});
      if (res != null) {
        print("Bank Detaols $data");
        debugPrint(res.body);
        return paymentRequestionBankDetailsResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<approveRejectPaymentRequestResponse?>
  approveRejectPaymentRequestAPI(empId, session, paymentRequestId) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'payment_request_id': (paymentRequestId).toString(),
      };
      final res = await post(data, approveRejectPaymentRequestUrl, {});
      if (res != null) {
        print("add payment:$data");
        debugPrint(res.body);
        return approveRejectPaymentRequestResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<approveRejectPaymentRequestResponse?>
  RejectPaymentRequestSubmitAPI(
    empId,
    session,
    mode,
    paymentRequestId,
    approveRemarks,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'type': 'reject',
        'mode': mode.toString(),
        'payment_request_id': (paymentRequestId).toString(),
        'approve_remarks': approveRemarks,
      };
      final res = await post(data, approveRejectPaymentRequestSubmitUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return approveRejectPaymentRequestResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<approveRejectPaymentRequestResponse?>
  ApprovePaymentRequestSubmitAPI(
    empId,
    session,
    mode,
    paymentRequestId,
    approvedAmount,
    approveRemarks,
    proposedPaymentAccountId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'type': 'approve',
        'mode': mode.toString(),
        'payment_request_id': (paymentRequestId).toString(),
        'approve_remarks': approveRemarks,
        'approved_amount': approvedAmount,
        'proposed_payment_account_id': proposedPaymentAccountId,
      };
      // print(data);
      final res = await post(data, approveRejectPaymentRequestSubmitUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return approveRejectPaymentRequestResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> processApproveRejectPaymentRequestSubmitAPI(
    empId,
    session,
    mode,
    paymentReferenceNumber,
    paymentAmount,
    paymentRequestId,
    paymentAccountId,
    processingRemarks,
    attachment,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'type': 'approve'.toString(),
        'mode': mode.toString(),
        'payment_reference_number': paymentReferenceNumber.toString(),
        'payment_amount': paymentAmount.toString(),
        'payment_request_id': (paymentRequestId).toString(),
        'payment_account_id': paymentAccountId.toString(),
        'processing_remarks': processingRemarks.toString(),
      };
      var res;
      print("Process:$data");
      if (attachment != null) {
        res = await postImageNew(
          data,
          {},
          approveRejectPaymentRequestSubmitUrl,
          attachment,
          "attachment",
        );
        print("Process:$data");
        res = jsonDecode(res);
        print(data);
        return CommonResponse.fromJson(res);
      } else {
        res = await post(data, approveRejectPaymentRequestSubmitUrl, {});
        res = jsonDecode(res.body);
        return CommonResponse.fromJson(res);
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<paymentRequisitionPaymentsListResponse?>
  paymentRequisitionPaymentListAPI(empId, session, from, to, pageNumber) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'from': (from).toString(),
        'to': (to).toString(),
        'page_number': (pageNumber).toString(),
      };
      final res = await post(data, paymentRequesitionPaymentsListUrl, {});
      if (res != null) {
        print(data);

        print("payment req:${res.body}");
        return paymentRequisitionPaymentsListResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<paymentRequisitionPaymentsReceiptsListResponse?>
  paymentRequisitionPaymentReceiptListAPI(
    empId,
    session,
    from,
    to,
    pageNumber,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'from': (from).toString(),
        'to': (to).toString(),
        'page_number': (pageNumber).toString(),
      };
      final res = await post(
        data,
        paymentRequesitionPaymentsReceiptsListUrl,
        {},
      );
      if (res != null) {
        debugPrint(res.body);
        return paymentRequisitionPaymentsReceiptsListResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<paymentRequisitionPaymentsDetailsResponse?>
  paymentRequisitionPaymentDetailsAPI(empId, session, paymentId) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'payment_id': (paymentId).toString(),
      };
      final res = await post(data, paymentRequesitionPaymentsDetailsUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return paymentRequisitionPaymentsDetailsResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<paymentRequisitionPaymentsReceiptsDetailsResponse?>
  paymentRequisitionPaymentReceiptDetailsAPI(empId, session, paymentId) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'payment_receipt_id': (paymentId).toString(),
      };
      final res = await post(
        data,
        paymentRequesitionPaymentsReceiptsDetailsUrl,
        {},
      );
      if (res != null) {
        debugPrint(res.body);
        return paymentRequisitionPaymentsReceiptsDetailsResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> editProcessedRequestAmountAPI(
    empId,
    session,
    processPaymentId,
    approvalAmount,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'process_payment_id': processPaymentId.toString(),
        'approval_amount': approvalAmount.toString(),
      };
      print("Process EDIT:$data");
      var res = await post(data, paymentRequesitionEditProcessedPaymentUrl, {});
      if (res != null) {
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  ///common Module
  static Future<commonAccessiblePagesResponse?> commonDashboardPagesAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, commonAccessiblePagesUrl, {});
      if (res != null) {
        debugPrint("CA:${res.body}");
        return commonAccessiblePagesResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<commonAddAccountsViewResponse?> commonAddAccountViewAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, commonAddAccountViewUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return commonAddAccountsViewResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<DistrictsResponse?> commonAddAccountViewDistrictAPI(
    empId,
    session,
    stateId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'state_id': stateId.toString(),
      };
      final res = await post(data, commonAddAccountViewgetDistrictUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return DistrictsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<SubLocationsResponse?> commonAddAccountViewSubLocationAPI(
    empId,
    session,
    districtId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'district_id': districtId.toString(),
      };
      final res = await post(data, commonAddAccountViewgetSubLocationUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return SubLocationsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<commonAddAccountsViewResponse?> commonAddAccountCheckInputsAPI(
    empId,
    session,
    type,
    typeValue,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'type': (type).toString(),
        'type_value': (typeValue).toString(),
      };
      final res = await post(data, commonAddAccountCheckInputsUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return commonAddAccountsViewResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<commonAddAccountsSubmitResponse?> commonAddAccountSubmitAPI(
    empId,
    session,
    type,
    name,
    mob1,
    mob2,
    tel,
    email,
    designation,
    address,
    state,
    district,
    subLocality,
    bankName,
    bankBranchName,
    bankIfscCode,
    bankAccountHolderName,
    bankAccountNumber,
    bankUpiId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'type': type.toString(),
        'name': name.toString(),
        'mob1': mob1.toString(),
        'mob2': mob2.toString(),
        'tel': tel.toString(),
        'email': email.toString(),
        'designation': designation.toString(),
        'address': address.toString(),
        'state': state.toString(),
        'district': district.toString(),
        'sub_locality': subLocality.toString(),
        'bank_name': bankName.toString(),
        'bank_branch_name': bankBranchName.toString(),
        'bank_ifsc_code': bankIfscCode.toString(),
        'bank_account_holder_name': bankAccountHolderName.toString(),
        'bank_account_number': bankAccountNumber.toString(),
        'bank_upi_id': bankUpiId.toString(),
      };
      final res = await post(data, commonAddAccountSubmit, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return commonAddAccountsSubmitResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<commonAccountlistResponse?> commonAccountListAPI(
    empId,
    session,
    pageNumber,
    companyName,
    mobileNumber,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'page_number': pageNumber.toString(),
        'company_name': companyName.toString(),
        'mobile_number': mobileNumber.toString(),
      };
      final res = await post(data, commonAccountListUrl, {});
      if (res != null) {
        debugPrint("adad:${res.body}");
        return commonAccountlistResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<commonAccountdetailsResponse?> commonAccountDetailsAPI(
    empId,
    session,
    accountId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'account_id': accountId.toString(),
      };
      final res = await post(data, commonAccountLedgerAccountDetails, {});
      if (res != null) {
        debugPrint(res.body);
        return commonAccountdetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<commonAccountLedgerFilterResponse?>
  commonAccountLedgerDropDownAPI(empId, session) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, commonAccountLedgerDropDownUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return commonAccountLedgerFilterResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<commonAccountLedgerResponse?> commonAccountLedgerListAPI(
    empId,
    session,
    accountId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'account_id': accountId.toString(),
      };
      print(data);
      final res = await post(data, commonAccountLedgerListWithFilterUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return commonAccountLedgerResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  ///Orders Module
  static Future<ordersAccessiblePagesResponse?> ordersAccesiblePagesAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, ordersAccessiblePagesUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return ordersAccessiblePagesResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<ordersAccessiblePagesResponse?> ordersAccesibleAddPagesAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, ordersAccessibleAddPagesUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return ordersAccessiblePagesResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<orderPendingTasksListResponse?> orderPendingTasksListAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, ordersPendingTasksListUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return orderPendingTasksListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<orderDashboardResponse?> ordersDashboardAPI(
    empId,
    session,
    mode,
    from,
    to,
    teamemployee,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
        'from': (from).toString(),
        'to': (to).toString(),
        'teamemployee': (teamemployee).toString(),
      };
      final res = await post(data, ordersDashboardUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return orderDashboardResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<AddOrderViewResponse?> addOrderViewAPI(
      empId,
      session,
      mode,
      leadId,
      feedback,
      followupType,
      inTime,
      loc

  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
        'lead_id': (leadId).toString(),
        'feedback': (feedback).toString(),
        'followup_type': (followupType).toString(),
        'in_time': (inTime).toString(),
        'loc': (loc).toString(),
      };
      debugPrint("===========================Input to api ");
      debugPrint("Lead Id: ${leadId}");
      debugPrint("Follow Type: ${followupType}");
      debugPrint("In Time: ${inTime}");
      debugPrint("Location: ${loc}");
      debugPrint("Mode: ${mode}");
      debugPrint("feedback: ${feedback}");

      debugPrint("=================End of INput=================");


      final res = await post(data, ordersAddOrderViewUrl, {});
      if (res != null) {
        // debugPrint("Response start ================== ${AddOrderViewResponse.fromJson(jsonDecode(res.body)).accountDetails?.name}");
        return AddOrderViewResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<addOrderAccontDetailsResponse?> addOrderAccountDetailsAPI(
    empId,
    session,
    accountId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'account_id': (accountId).toString(),
      };
      final res = await post(data, ordersAddOrderAccountDetailsUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return addOrderAccontDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<addOrderTpcAgentListResponse?> addOrderTPCAgentListAPI(
    empId,
    session,
    mode,
    text,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': mode.toString(),
        'text': (text).toString(),
      };
      final res = await post(data, ordersAddOrderTpcAgentListUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return addOrderTpcAgentListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> addOrderSubmitAPI(
    empId,
    session,
    mode,
    salesPersonEmpId,
    selectedAccId,
    dispatchStateId,
    dispatchDistrictId,
    dispatchSubLocationId,
    dispatchPincode,
    dispatchAddress,
    basicAmount,
    cgstAmount,
    sgstAmount,
    igstAmount,
    totalAmount,
    orderReceivedDate,
    note,
    unloading,
    freight,
    erection,
    tpcApplicable,
    billingName,
    billingGstNo,
    billingPincode,
    billingAddress,
    billingState,
    billingDistrict,
    billingSubLocality,
    orderProducts,
    leadId,
    feedback,
    inTime,
    loc,
    requestedTpcAmount,
    tpcAgentId,
    po,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': empId.toString(),
        'session_id': session.toString(),
        'mode': mode.toString(),
        'sales_person_emp_id': salesPersonEmpId.toString(),
        'selected_acc_id': selectedAccId.toString(),
        'dispatch_state_id': dispatchStateId.toString(),
        'dispatch_district_id': dispatchDistrictId.toString(),
        'dispatch_sub_location_id': dispatchSubLocationId.toString(),
        'dispatch_pincode': dispatchPincode.toString(),
        'dispatch_address': dispatchAddress.toString(),
        'basic_amount': basicAmount.toString(),
        'cgst_amount': cgstAmount.toString(),
        'sgst_amount': sgstAmount.toString(),
        'igst_amount': igstAmount.toString(),
        'total_amount': totalAmount.toString(),
        'order_received_date': orderReceivedDate.toString(),
        'note': note.toString(),
        'unloading': unloading.toString(),
        'freight': freight.toString(),
        'erection': erection.toString(),
        'tpc_applicable': tpcApplicable.toString(),
        'billing_name': billingName.toString(),
        'billing_gst_no': billingGstNo.toString(),
        'billing_pincode': billingPincode.toString(),
        'billing_address': billingAddress.toString(),
        'billing_state': billingState.toString(),
        'billing_district': billingDistrict.toString(),
        'billing_sub_locality': billingSubLocality.toString(),
        'order_products': (orderProducts).toString(),
        'lead_id': leadId.toString(),
        'feedback': feedback.toString(),
        'in_time': inTime.toString(),
        'loc': loc.toString(),
        'requested_tpc_amount': requestedTpcAmount.toString(),
        'tpc_agent_id': tpcAgentId.toString(),
      };
      var res;
      print("add order:$data");
      if (po != null) {
        res = await postImageNew(data, {}, ordersAddOrderSubmitUrl, po, "po");
        res = jsonDecode(res);
      } else {
        res = await post(data, ordersAddOrderSubmitUrl, {});
        res = jsonDecode(res.body);
      }
      return CommonResponse.fromJson(res);
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<ordersListByModeFilterResponse?> ordersListByModeFilterAPI(
    empId,
    session,
    mode,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
      };
      final res = await post(data, ordersOrderListByModeUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return ordersListByModeFilterResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<ordersListByModeResponse?> ordersListByModeAPI(
    empId,
    session,
    mode,
    teamemployee,
    status,
    pageNumber,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
        'teamemployee': (teamemployee).toString(),
        'status': (status).toString(),
        'page_number': (pageNumber).toString(),
      };
      final res = await post(data, ordersOrderListFilterUrl, {});
      if (res != null) {
        print("mode: $data");
        debugPrint(res.body);
        return ordersListByModeResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<ordersDetailsByModeResponse?> ordersDetailsByModeAPI(
    empId,
    session,
    orderId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'order_id': (orderId).toString(),
      };
      final res = await post(data, ordersOrderDetailsUrl, {});
      if (res != null) {
        print("Order Details $data");
        print("Order Details ${res.body}");
        return ordersDetailsByModeResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> ordersDetailsFeedbackSubmissionAPI(
    empId,
    session,
    orderId,
    feedback,
    status,
    attachmentFile,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'order_id': orderId.toString(),
        'feedback': (feedback).toString(),
        'status': status,
      };
      var res;
      if (attachmentFile != null) {
        res = await postImageNew(
          data,
          {},
          ordersOrderDetailsFeedbackSubmitUrl,
          attachmentFile,
          "attachment_file",
        );
        res = jsonDecode(res);
      } else {
        res = await post(data, ordersOrderDetailsFeedbackSubmitUrl, {});
        res = jsonDecode(res.body);
      }
      return CommonResponse.fromJson(res);
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<ordersDetailsEditOrderViewResponse?>
  ordersDetailsEditOrderViewAPI(empId, session, orderId) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'order_id': orderId.toString(),
      };

      var res = await post(data, ordersOrderDetailsEditOrderUrl, {});
      if (res != null) {
        return ordersDetailsEditOrderViewResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
    return null;
  }

  static Future<CommonResponse?> ordersDetailsEditOrderSubmitAPI(
    empId,
    session,
    orderId,
    attachmentFile,
    dispatchStateId,
    district,
    subLocality,
    dispatchPincode,
    dispatchAddress,
    unloading,
    freight,
    erection,
    note,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': empId.toString(),
        'session_id': session.toString(),
        'order_id': orderId.toString(),
        'dispatch_state_id': dispatchStateId.toString(),
        'district': district.toString(),
        'sub_locality': subLocality.toString(),
        'dispatch_pincode': dispatchPincode.toString(),
        'dispatch_address': dispatchAddress.toString(),
        'unloading': unloading.toString(),
        'freight': freight.toString(),
        'erection': erection.toString(),
        'note': note.toString(),
      };
      var res;
      print("Edit Order:$data");
      if (attachmentFile != null) {
        res = await postImageNew(
          data,
          {},
          ordersOrderDetailsEditOrderSubmitUrl,
          attachmentFile,
          "attachment_file",
        );
        res = jsonDecode(res);
      } else {
        res = await post(data, ordersOrderDetailsEditOrderSubmitUrl, {});
        res = jsonDecode(res.body);
      }
      return CommonResponse.fromJson(res);
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<ordersDetailsDispatchOrderViewResponse?>
  ordersDetailsDispatchOrderViewAPI(empId, session, orderId) async {
    try {
      Map<String, String> data = {
        'emp_id': empId.toString(),
        'session_id': session.toString(),
        'order_id': orderId.toString(),
      };

      final res = await post(data, ordersOrderDetailsDispatchProductsUrl, {});
      if (res != null) {
        return ordersDetailsDispatchOrderViewResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
    return null;
  }

  static Future<ordersPdiIdByEngNumberResponse?> ordersPdiIdByEngNumberUrlAPI(
    empId,
    session,
    engineNumber,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': empId.toString(),
        'session_id': session.toString(),
        'engine_number': engineNumber.toString(),
      };

      final res = await post(data, ordersPdiIdByEngNumberUrl, {});
      if (res != null) {
        return ordersPdiIdByEngNumberResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
    return null;
  }

  static Future<CommonResponse?> ordersDetailsApproveRejectAPI(
    empId,
    session,
    status,
    type,
    orderId,
    feedback,
    tpcApplicable,
    tpcApprovedAmount,
    saleOrderNumber,
    editCompanyName,
    invoiceNumber,
    vehicleNumber,
    driverName,
    driverMobileNo,
    crmOrderPId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        "status": status.toString(),
        "type": type.toString(),
        "order_id": orderId.toString(),
        "feedback": feedback.toString(),
        "tpc_applicable": tpcApplicable.toString(),
        "tpc_approved_amount": tpcApprovedAmount.toString(),
        "sale_order_number": saleOrderNumber.toString(),
        "edit_company_name": editCompanyName.toString(),
        "invoice_number": invoiceNumber.toString(),
        "vehicle_number": vehicleNumber.toString(),
        "driver_name": driverName.toString(),
        "driver_mobile_no": driverMobileNo.toString(),
        "crm_order_p_id": crmOrderPId.toString(),
      };
      final res = await post(data, ordersOrderApproveRejectUrl, {});
      if (res != null) {
        print("DATATATATA:: $data");
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> ordersDetailsDeleteAPI(
    empId,
    session,
    orderId,
    feedback,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        "order_id": orderId.toString(),
        "feedback": feedback.toString(),
      };
      final res = await post(data, ordersOrderLDeleteUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<addOrderPaymentViewResponse?> addOrderpaymentListViewAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, ordersAddPaymentViewUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return addOrderPaymentViewResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> addOrderpaymentListSubmitAPI(
    empId,
    session,
    accountId,
    description,
    selectedOrders,
    paymentAmount,
    paymentDate,
    paymentType,
    refNo,
    attachment,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'account_id': accountId.toString(),
        'description': description.toString(),
        'selected_orders': jsonEncode(selectedOrders).toString(),
        'payment_amount': paymentAmount.toString(),
        'payment_date': paymentDate.toString(),
        'payment_type': paymentType.toString(),
        'ref_no': refNo.toString(),
      };
      var res;
      print("Add Payment: $data");
      if (attachment != null) {
        res = await postImageNew(
          data,
          {},
          ordersAddPaymentSubmitUrl,
          attachment,
          "attachment",
        );
        res = jsonDecode(res);
      } else {
        res = await post(data, ordersAddPaymentSubmitUrl, {});
        res = jsonDecode(res.body);
        // return CommonResponse.fromJson(res);
      }
      return CommonResponse.fromJson(res);
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> ordersEditPaymentDetailsAPI(
    empId,
    session,
    paymentId,
    description,
    paymentType,
    refNo,
    paymentDate,
    amount,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'payment_id': paymentId.toString(),
        'description': description.toString(),
        'payment_type': paymentType.toString(),
        'payment_date': paymentDate.toString(),
        'ref_no': refNo.toString(),
        'amount': amount.toString(),
      };

      var res = await post(data, ordersEditPaymentDetailsUrl, {});
      if (res != null) {
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
    return null;
  }

  static Future<EditPaymentDetailsAdjustedOrdersViewResponse?>
  ordersEditPaymentDetailsAdjustedOrdersViewAPI(
    empId,
    session,
    paymentId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'payment_id': paymentId.toString(),
      };

      var res = await post(
        data,
        ordersEditPaymentDetailsAdjustedOrdersViewUrl,
        {},
      );
      if (res != null) {
        print("edit adjusted : ${res.body}");
        return EditPaymentDetailsAdjustedOrdersViewResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
    return null;
  }

  static Future<EditPaymentDetailsAdjustedOrdersViewResponse?>
  ordersEditPaymentDetailsAdjustedOrdersUpdateAPI(
    empId,
    session,
    paymentId,
    updateAmounts,
    insertAmounts,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'payment_id': paymentId.toString(),
        'update_amounts': jsonEncode(updateAmounts).toString(),
        'insert_amounts': jsonEncode(insertAmounts).toString(),
      };

      var res = await post(data, ordersEditPaymentDetailsAdjustedOrdersUrl, {});
      if (res != null) {
        return EditPaymentDetailsAdjustedOrdersViewResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
    return null;
  }

  static Future<AddOrderPaymentSelectAccountResponse?>
  AddOrderPaymentSelectAccountAPI(empId, session, mode, searchTerm) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': mode.toString(),
        'search_term': searchTerm.toString(),
      };
      final res = await post(
        data,
        ordersAddPaymentSelectAccountForOrderUrl,
        {},
      );
      if (res != null) {
        print(data);
        print("PaymentSeralectAccount${res.body}");
        return AddOrderPaymentSelectAccountResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<AddOrderPaymentSelectOrderResponse?>
  AddOrderPaymentSelectOrderAPI(empId, session, accountId) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'account_id': accountId.toString(),
      };
      final res = await post(data, ordersAddPaymentSelectOrderUrl, {});
      if (res != null) {
        print(data);
        debugPrint("add order payment selected order: ${res.body}");
        return AddOrderPaymentSelectOrderResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<paymentListByModeFilterResponse?> paymentListByModeFilterAPI(
    empId,
    session,
    mode,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
      };
      final res = await post(data, ordersPaymentListFilterUrl, {});
      if (res != null) {
        debugPrint(res.body);
        return paymentListByModeFilterResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<paymentListByModeResponse?> paymentListsByModeAPI(
    empId,
    session,
    mode,
    teamemployee,
    pageNumber,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
        'teamemployee': (teamemployee).toString(),
        'page_number': (pageNumber).toString(),
      };
      final res = await post(data, ordersPaymentListByModeUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return paymentListByModeResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> paymentOrderApproveRejectAPI(
    empId,
    session,
    paymentId,
    type,
    remarks,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        "payment_id": paymentId.toString(),
        "type": type.toString(),
        "remarks": remarks.toString(),
      };
      final res = await post(data, ordersPaymentListApproveRejectUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> verifyOrderAPI(
    empId,
    session,
    orderId,
    otp,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        "order_id": orderId.toString(),
        "otp": otp.toString(),
      };
      final res = await post(data, ordersVerifyOtpUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> resendOTPOrderAPI(
    empId,
    session,
    orderId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        "order_id": orderId.toString(),
      };
      final res = await post(data, ordersResendOtpUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> paymentOrderDeleteAPI(
    empId,
    session,
    paymentId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        "payment_id": paymentId.toString(),
      };
      final res = await post(data, ordersPaymentListDeleteUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<paymentDetailsByModeFilterResponse?> paymentsDetailsByModeAPI(
    empId,
    session,
    paymentId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'payment_id': (paymentId).toString(),
      };
      final res = await post(data, ordersPaymentDetailsUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return paymentDetailsByModeFilterResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> paymentsDetailsAddAdjustedOrderAPI(
    empId,
    session,
    paymentId,
    selectedOrderId,
    amount,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'payment_id': (paymentId).toString(),
        'selected_order_id': (selectedOrderId).toString(),
        'amount': (amount).toString(),
      };
      final res = await post(data, ordersPaymentDetailsAddOrderUrl, {});
      if (res != null) {
        print("paymentsDetailsAddAdjusted: $data");
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> paymentsDetailsEditAdjustedOrderAPI(
    empId,
    session,
    selectedOrderId,
    amount,
    orderPaymentId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'selected_order_id': (selectedOrderId).toString(),
        'amount': (amount).toString(),
        'order_payment_id': (orderPaymentId).toString(),
      };
      final res = await post(data, ordersPaymentDetailsEditOrderUrl, {});
      if (res != null) {
        print("paymentsDetailsEditAdjusted $data");
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> ordersAddTPCAgentAPI(
    empId,
    session,
    agentName,
    mobileNumber,
    bankName,
    bankAccountNo,
    bankIfscCode,
    bankBeneficiaryName,
    note,
    idProof,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'agent_name': agentName.toString(),
        'mobile_number': mobileNumber.toString(),
        'bank_name': bankName.toString(),
        'bank_account_no': bankAccountNo.toString(),
        'bank_ifsc_code': bankIfscCode.toString(),
        'bank_beneficiary_name': bankBeneficiaryName.toString(),
        'note': note.toString(),
      };
      var res;
      print("add TPC: $data");
      if (idProof != null) {
        res = await postImageNew(
          data,
          {},
          ordersAddTPCAgentUrl,
          idProof,
          "id_proof",
        );
        res = jsonDecode(res);
      } else {
        res = await post(data, ordersAddTPCAgentUrl, {});
        res = jsonDecode(res.body);
        // return CommonResponse.fromJson(res);
      }
      print("Add TPC: $res");
      return CommonResponse.fromJson(res);
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<TPCListResponse?> TPCAgentListAPI(
    empId,
    session,
    mode,
    pageNumber,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
        'page_number': (pageNumber).toString(),
      };
      final res = await post(data, ordersTPCAgentListUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return TPCListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<TPCAgentDetailsResponse?> TPCAgentDetailsAPI(
    empId,
    session,
    tpcAgentId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'tpc_agent_id': (tpcAgentId).toString(),
      };
      final res = await post(data, ordersTPCAgentDetailsUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return TPCAgentDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<PendingTPCAgentListResponse?> pendingTPCAgentIssueListAPI(
    empId,
    session,
    pageNumber,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'page_number': (pageNumber).toString(),
      };
      final res = await post(data, ordersPendingTPCIssueListUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return PendingTPCAgentListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> TpcIssueListApprovalAPI(
    empId,
    session,
    tpcPaymentMode,
    tpcPaymentReferenceNo,
    orderId,
    orderTpcFeedback,
    tpcPaymAttachment,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'tpc_payment_mode': tpcPaymentMode.toString(),
        'tpc_payment_reference_no': tpcPaymentReferenceNo.toString(),
        'order_id': orderId.toString(),
        'order_tpc_feedback': orderTpcFeedback.toString(),
      };
      var res;
      if (tpcPaymAttachment != null) {
        res = await postImageNew(
          data,
          {},
          ordersApprovePendingTPCIssueListUrl,
          tpcPaymAttachment,
          "tpc_paym_attachment",
        );
        res = jsonDecode(res);
      } else {
        res = await post(data, ordersApprovePendingTPCIssueListUrl, {});
        res = jsonDecode(res.body);
        // return CommonResponse.fromJson(res);
      }
      return CommonResponse.fromJson(res);
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  ///CRM Module
  static Future<AccessiblePagesResponse?> crmAccessiblePagesAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, crmAccessiblePagesUrl, {});
      if (res != null) {
        print(data);
        debugPrint("Accessibl pages: ${res.body}");
        return AccessiblePagesResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmNewLeadsProspectsViewResponse?> crmNewLeadsProspectsViewAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, crmNewProspectLeadViewUrl, {});
      if (res != null) {
        print(data);
        debugPrint("New Leads prospecrs ${res.body}");
        return crmNewLeadsProspectsViewResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmNewLeadsProspectsSubmitResponse?>
  crmNewLeadsProspectsSubmitAPI(
    sessionId,
    empId,
    mode,
    accManagerId,
    salutationName,
    name,
    contactName,
    district,
    state,
    address,
    segment,
    source,
    reference,
    team,
    subLocality,
    mob1,
    mob2,
    tel,
    email,
    designation,
    leadStatus,
    products,
  ) async {
    try {
      Map<String, String> data = {
        'session_id': sessionId.toString(),
        'emp_id': empId.toString(),
        'mode': mode.toString(),
        'acc_manager_id': accManagerId.toString(),
        'salutation_name': salutationName.toString(),
        'name': name.toString(),
        'contact_name': contactName.toString(),
        'district': district.toString(),
        'state': state.toString(),
        'address': address.toString(),
        'segment': segment.toString(),
        'source': source.toString(),
        'reference': reference.toString(),
        'team': team.toString(),
        'sub_locality': subLocality.toString(),
        'mob1': mob1.toString(),
        'mob2': mob2.toString(),
        'tel': tel.toString(),
        'email': email.toString(),
        'designation': designation.toString(),
        'lead_status': leadStatus.toString(),
        'products': products.toString(),
      };
      debugPrint("✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅✅ Product deteails ${products}");
      final res = await post(data, crmNewProspectLeadSubmitUrl, {});
      if (res != null) {
        print(data);
        debugPrint("Submit New Leads ${res.body}");

        return crmNewLeadsProspectsSubmitResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmDashboardResponse?> crmDashboardAPI(
    empId,
    session,
    empLoc,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'emp_loc': empLoc.toString(),
      };
      final res = await post(data, crmDashboardUrl, {});
      if (res != null) {
        print(data);
        print("CRM Dash ${jsonDecode(res.body)}");
        return crmDashboardResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmPendingTasksResponse?> crmPendingTasksAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, crmPendingTasksListUrl, {});
      if (res != null) {
        print(data);
        debugPrint("PEnding Tasks ${res.body}");
        return crmPendingTasksResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmUniversalSearchResponse?> crmUniversalSearchAPI(
    empId,
    session,
    q,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'q': (q).toString(),
      };
      final res = await post(data, crmUnivesalSearchUrl, {});
      if (res != null) {
        print(data);
        debugPrint("Universal Search ${res.body}");
        return crmUniversalSearchResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<LeadListViewResponse?> crmLeadListViewAPI(
    empId,
    session,
    mode,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
      };
      final res = await post(data, crmLeadListViewUrl, {});
      if (res != null) {
        print(data);
        debugPrint("Lead ListView2: ${res.body}");
        return LeadListViewResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<SubmitLeadListFilterResponse?> crmLeadListFilterSubmitAPI(
    empId,
    session,
    mode,
    status,
    openStatus,
    mob,
    com,
    source,
    reference,
    team,
    segment,
    alphabet,
    pageNumber,
  ) async {
    debugPrint('#########crmLeadListFilterSubmitAPI Input data:');
    debugPrint('empId: $empId');
    debugPrint('session: $session');
    debugPrint('mode: $mode');
    debugPrint('status: $status');
    debugPrint('openStatus: $openStatus');
    debugPrint('mob: $mob');
    debugPrint('com: $com');
    debugPrint('source: $source');
    debugPrint('reference: $reference');
    debugPrint('team: $team');
    debugPrint('segment: $segment');
    debugPrint('alphabet: $alphabet');
    debugPrint('pageNumber: $pageNumber');
    debugPrint('End of input data');
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
        'status': status.toString(),
        'open_status': openStatus.toString(),
        'mob': mob.toString(),
        'com': com.toString(),
        'source': source.toString(),
        'reference': reference.toString(),
        'team': team.toString(),
        'segment': segment.toString(),
        'alphabet': alphabet.toString(),
        'page_number': pageNumber.toString(),
      };
      final res = await post(data, crmLeadListFilterSubmitUrl, {});
      if (res != null) {
        print("Lead Filter:$data");
        debugPrint(" Lead list data :${res.body}");
        return SubmitLeadListFilterResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<GetSourceOnReferenceResponse?> crmLeadListSourceOnReferenceAPI(
    empId,
    session,
    sourceId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'source_id': (sourceId).toString(),
      };
      final res = await post(data, crmLeadListSourceOnReferenceUrl, {});
      if (res != null) {
        print(data);
        debugPrint("Source on Ref ${res.body}");
        return GetSourceOnReferenceResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<GetSegmentOnTeamResponse?> crmLeadListSegmentOnTeamAPI(
    empId,
    session,
    teamId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'team_id': (teamId).toString(),
      };
      final res = await post(data, crmLeadListSegmentOnTeamUrl, {});
      if (res != null) {
        print(data);
        print("Segemnt on team ${res.body}");
        return GetSegmentOnTeamResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<GetDistrictOnStateResponse?> crmDistrictsOnStateAPI(
    empId,
    session,
    stateId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'state_id': (stateId).toString(),
      };
      final res = await post(data, crmLeadListDistrictOnStateUrl, {});
      if (res != null) {
        print(data);
        debugPrint("districts on State ${res.body}");
        return GetDistrictOnStateResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<GetSubLocOnDistrictResponse?> crmSubLocOnDistrictAPI(
    empId,
    session,
    districtId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'district_id': (districtId).toString(),
      };
      final res = await post(data, crmLeadListSubLocOnDistrictUrl, {});
      if (res != null) {
        print(data);
        debugPrint("Sub loc on Dist ${res.body}");
        return GetSubLocOnDistrictResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<LeadListContactPopUpResponse?> crmLeadListContactPopUpAPI(
    empId,
    session,
    accountId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'account_id': (accountId).toString(),
      };
      final res = await post(data, crmLeadListContactPopUpUrl, {});
      if (res != null) {
        print(data);
        debugPrint("Lead list contact ${res.body}");
        return LeadListContactPopUpResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<LeadDetailsResponse?> crmLeadDetailsAPI(
    empId,
    session,
    leadId,
    mode,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'lead_id': (leadId).toString(),
        'mode': (mode).toString(),
      };
      final res = await post(data, crmLeadDetailsUrl, {});
      if (res != null) {
        print(data);
        debugPrint("Lead Deatails ${res.body}");
        return LeadDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> crmLeadDetailsAddEditProductsAPI(
    empId,
    session,
    leadId,
    type,
    leadProductId,
    productId,
    qty,
    amount,
      remark,
  ) async {
    try {
      debugPrint("💡💡💡💡💡💡💡💡💡AddEditProducts: ${remark}");
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'lead_id': (leadId).toString(),
        'type': (type).toString(),
        'lead_product_id': (leadProductId).toString(),
        'product_id': (productId).toString(),
        'qty': (qty).toString(),
        'amount': (amount).toString(),
        'remarks': (remark).toString(),
      };

      final res = await post(data, crmLeadDetailsAddEditProductsUrl, {});
      if (res != null) {
        print("AddEditProducts $data");
        debugPrint("AddEditProducts: ${res.body}");
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmAddFollowUpResponse?> crmLeadDetailsAddFollowUpAPI(
    sessionId,
    empId,
    nextapp,
    orderstatus,
    leadId,
    followupFeedback,
    followupType,
    followupintime,
    loc,
    competitor,
    reason,
    followupStatus,
    nextAppointmentDate,
    appointmentType,
    sms,
    appNote,
  ) async {
    try {
      Map<String, String> data = {
        'session_id': sessionId.toString(),
        'emp_id': empId.toString(),
        'nextapp': nextapp.toString(),
        'orderstatus': orderstatus.toString(),
        'lead_id': leadId.toString(),
        'followup_feedback': followupFeedback.toString(),
        'followup_type': followupType.toString(),
        'followupintime': followupintime.toString(),
        'loc': loc.toString(),
        'competitor': competitor.toString(),
        'reason': reason.toString(),
        'followup_status': followupStatus.toString(),
        'next_appointment_date': nextAppointmentDate.toString(),
        'appointment_type': appointmentType.toString(),
        'sms': sms.toString(),
        'app_note': appNote.toString(),
      };

      final res = await post(data, crmLeadDetailsAddFollowUpUrl, {});
      if (res != null) {
        print("crmAddFollowUp: $data");
        debugPrint("crmAddFollowUp: ${res.body}");
        return crmAddFollowUpResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmLeadDetailsEditAccountViewResponse?>
  crmLeadDetailsEditAccountViewAPI(empId, session, leadId, mode) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'lead_id': (leadId).toString(),
        'mode': (mode).toString(),
      };
      final res = await post(data, crmLeadDetailsEditAccountViewUrl, {});
      if (res != null) {
        print(data);
        debugPrint("crmLeadDetailsEditAccountViewAPI: ${res.body}");
        return crmLeadDetailsEditAccountViewResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> crmLeadDetailsEditAccountSubmitAPI(
    empId,
    session,
    accountId,
    segmentId,
    teamId,
    accountName,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'account_id': (accountId).toString(),
        'segment_id': (segmentId).toString(),
        'team_id': (teamId).toString(),
        'account_name': (accountName).toString(),
      };
      final res = await post(data, crmLeadDetailsEditAccountUrl, {});
      if (res != null) {
        print(data);
        debugPrint("crmLeadDetailsEditAccountSubmitAPI ${res.body}");
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmLeadDetailsEditProductsViewResponse?>
  crmLeadDetailsEditProductsViewAPI(empId, session, leadId) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'lead_id': (leadId).toString(),
      };
      final res = await post(data, crmLeadDetailsEditProductsViewUrl, {});
      if (res != null) {
        print(data);
        print(
          "crmLeadDetailsEditProductsViewAPI: ${jsonDecode(res.body)['lead_products']}",
        );
        debugPrint(res.body);
        return crmLeadDetailsEditProductsViewResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> crmLeadDetailsEditProductsSubmitAPI(
    empId,
    session,
    products,
    leadId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'products': jsonEncode(products).toString(),
        'lead_id': (leadId).toString(),
      };
      final res = await post(data, crmLeadDetailsEditProductsUrl, {});
      if (res != null) {
        print(data);
        print("crmLeadDetailsEditProductsSubmitAPI: ${jsonDecode(res.body)}");
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> crmLeadDetailsAddContactAPI(
    empId,
    session,
    accId,
    name,
    mob1,
    designation,
    mob2,
    tel,
    email,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'acc_id': (accId).toString(),
        'name': (name).toString(),
        'mob1': (mob1).toString(),
        'designation': (designation).toString(),
        'mob2': (mob2).toString(),
        'tel': (tel).toString(),
        'email': (email).toString(),
      };
      final res = await post(data, crmLeadDetailsAddContactUrl, {});
      if (res != null) {
        print(data);
        debugPrint("crmLeadDetailsAddContactAPI${res.body}");
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> crmLeadDetailsEditContactAPI(
    empId,
    session,
    contactId,
    name,
    mob1,
    designation,
    mob2,
    tel,
    email,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'contact_id': (contactId).toString(),
        'name': (name).toString(),
        'mob1': (mob1).toString(),
        'designation': (designation).toString(),
        'mob2': (mob2).toString(),
        'tel': (tel).toString(),
        'email': (email).toString(),
      };
      final res = await post(data, crmLeadDetailsEditContactUrl, {});
      if (res != null) {
        print(data);
        debugPrint("crmLeadDetailsEditContactAPI ${res.body}");
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> crmLeadDetailsAddAppointmentAPI(
    empId,
    session,
    leadId,
    appointmentDate,
    type,
    note,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'lead_id': (leadId).toString(),
        'appointment_date': (appointmentDate).toString(),
        'type': (type).toString(),
        'note': (note).toString(),
      };
      final res = await post(data, crmLeadDetailsAddAppointmentUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmLeadDetailsGenerateQuotationViewResponse?>
  crmLeadDetailsGenerateQuotationViewAPI(empId, session, leadId) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'lead_id': (leadId).toString(),
      };
      final res = await post(data, crmLeadDetailsGenerateQuotationViewUrl, {});
      if (res != null) {
        print(data);
        debugPrint("ListView1: ${res.body}");
        return crmLeadDetailsGenerateQuotationViewResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmLeadDetailsGenerateQuotationSubmitResponse?>
  crmLeadDetailsGenerateQuotationSubmitAPI(
    empId,
    sessionId,
    leadId,
    quotemno,
    quotesubject,
    taxes,
    quotenote,
    quotefor,
    quotepTerms,
    quotemail,
    quoteProducts,
    quotationType,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': empId.toString(),
        'session_id': sessionId.toString(),
        'lead_id': leadId.toString(),
        'quotemno': quotemno.toString(),
        'quotesubject': quotesubject.toString(),
        'taxes': taxes.toString(),
        'quotenote': quotenote.toString(),
        'quotefor': quotefor.toString(),
        'quotep_terms': quotepTerms.toString(),
        'quotemail': quotemail.toString(),
        'quote_products': jsonEncode(quoteProducts).toString(),
        'quotation_type': quotationType.toString(),
      };
      final res = await post(
        data,
        crmLeadDetailsGenerateQuotationSubmitUrl,
        {},
      );
      if (res != null) {
        print("Filter: $data");
        debugPrint(res.body);
        return crmLeadDetailsGenerateQuotationSubmitResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmDownloadGenQuoteResponse?> crmDownloadGenQuoteAPI(
    empId,
    sessionId,
    leadId,
    quoteId,
    quotationType,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': empId.toString(),
        'session_id': sessionId.toString(),
        'lead_id': leadId.toString(),
        'quote_id': quoteId.toString(),
        'quotation_type': quotationType.toString(),
      };
      final res = await post(data, crmDownloadGeneratedQuotationUrl, {});
      if (res != null) {
        print("Filter: $data");
        debugPrint(res.body);
        return crmDownloadGenQuoteResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<ProspectListViewResponse?> crmProspectListViewAPI(
    empId,
    session,
    mode,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
      };
      final res = await post(data, crmProspectListViewUrl, {});
      if (res != null) {
        print(data);
        debugPrint("ListView3: ${res.body}");
        return ProspectListViewResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<SubmitProspectListFilterResponse?>
  crmProspectListFilterSubmitAPI(
    empId,
    session,
    mode,
    teamemployee,
    mob,
    companyName,
    pageNumber,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
        'teamemployee': teamemployee.toString(),
        'mob': mob.toString(),
        'company_name': companyName.toString(),
        'page_number': pageNumber.toString(),
      };
      final res = await post(data, crmProspectListFilterSubmitUrl, {});
      if (res != null) {
        print("Filter:$data");
        debugPrint(res.body);
        return SubmitProspectListFilterResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmProspectDetailsResponse?> crmProspectDetailsAPI(
    empId,
    session,
    accountId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'account_id': (accountId).toString(),
      };
      final res = await post(data, crmProspectDetailsUrl, {});
      if (res != null) {
        print("Filter:$data");
        debugPrint(res.body);
        return crmProspectDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> crmProspectDetailsTransferAccountAPI(
    empId,
    session,
    accountId,
    tranempId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'account_id': (accountId).toString(),
        'tranemp_id': (tranempId).toString(),
      };
      final res = await post(data, crmProspectDetailsTransferAccountUrl, {});
      if (res != null) {
        print("Filter:$data");
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmProspectDetailsEditAccountViewResponse?>
  crmProspectDetailsEditAccountViewAPI(empId, session, accountId) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'account_id': (accountId).toString(),
      };
      final res = await post(data, crmProspectDetailsEditAccountViewUrl, {});
      if (res != null) {
        print("Filter:$data");
        print("Stetets:${jsonDecode(res.body)['states']}");
        return crmProspectDetailsEditAccountViewResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> crmProspectDetailsEditAccountSubmitAPI(
    empId,
    session,
    accountId,
    editCompanyName,
    editSalutationName,
    stateId,
    district,
    subLocality,
    pincode,
    address,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'account_id': (accountId).toString(),
        'edit_company_name': editCompanyName.toString(),
        'edit_salutation_name': editSalutationName.toString(),
        'state_id': stateId.toString(),
        'district': district.toString(),
        'sub_locality': subLocality.toString(),
        'pincode': pincode.toString(),
        'address': address.toString(),
      };
      final res = await post(data, crmProspectDetailsEditAccountSubmitUrl, {});
      if (res != null) {
        print("Filter:$data");
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmProspectDetailsAddLeadsResponse?>
  crmProspectDetailsAddLeadViewAPI(empId, session, mode) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
      };
      final res = await post(data, crmProspectDetailsAddLeadViewUrl, {});
      if (res != null) {
        print("Filter:$data");
        debugPrint(res.body);
        return crmProspectDetailsAddLeadsResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> crmProspectDetailsAddLeadSubmitAPI(
    empId,
    session,
    mode,
    accountId,
    accManagerId,
    products,
    leadStatus,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode).toString(),
        'account_id': accountId.toString(),
        'acc_manager_id': accManagerId.toString(),
        'products': jsonEncode(products).toString(),
        'lead_status': leadStatus.toString(),
      };
      final res = await post(data, crmProspectDetailsAddLeadSubmitUrl, {});
      if (res != null) {
        print("Filter:$data");
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> crmProspectDetailsAddLeadAPI(
    empId,
    session,
    accountId,
    productId,
    quantity,
    amount,
    leadStatus,
      remarks,
  ) async {
    try {
      debugPrint("💡💡💡💡💡💡 remarks $remarks");
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'account_id': accountId.toString(),
        'product_id': productId.toString(),
        'quantity': quantity.toString(),
        'amount': amount.toString(),
        'lead_status': leadStatus.toString(),
        'remarks' : remarks.toString(),
      };
      final res = await post(data, crmProspectDetailsAddLeadUrl, {});
      if (res != null) {
        print("crmProspectDetailsAddLead:$data");
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> crmProspectDetailsAddAccountAPI(
    empId,
    session,
    name,
    accId,
    mob1,
    designation,
    email,
    tel,
    mob2,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'name': name.toString(),
        'acc_id': accId.toString(),
        'mob1': mob1.toString(),
        'designation': designation.toString(),
        'email': email.toString(),
        'tel': tel.toString(),
        'mob2': mob2.toString(),
      };
      final res = await post(data, crmProspectDetailsAddAccountUrl, {});
      if (res != null) {
        print("crmProspectDetailsAddAccountAPI:$data");
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> crmProspectDetailsEditContactAPI(
    empId,
    session,
    contactId,
    name,
    accId,
    mob1,
    mob2,
    tel,
    designation,
    email,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'contact_id': (contactId).toString(),
        'name': name.toString(),
        'acc_id': accId.toString(),
        'mob1': mob1.toString(),
        'mob2': mob2.toString(),
        'tel': tel.toString(),
        'designation': designation.toString(),
        'email': email.toString(),
      };
      final res = await post(data, crmProspectDetailsEditContactUrl, {});
      if (res != null) {
        print("Filter:$data");
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmProspectDetailsAddFollowUpAppointmentResponse?>
  crmProspectDetailsFollowupNextAppointmentAPI(
    empId,
    session,
    nextapp,
    orderstatus,
    leadId,
    followupFeedback,
    followupType,
    followupintime,
    loc,
    followupStatus,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'nextapp': nextapp.toString(),
        'orderstatus': orderstatus.toString(),
        'lead_id': leadId.toString(),
        'followup_feedback': followupFeedback.toString(),
        'followup_type': followupType.toString(),
        'followupintime': followupintime.toString(),
        'loc': loc.toString(),
        'followup_status': followupStatus.toString(),
      };
      final res = await post(
        data,
        crmProspectDetailsFollowupNextAppointmentUrl,
        {},
      );
      if (res != null) {
        print("Filter:$data");
        debugPrint(res.body);
        return crmProspectDetailsAddFollowUpAppointmentResponse.fromJson(
          jsonDecode(res.body),
        );
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<appointmentCalendarResponse?> crmAppointmentCalendarAPI(
    empId,
    session,
    appointmentDate,
    type,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'appointment_date': (appointmentDate).toString(),
        'type': (type).toString(),
      };
      final res = await post(data, crmAppointmentCalendarUrl, {});
      if (res != null) {
        print("appointmentCalendar: $data");
        debugPrint(res.body);
        return appointmentCalendarResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmSelectedProductDetailsResponse?>
  crmSelectedProductDetailsApi(empId, session, productId) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'product_id': (productId).toString(),
      };
      final res = await post(data, crmSelectedProductDetailsUrl, {});
      if (res != null) {
        print("crmSelectedProductDetailsApi: $data");
        debugPrint(res.body);
        return crmSelectedProductDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> crmCheckAccountFieldsApi(
    empId,
    session,
    typeValue,
    type,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'type_value': (typeValue).toString(),
        'type': (type).toString(),
      };
      final res = await post(data, crmCheckAccountFieldsUrl, {});
      if (res != null) {
        print("crmCheckAccountFieldsApi: $data");
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?>
  crmProspectDetailsFollowupNextAppointmentOtherCaseAPI(
    empId,
    session,
    nextapp,
    orderstatus,
    leadId,
    followupFeedback,
    followupType,
    followupintime,
    loc,
    followupStatus,
    appointmentset,
    appDate,
    sms,
    appNote,
    inT,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'nextapp': nextapp.toString(),
        'orderstatus': orderstatus.toString(),
        'lead_id': leadId.toString(),
        'followup_feedback': followupFeedback.toString(),
        'followup_type': followupType.toString(),
        'followupintime': followupintime.toString(),
        'loc': loc.toString(),
        'followup_status': followupStatus.toString(),
        'appointmentset': appointmentset.toString(),
        'app_date': appDate.toString(),
        'sms': sms.toString(),
        'app_note': appNote.toString(),
        'in_t': inT.toString(),
      };
      final res = await post(
        data,
        crmProspectDetailsFollowupNextAppointmentUrl,
        {},
      );
      if (res != null) {
        print("Filter:$data");
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<NearbyOpenLeadsResponse?> loadNearbyOpenLeadsAPI(
    empId,
    session,
    empLoc,
    radius,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'emp_loc': (empLoc).toString(),
        'radius': radius.toString(),
      };
      final res = await post(data, crmNearbyOpenLeadsUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return NearbyOpenLeadsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmDashboardFollowUpResponse?> crmDashboardFollowUpAPI(
    empId,
    session,
    type,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'type': (type).toString(),
      };
      final res = await post(data, crmDashboardFollowUpUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return crmDashboardFollowUpResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<crmDashboardQuotationResponse?> crmDashboardQuotationsAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, crmDashboardQuotationsUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return crmDashboardQuotationResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  ///hrm modules
  ///
  ///

  static Future<ogresponse?> ogChartAPI(empId, session) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, ogcharturl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return ogresponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<jobDescriptionResponse?> jobDescriptAPI(empId, session) async {
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
      };
      final res = await post(data, JobDesciptionUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return jobDescriptionResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<hrmAccessiblePagesResponse?> hrmAccessiblePagesAPI(
    empId,
    session,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
      };
      final res = await post(data, HrmAccessiblePagesUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return hrmAccessiblePagesResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<attendanceRequestListResponse?> attendanceRequestListAPI(
    empId,
    session,
    type,
    from,
    to,
    mode,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'mode': (mode),
        'type': (type),
        'from': (from),
        'to': (to),
      };
      final res = await post(data, AttendanceRequestListUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return attendanceRequestListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<attendanceRequestDetailsResponse?> attendanceRequestDetailAPI(
    empId,
    session,
    attendanceRequestId,
  ) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'attendance_request_id': (attendanceRequestId),
      };
      final res = await post(data, AttendanceRequestDetailsUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return attendanceRequestDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> attendanceRequestApproveRejectAPI(
    session,
    empId,
    mode,
    type,
    remarks,
    id,
  ) async {
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
        'mode': (mode).toString(),
        'type': (type).toString(),
        'remarks': (remarks).toString(),
        'id': (id).toString(),
      };
      final res = await post(data, AttendanceRequestRejectUrl, {});
      if (res != null) {
        print("Attendance App Reje:$data");
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> addAttendanceRequestAPI({
    required String sessionId,
    required String empId,
    required String process,
    required String type,
    required String loc,
    required String checkDate,
    String? checkInTime,
    String? checkInLoc,
    File? checkInProof,
    String? checkOutTime,
    String? checkOutLoc,
    File? checkOutProof,
    String? note,
  }) async {
    try {
      var request = http.MultipartRequest(
        'POST',
        Uri.parse(AddAttendanceRequestUrl),
      );

      // Add basic fields that are always required
      Map<String, String> fields = {
        "session_id": sessionId,
        "emp_id": empId,
        "process": process,
        "type": type,
        "loc": loc,
        "check_date": checkDate,
        "note": note ?? "",
      };

      // Conditionally add check-in fields based on type
      if (type == "Check In" || type == "Check In/Out") {
        fields["check_in_time"] = checkInTime ?? "";
        fields["check_in_loc"] = checkInLoc ?? "";

        if (checkInProof != null) {
          request.files.add(
            await http.MultipartFile.fromPath(
              "check_in_proof",
              checkInProof.path,
            ),
          );
        }
      }

      // Conditionally add check-out fields based on type
      if (type == "Check Out" || type == "Check In/Out") {
        fields["check_out_time"] = checkOutTime ?? "";
        fields["check_out_loc"] = checkOutLoc ?? "";

        if (checkOutProof != null) {
          request.files.add(
            await http.MultipartFile.fromPath(
              "check_out_proof",
              checkOutProof.path,
            ),
          );
        }
      }

      // Add all fields to the request
      request.fields.addAll(fields);

      // Log the actual fields being sent
      debugPrint("addAttendanceRequestAPI - Type: $type");
      debugPrint("addAttendanceRequestAPI - Fields: $fields");
      debugPrint(
        "addAttendanceRequestAPI - Files: ${request.files.map((f) => f.filename).toList()}",
      );

      var response = await request.send();
      var resBody = await response.stream.bytesToString();

      debugPrint("Server Response: $resBody");

      if (response.statusCode == 200) {
        return CommonResponse.fromJson(jsonDecode(resBody));
      } else {
        return null;
      }
    } catch (e) {
      debugPrint("API Error: $e");
      return null;
    }
  }

  //reward list
  static Future<rewardListResponse?> rewardListAPI(empId, session) async {
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
      };
      final res = await post(data, RewardListUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return rewardListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  //tour exp
  static Future<tourExpensesListResponse?> tourExpensesListAPI(
    empId,
    session,
    pageNumber,
  ) async {
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
        'page_number': (pageNumber),
      };
      final res = await post(data, TourExpensesListUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return tourExpensesListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<tourExpensesDetailsResponse?> tourExpensesDetailAPI(
    session,
    empId,
    tourBillId,
  ) async {
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
        'tour_bill_id': (tourBillId),
      };
      final res = await post(data, TourExpensesDetailsUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return tourExpensesDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<tourExpensesAddViewResponse?> tourExpensesAddViewAPI(
    empId,
    session,
    tourBillId,
  ) async {
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
        'tour_bill_id': (tourBillId),
      };
      final res = await post(data, TourExpensesAddViewUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return tourExpensesAddViewResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> addTourBillAPI({
    required String sessionId,
    required String empId,
    required String placeOfVisit,
    required String daAmount,
    required String tourType,
    required String tourDate,
    required List<Map<String, dynamic>> travelExpenses,
    required List<Map<String, dynamic>> hotelExpenses,
    required List<Map<String, dynamic>> otherExpenses,
    List<File>? travelImages,
    List<File>? hotelImages,
    List<File>? otherImages,
  }) async {
    try {
      var request = http.MultipartRequest(
        "POST",
        Uri.parse(AddTourExpensesUrl),
      );

      /// Add text fields
      request.fields['session_id'] = sessionId;
      request.fields['emp_id'] = empId;
      request.fields['place_of_visit'] = placeOfVisit;
      request.fields['da_amount'] = daAmount;
      request.fields['tour_type'] = tourType;
      request.fields['tour_date'] = tourDate;

      /// Convert expense lists to JSON string
      request.fields['travel_expenses'] = jsonEncode(travelExpenses);
      request.fields['hotel_expenses'] = jsonEncode(hotelExpenses);
      request.fields['other_expenses'] = jsonEncode(otherExpenses);

      /// Add hotel images
      if (hotelImages!.isNotEmpty) {
        for (var file in hotelImages) {
          if (file.path.isNotEmpty) {
            request.files.add(
              await http.MultipartFile.fromPath("hotel_image[]", file.path),
            );
          }
        }
      }

      /// Add travel images
      if (travelImages!.isNotEmpty) {
        for (var file in travelImages) {
          if (file.path.isNotEmpty) {
            request.files.add(
              await http.MultipartFile.fromPath("travel_image[]", file.path),
            );
          }
        }
      }

      /// Add other images
      if (otherImages!.isNotEmpty) {
        for (var file in otherImages) {
          if (file.path.isNotEmpty) {
            request.files.add(
              await http.MultipartFile.fromPath("other_image[]", file.path),
            );
          }
        }
      }

      /// Send request
      var response = await request.send();
      var resBody = await response.stream.bytesToString();

      debugPrint("Request Fields: ${request.fields}");
      debugPrint("Response: $resBody");

      if (response.statusCode == 200) {
        return CommonResponse.fromJson(jsonDecode(resBody));
      } else {
        debugPrint("Error: ${response.statusCode} - $resBody");
        return null;
      }
    } catch (e) {
      debugPrint("Error in addTourBillAPI: $e");
      return null;
    }
  }

  // Leave Application api
  // Leave Application api
  static Future<leaveApplicationLIstResponse?> leaveApplicationListAPI(
    session,
    empId,
    dateFrom,
    dateTo,
    mode,
  ) async {
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
        'requested_date_from': (dateFrom),
        'requested_date_to': (dateTo),
        'mode': (mode),
      };
      final res = await post(data, LeaveApplicationListUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return leaveApplicationLIstResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<leaveApplicationDetailsResponse?> leaveApplicationDetailAPI(
    session,
    empId,
    leaveRequestId,
  ) async {
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
        'leave_request_id': (leaveRequestId),
      };
      final res = await post(data, LeaveApplicationDetailsUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return leaveApplicationDetailsResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }
/// CasualLeaveHistory api
  static Future<CasualLeaveHistoryResponse?> casualLeaveHistoryAPI(
      session,
      empId,
      ) async {
    debugPrint("🔥🔥🔥🔥🔥🔥🔥Response");
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
      };
      final res = await post(data, CasuaLeaveHistoryUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return CasualLeaveHistoryResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  //add leave request
  static Future<CommonResponse?> leaveRequestAddAPI(
    session,
    empId,
    fromDate,
    fromTime,
    toDate,
    toTime,
    leaveType,
    reason,
  ) async {
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
        'from_date': (fromDate).toString(),
        'from_time': (fromTime).toString(),
        'to_date': (toDate).toString(),
        'to_time': (toTime).toString(),
        'leave_type': (leaveType).toString(),
        'reason': (reason).toString(),
      };
      final res = await post(data, LeaveRequestAdditionUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> leaveRequestRejectApproveAPI(
    session,
    empId,
    mode,
    type,
    remarks,
    id,
  ) async {
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
        'mode': (mode).toString(),
        'type': (type).toString(),
        'remarks': (remarks).toString(),
        'id': (id).toString(),
      };
      final res = await post(data, LeaveRequestRejectAprroveUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  /// AdvanceListApi
  static Future<AdvanceListResponse?> advanceListAPI(
      session,
      empId,
      pageNumber
      ) async {
    debugPrint("🔥🔥🔥🔥🔥🔥🔥Response");
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
        'page_number': (pageNumber).toString(), // FIX: Use pageNumber parameter, not empId
      };
      final res = await post(data, AdvanceListUrl, {});
      if (res != null) {
        print("Request Data: $data");
        debugPrint("🔥🔥🔥🔥🔥🔥🔥 Response: ${res.body}");
        return AdvanceListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('API Error: $e');
      return null;
    }
  }

 // Contact list
  static Future<ContactListResponse?> contactListAPI(
      session,
      empId,
      pageNumber
      ) async {
    debugPrint("🔥🔥🔥🔥🔥🔥🔥Response");
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
      };
      final res = await post(data, EmployeeContactListUrl, {});
      if (res != null) {
        print("Request Data: $data");
        debugPrint("🔥🔥🔥🔥🔥🔥🔥 Response: ${res.body}");
        return ContactListResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('API Error: $e');
      return null;
    }
  }


  static Future<CommonResponse?> fetchRazorpayUpiQrApi(
      session,
      empId,
      amount,
      refType,
      refId
      ) async {
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
        'amount': (amount),
        'ref_type': (refType).toString(),
        'ref_id': (refId),

      };
      final res = await post(data, createRazorpayUpiQrUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  static Future<CommonResponse?> fetchRazorpayUpiQrStatusApi(
      session,
      empId,
      razorpayOrderId,

      ) async {
    try {
      Map<String, String> data = {
        'session_id': (session).toString(),
        'emp_id': (empId).toString(),
        'razorpay_order_id': (razorpayOrderId),


      };
      final res = await post(data, fetchRazorpayUpiQrStatusUrl, {});
      if (res != null) {
        print(data);
        debugPrint(res.body);
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

  // static Future<CommonResponse?> TpcIssueListApprovalAPI(
  //     empId,
  //     session,
  //     tpc_payment_mode,
  //     tpc_payment_reference_no,
  //     order_id,
  //     order_tpc_feedback,
  //     tpc_paym_attachment
  //     ) async {
  //   try {
  //     Map<String, String> data = {
  //       'emp_id': (empId).toString(),
  //       'session_id': (session).toString(),
  //       'tpc_payment_mode':tpc_payment_mode.toString(),
  //       'tpc_payment_reference_no':tpc_payment_reference_no.toString(),
  //       'order_id':order_id.toString(),
  //       'order_tpc_feedback':order_tpc_feedback.toString(),
  //     };
  //     var res;
  //     if (tpc_paym_attachment != null) {
  //       res = await postImageNew(
  //         data,
  //         {},
  //         ordersApprovePendingTPCIssueListUrl,
  //         tpc_paym_attachment,
  //         "tpc_paym_attachment",
  //       );
  //       res = jsonDecode(res);
  //     } else {
  //       res = await post(data, ordersApprovePendingTPCIssueListUrl, {});
  //       res = jsonDecode(res.body);
  //       return CommonResponse.fromJson(res);
  //     }
  //   } catch (e) {
  //     debugPrint('hello bev=bug $e ');
  //     return null;
  //   }
  // }

  static Future<CommonResponse?> trackLiveLocationEmpolyeeAPI(empId, session,location) async {
    try {
      Map<String, String> data = {
        'emp_id': (empId).toString(),
        'session_id': (session).toString(),
        'location': (location),
      };
      // print(data);
      final res = await post(data, liveLocationStatusUrl, {});
      if (res != null) {
        print("BACKGROUND LOCATION DATA : ${data}");
        debugPrint("BACKGROUND LOCATION: ${res.body}");
        // print("check_session: ${res.body}");
        return CommonResponse.fromJson(jsonDecode(res.body));
      } else {
        debugPrint("Null Response");
        return null;
      }
    } catch (e) {
      debugPrint('hello bev=bug $e ');
      return null;
    }
  }

}
