import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';

import 'package:generp/screens/screensExports.dart';
import 'package:provider/provider.dart';
import '../../Notifiers/ordersProvider/pagesDashboardProvider.dart';
import '../../Utils/GlobalConstants.dart' show routeSettingName;
import '../../Utils/app_colors.dart';
import '../../Utils/commonServices.dart';
import '../../Utils/commonWidgets.dart';
import 'addTpcAgent.dart';

class Ordermoduledashboard extends StatefulWidget {
  const Ordermoduledashboard({super.key});

  @override
  State<Ordermoduledashboard> createState() => _OrdermoduledashboardState();
}

class _OrdermoduledashboardState extends State<Ordermoduledashboard> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var provider = Provider.of<Pagesdashboardprovider>(
        context,
        listen: false,
      );
      provider.orderDashboardAPIFunction(context, "executive", "", "", "");
      provider.ordersAccessiblePagesAPIFunction(context);
      provider.ordersAccessibleAddPagesAPIFunction(context);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == 'Online')
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Pagesdashboardprovider>(
      builder: (context, provider, child) {
        final pages = provider.ordersAccessiblePagesList;
        final orderListPages =
            pages
                .where((page) => page.pageName!.contains("Order List"))
                .toList();
        final receiptListPages =
            pages
                .where((page) => page.pageName!.contains("Receipt List"))
                .toList();

        final otherPages =
            pages
                .where(
                  (page) =>
                      !page.pageName!.contains("Order List") &&
                      !page.pageName!.contains("Receipt List"),
                )
                .toList();

        final approvalOrderPages =
            orderListPages
                .where(
                  (page) => [
                    'level_one_approval',
                    'level_two_approval',
                    'level_two_rejected',
                  ].contains(page.mode),
                )
                .toList();
        final otherOrderPages =
            orderListPages
                .where(
                  (page) =>
                      ![
                        'level_one_approval',
                        'level_two_approval',
                        'level_two_rejected',
                      ].contains(page.mode),
                )
                .toList();

        return Scaffold(
          resizeToAvoidBottomInset: true,
          backgroundColor: AppColors.scaffold_bg_color,
          appBar: appbarNew(context, "Orders", 0xFFFFFFFF),
          body: Container(
            child: SingleChildScrollView(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Container(
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.vertical(
                        bottom: Radius.circular(16),
                      ),
                    ),
                    child: Column(
                      children: [
                        Container(
                          height: 180,
                          decoration: BoxDecoration(
                            image: DecorationImage(
                              image: AssetImage(
                                "assets/svg/order/main_dashboard.png",
                              ),
                              fit: BoxFit.fitWidth,
                            ),
                            gradient: LinearGradient(
                              colors: [
                                AppColors.scaffold_bg_color,
                                AppColors.scaffold_bg_color,
                              ],
                              begin: Alignment.topCenter,
                              end: Alignment.bottomCenter,
                            ),
                          ),
                        ),
                        // if (provider.ordersgain.length > 0) ...[
                        //   Container(
                        //     padding: EdgeInsets.symmetric(
                        //       horizontal: 10,
                        //       vertical: 5,
                        //     ),
                        //     margin: EdgeInsets.only(bottom: 10),
                        //     decoration: BoxDecoration(
                        //       color: Colors.white,
                        //       borderRadius: BorderRadius.vertical(
                        //         bottom: Radius.circular(16),
                        //       ),
                        //     ),
                        //     height: MediaQuery.of(context).size.height * 0.25,
                        //     child: GridView.builder(
                        //       padding: EdgeInsets.symmetric(
                        //         horizontal: 0,
                        //         vertical: 5,
                        //       ),
                        //       itemCount: provider.ordersgain.length,
                        //       shrinkWrap: true,
                        //       scrollDirection: Axis.horizontal,
                        //       physics: AlwaysScrollableScrollPhysics(),
                        //       gridDelegate:
                        //           SliverGridDelegateWithFixedCrossAxisCount(
                        //             crossAxisCount: 2,
                        //             crossAxisSpacing: 10,
                        //             mainAxisSpacing: 10,
                        //             childAspectRatio: 55 / 100,
                        //           ),
                        //       itemBuilder: (context, jndex) {
                        //         final icons = ["comm_ic_1", "comm_ic_2"];
                        //         final leadTitles = [
                        //           'Order Gain',
                        //           'Dispatched',
                        //           'Pending Tasks',
                        //           'Quotation Generated',
                        //         ];
                        //         final assetNames = [
                        //           "assets/svg/crm/open_leads_ic.svg",
                        //           "assets/svg/crm/today_visits_ic.svg",
                        //           "assets/svg/crm/pending_tasks_ic.svg",
                        //           "assets/svg/crm/quotes_generated_ic.svg",
                        //         ];
                        //
                        //         final colors = [
                        //           0xFFE7FFE5,
                        //           0xFFFFFCD5,
                        //           0xFFEEF1FF,
                        //           0xFFF3EDFF,
                        //         ];
                        //         final textcolors = [
                        //           0xFF0D9C00,
                        //           0xFF605C00,
                        //           0xFF6563FF,
                        //           0xFF493272,
                        //         ];
                        //
                        //         return InkResponse(
                        //           child: Container(
                        //             padding: EdgeInsets.symmetric(
                        //               horizontal: 13,
                        //             ),
                        //             decoration: BoxDecoration(
                        //               color: Color(colors[jndex]),
                        //               borderRadius: BorderRadius.circular(20),
                        //             ),
                        //             child: Column(
                        //               crossAxisAlignment:
                        //                   CrossAxisAlignment.start,
                        //               mainAxisAlignment:
                        //                   MainAxisAlignment.center,
                        //               children: [
                        //                 Text(
                        //                   provider.ordersgain[jndex].count
                        //                       .toString(),
                        //                   style: TextStyle(
                        //                     fontSize: 20,
                        //                     fontFamily: "JakartaMedium",
                        //                     color: Color(textcolors[jndex]),
                        //                   ),
                        //                 ),
                        //                 Row(
                        //                   children: [
                        //                     Expanded(
                        //                       flex: 3,
                        //                       child: Text(
                        //                         leadTitles[jndex],
                        //                         style: TextStyle(
                        //                           fontSize: 14,
                        //                           fontFamily: "JakartaRegular",
                        //                           color: AppColors.semi_black,
                        //                         ),
                        //                       ),
                        //                     ),
                        //                     Expanded(
                        //                       flex: 1,
                        //                       child: SvgPicture.asset(
                        //                         assetNames[jndex],
                        //                       ),
                        //                     ),
                        //                   ],
                        //                 ),
                        //               ],
                        //             ),
                        //           ),
                        //         );
                        //       },
                        //     ),
                        //   ),
                        // ],
                      ],
                    ),
                  ),

                  if (approvalOrderPages.isNotEmpty) ...[
                    Padding(
                      padding: const EdgeInsets.only(
                        top: 10,
                        bottom: 5,
                        left: 10,
                      ),
                      child: Text(
                        "Approval Levels",
                        style: TextStyle(
                          color: AppColors.grey_thick,
                          fontSize: 14,
                          fontFamily: "JakartaMedium",
                        ),
                      ),
                    ),
                    Container(
                      padding: EdgeInsets.symmetric(
                        vertical: 10,
                        horizontal: 15,
                      ),
                      margin: EdgeInsets.symmetric(horizontal: 10),
                      decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.circular(14),
                      ),
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: List.generate(approvalOrderPages.length, (
                          co,
                        ) {
                          Widget? SvgIcon;
                          switch (approvalOrderPages[co].mode) {
                            case "level_one_approval":
                              SvgIcon = SvgPicture.asset(
                                "assets/svg/finance/fin_lvl1_ic.svg",
                              );
                              break;
                            case "level_two_approval":
                            case "level_two_rejected":
                              SvgIcon = SvgPicture.asset(
                                "assets/svg/finance/fin_lvl2_ic.svg",
                              );
                              break;
                            default:
                              SvgIcon = SvgPicture.asset(
                                "assets/svg/finance/fin_lvl1_ic.svg",
                              );
                              break;
                          }
                          return Expanded(
                            child: InkResponse(
                              onTap: () async {
                                var navigate;
                                if (approvalOrderPages[co].pageName!.contains(
                                  "Order List",
                                )) {
                                  navigate = OrderslistbyModes(
                                    mode: approvalOrderPages[co].mode!,
                                    pageTitleName:
                                    approvalOrderPages[co].pageName!,
                                  );
                                }
                                if (navigate != null) {
                                  await Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                      builder: (context) => navigate,
                                    ),
                                  );
                                }
                              },
                              child: SizedBox(
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    SvgIcon,
                                    SizedBox(height: 10),
                                    Text(
                                      approvalOrderPages[co].pageName ?? "-",
                                      maxLines: 2,
                                      textAlign: TextAlign.center,
                                      style: TextStyle(
                                        fontSize: 12,
                                        fontFamily: "JakartaMedium",
                                      ),
                                    ),
                                  ],
                                ),
                              ),
                            ),
                          );
                        }),
                      ),
                    ),
                  ],
                  if (otherOrderPages.isNotEmpty) ...[
                    Padding(
                      padding: const EdgeInsets.only(
                        top: 10,
                        bottom: 5,
                        left: 10,
                      ),
                      child: Text(
                        "Order List",
                        style: TextStyle(
                          color: AppColors.grey_thick,
                          fontSize: 14,
                          fontFamily: "JakartaMedium",
                        ),
                      ),
                    ),
                    GridView.builder(
                      gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                        crossAxisCount: 2,
                        childAspectRatio: 2 / 1,
                      ),
                      itemCount: otherOrderPages.length,
                      shrinkWrap: true,
                      physics: NeverScrollableScrollPhysics(),
                      itemBuilder: (context, index) {
                        Widget? SvgIcon;
                        switch (otherOrderPages[index].mode) {
                          case "level_one_approval":
                            SvgIcon = SvgPicture.asset(
                              "assets/svg/finance/fin_lvl1_ic.svg",
                            );
                            break;
                          case "level_two_approval":
                          case "level_two_rejected":
                            SvgIcon = SvgPicture.asset(
                              "assets/svg/finance/fin_lvl2_ic.svg",
                            );
                            break;
                          case "self":
                            SvgIcon = SvgPicture.asset(
                              "assets/svg/finance/fin_self_ic.svg",
                            );
                            break;
                          case "pending_approval":
                            SvgIcon = SvgPicture.asset(
                              "assets/svg/finance/fin_accounts_ic.svg",
                            );
                            break;
                          case "sales_order_registered":
                            SvgIcon = SvgPicture.asset(
                              "assets/svg/finance/fin_process_ic.svg",
                            );
                            break;

                          default:
                            SvgIcon = SvgPicture.asset(
                              "assets/svg/finance/other_payment_ic.svg",
                            );
                            break;
                        }

                        return InkResponse(
                          onTap: () async {
                            var navigate;
                            if (otherOrderPages[index].pageName!.contains(
                              "Order List",
                            )) {
                              navigate = OrderslistbyModes(
                                mode: otherOrderPages[index].mode!,
                                pageTitleName: otherOrderPages[index].pageName!,
                              );
                            }
                            if (navigate != null) {
                              await Navigator.push(
                                context,
                                MaterialPageRoute(
                                  builder: (context) => navigate,
                                ),
                              );
                            }
                          },
                          child: Container(
                            padding: EdgeInsets.symmetric(
                              vertical: 5,
                              horizontal: 15,
                            ),
                            margin: EdgeInsets.symmetric(
                              vertical: 7,
                              horizontal: 5,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Expanded(
                                  flex: 2,
                                  child: SizedBox(
                                    child: Column(
                                      crossAxisAlignment:
                                      CrossAxisAlignment.start,
                                      mainAxisAlignment:
                                      MainAxisAlignment.center,
                                      children: [
                                        Text(
                                          otherOrderPages[index].pageName ??
                                              "-",
                                          style: TextStyle(
                                            fontSize: 14,
                                            color: AppColors.app_blue,
                                            fontFamily: "JakartaMedium",
                                          ),
                                        ),
                                        // Text(
                                        //   filteredPaymentAdministrations[ad]['subtitle'] ??
                                        //       "-",
                                        //   maxLines: 2,
                                        //   style: TextStyle(
                                        //     fontSize: 12,
                                        //     color: AppColors.grey_semi,
                                        //     fontFamily: "JakartaMedium",
                                        //   ),
                                        // ),
                                      ],
                                    ),
                                  ),
                                ),
                                SizedBox(width: 10),
                                Expanded(flex: 1, child: SvgIcon),
                              ],
                            ),
                          ),
                        );
                      },
                    ),
                  ],
                  if (receiptListPages.isNotEmpty) ...[
                    Padding(
                      padding: const EdgeInsets.only(
                        top: 10,
                        bottom: 5,
                        left: 10,
                      ),
                      child: Text(
                        "Receipt List",
                        style: TextStyle(
                          color: AppColors.grey_thick,
                          fontSize: 14,
                          fontFamily: "JakartaMedium",
                        ),
                      ),
                    ),

                    GridView.builder(
                      gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                        crossAxisCount: 2,
                        childAspectRatio: 2 / 1,
                      ),
                      itemCount: receiptListPages.length,
                      shrinkWrap: true,
                      physics: NeverScrollableScrollPhysics(),
                      itemBuilder: (context, index) {
                        Widget? SvgIcon;
                        switch (receiptListPages[index].mode) {
                          case "self":
                            SvgIcon = SvgPicture.asset(
                              "assets/svg/finance/fin_self_ic.svg",
                            );
                            break;
                          case "pending_approval":
                            SvgIcon = SvgPicture.asset(
                              "assets/svg/finance/fin_accounts_ic.svg",
                            );
                            break;

                          default:
                            SvgIcon = SvgPicture.asset(
                              "assets/svg/finance/other_payment_ic.svg",
                            );
                            break;
                        }

                        return InkResponse(
                          onTap: () async {
                            var navigate;
                            if (receiptListPages[index].pageName!.contains(
                              "Receipt List",
                            )) {
                              navigate = await Navigator.push(
                                context,
                                MaterialPageRoute(
                                  builder:
                                      (context) => Paymentlistsbymode(
                                        mode: receiptListPages[index].mode!,
                                        pageTitleName:
                                            receiptListPages[index].pageName!,
                                      ),
                                  settings: RouteSettings(
                                    name: "Paymentlistsbymode",
                                  ),
                                ),
                              );
                            }
                          },
                          child: Container(
                            padding: EdgeInsets.symmetric(
                              vertical: 5,
                              horizontal: 15,
                            ),
                            margin: EdgeInsets.symmetric(
                              vertical: 7,
                              horizontal: 5,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Expanded(
                                  flex: 2,
                                  child: SizedBox(
                                    child: Column(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      mainAxisAlignment:
                                          MainAxisAlignment.center,
                                      children: [
                                        Text(
                                          receiptListPages[index].pageName ??
                                              "-",
                                          style: TextStyle(
                                            fontSize: 14,
                                            color: AppColors.app_blue,
                                            fontFamily: "JakartaMedium",
                                          ),
                                        ),
                                        // Text(
                                        //   filteredPaymentAdministrations[ad]['subtitle'] ??
                                        //       "-",
                                        //   maxLines: 2,
                                        //   style: TextStyle(
                                        //     fontSize: 12,
                                        //     color: AppColors.grey_semi,
                                        //     fontFamily: "JakartaMedium",
                                        //   ),
                                        // ),
                                      ],
                                    ),
                                  ),
                                ),
                                SizedBox(width: 10),
                                Expanded(flex: 1, child: SvgIcon),
                              ],
                            ),
                          ),
                        );
                      },
                    ),
                  ],
                  if (otherPages.isNotEmpty) ...[
                    Padding(
                      padding: const EdgeInsets.only(
                        top: 10,
                        bottom: 5,
                        left: 10,
                      ),
                      child: Text(
                        "TPC",
                        style: TextStyle(
                          color: AppColors.grey_thick,
                          fontSize: 14,
                          fontFamily: "JakartaMedium",
                        ),
                      ),
                    ),
                    GridView.builder(
                      gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                        crossAxisCount: 2,
                        childAspectRatio: 2 / 1,
                      ),
                      itemCount: otherPages.length,
                      shrinkWrap: true,
                      physics: NeverScrollableScrollPhysics(),
                      itemBuilder: (context, index) {
                        Widget? SvgIcon;
                        switch (otherPages[index].mode) {
                          case "self":
                            SvgIcon = SvgPicture.asset(
                              "assets/svg/finance/fin_receipts_ic.svg",
                            );
                            break;

                          default:
                            SvgIcon = SvgPicture.asset(
                              "assets/svg/finance/fin_payments_ic.svg",
                            );
                            break;
                        }

                        return InkResponse(
                          onTap: () async {
                            var navigate;
                            if (otherPages[index].pageName!.contains(
                              "TPC Agent List",
                            )) {
                              navigate = Tpcagentlistbymode(
                                mode: otherPages[index].mode!,
                                pageTitleName: otherPages[index].pageName!,
                              );
                            } else if (otherPages[index].pageName ==
                                "Pending TPC Issue List") {
                              navigate = Tpcagentissuelist(
                                mode: otherPages[index].mode!,
                                pageTitleName: otherPages[index].pageName!,
                              );
                            }
                            if (navigate != null) {
                              await Navigator.push(
                                context,
                                MaterialPageRoute(
                                  builder: (context) => navigate,
                                ),
                              );
                            }
                          },
                          child: Container(
                            padding: EdgeInsets.symmetric(
                              vertical: 5,
                              horizontal: 15,
                            ),
                            margin: EdgeInsets.symmetric(
                              vertical: 7,
                              horizontal: 5,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(14),
                            ),
                            child: Row(
                              mainAxisAlignment: MainAxisAlignment.center,
                              crossAxisAlignment: CrossAxisAlignment.center,
                              children: [
                                Expanded(
                                  flex: 2,
                                  child: SizedBox(
                                    child: Column(
                                      crossAxisAlignment:
                                      CrossAxisAlignment.start,
                                      mainAxisAlignment:
                                      MainAxisAlignment.center,
                                      children: [
                                        Text(
                                          otherPages[index].pageName ?? "-",
                                          style: TextStyle(
                                            fontSize: 14,
                                            color: AppColors.app_blue,
                                            fontFamily: "JakartaMedium",
                                          ),
                                        ),
                                        // Text(
                                        //   filteredPaymentAdministrations[ad]['subtitle'] ??
                                        //       "-",
                                        //   maxLines: 2,
                                        //   style: TextStyle(
                                        //     fontSize: 12,
                                        //     color: AppColors.grey_semi,
                                        //     fontFamily: "JakartaMedium",
                                        //   ),
                                        // ),
                                      ],
                                    ),
                                  ),
                                ),
                                SizedBox(width: 10),
                                Expanded(flex: 1, child: SvgIcon),
                              ],
                            ),
                          ),
                        );
                      },
                    ),
                  ],

                  SizedBox(height: 75),
                ],
              ),
            ),
          ),
          floatingActionButtonLocation:
              FloatingActionButtonLocation.centerFloat,
          floatingActionButton: InkResponse(
            onTap: () {
              _showPaymentOptionsSheet(context);
            },
            child: Container(
              height: 45,
              alignment: Alignment.center,
              margin: EdgeInsets.symmetric(horizontal: 10),
              padding: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
              decoration: BoxDecoration(
                color: AppColors.app_blue,
                borderRadius: BorderRadius.circular(15),
              ),
              child: Text(
                "Add",
                style: TextStyle(
                  fontSize: 15,
                  fontFamily: "JakartaMedium",
                  color: Colors.white,
                ),
              ),
            ),
          ),
        );
      },
    );
  }

  Widget _scaffold1(BuildContext context) {
    return Consumer<Pagesdashboardprovider>(
      builder: (context, provider, child) {
        final pages = provider.ordersAccessiblePagesList;
        return Scaffold(
          resizeToAvoidBottomInset: true,
          backgroundColor: AppColors.scaffold_bg_color,
          appBar: appbar(context, "Orders"),
          body: Container(
            child: SingleChildScrollView(
              child: Column(
                children: [
                  if (provider.ordersgain.isNotEmpty) ...[
                    Container(
                      padding: EdgeInsets.symmetric(
                        horizontal: 10,
                        vertical: 5,
                      ),
                      margin: EdgeInsets.symmetric(horizontal: 0, vertical: 10),
                      decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.circular(16),
                      ),
                      height: MediaQuery.of(context).size.height * 0.28,
                      child: GridView.builder(
                        padding: EdgeInsets.symmetric(
                          horizontal: 0,
                          vertical: 5,
                        ),
                        itemCount: provider.ordersgain.length,
                        shrinkWrap: true,
                        scrollDirection: Axis.horizontal,
                        physics: AlwaysScrollableScrollPhysics(),
                        gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                          crossAxisCount: 2,
                          crossAxisSpacing: 10,
                          mainAxisSpacing: 10,
                          childAspectRatio: 0.65,
                        ),
                        itemBuilder: (context, jndex) {
                          final icons = ["comm_ic_1", "comm_ic_2"];
                          final leadTitles = [
                            'Order Gain',
                            'Dispatched',
                            'Pending Tasks',
                            'Quote',
                          ];
                          final colors = [
                            0xFFE7FFE5,
                            0xFFF3EDFF,
                            0xFFFFFCD5,
                            0xFFFFF6F0,
                          ];
                          final textcolors = [
                            0xFF0D9C00,
                            0xFF493272,
                            0xFF605C00,
                            0xFF91481B,
                          ];
                          return InkResponse(
                            onTap: () async {
                              if (provider.ordersgain[jndex].filter!.pageName !=
                                  "") {
                                if (provider.ordersgain[jndex].filter!.pageName!
                                    .contains("Order List")) {
                                  // await Navigator.push(
                                  //   context,
                                  //   MaterialPageRoute(
                                  //     builder:
                                  //         (context) => OrderslistbyModes(
                                  //       pageTitleName:
                                  //       provider
                                  //           .ordersgain[jndex]
                                  //           .filter!
                                  //           .pageName!,
                                  //       mode:
                                  //       provider.ordersgain[jndex].filter!.mode,
                                  //       filter: provider.ordersgain[jndex].filter!,
                                  //     ),
                                  //   ),
                                  // );
                                }
                              }
                            },
                            child: Container(
                              padding: EdgeInsets.symmetric(horizontal: 13),
                              decoration: BoxDecoration(
                                color: Color(colors[jndex]),
                                borderRadius: BorderRadius.circular(12),
                              ),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  Text(
                                    provider.ordersgain[jndex].count!,
                                    style: TextStyle(
                                      fontSize: 30,
                                      fontFamily: "JakartaMedium",
                                      color: Color(textcolors[jndex]),
                                    ),
                                  ),
                                  Text(
                                    leadTitles[jndex],
                                    style: TextStyle(color: Color(0xFF818181)),
                                  ),
                                ],
                              ),
                            ),
                          );
                        },
                      ),
                    ),
                  ],
                  ListView.builder(
                    itemCount: pages.length,
                    shrinkWrap: true,
                    physics: NeverScrollableScrollPhysics(),
                    itemBuilder: (context, index) {
                      Widget? SvgIcon;
                      switch (pages[index].mode) {
                        case "level_one_approval":
                          SvgIcon = SvgPicture.asset("assets/svg/fin_lv1.svg");
                          break;
                        case "level_two_approval":
                        case "level_two_rejected":
                          SvgIcon = SvgPicture.asset("assets/svg/fin_lv2.svg");
                          break;

                        default:
                          SvgIcon = SvgPicture.asset("assets/svg/fin_ic.svg");
                          break;
                      }

                      return InkResponse(
                        onTap: () async {
                          var navigate;
                          if (pages[index].pageName!.contains("Add Order")) {
                            navigate = AddorderScreen(
                              mode: pages[index].mode!,
                              pageTitleName: pages[index].pageName!,
                            );
                          }
                          if (pages[index].pageName!.contains("Add Payment")) {
                            ("navigate to Add Payment");
                            navigate = AddpaymentScreen(
                              mode: pages[index].mode!,
                              pageTitleName: pages[index].pageName!,
                            );
                          } else if (pages[index].pageName!.contains(
                            "Payments List",
                          )) {
                            navigate = Paymentlistsbymode(
                              mode: pages[index].mode!,
                              pageTitleName: pages[index].pageName!,
                            );
                          } else if (pages[index].pageName!.contains(
                            "Order List",
                          )) {
                            navigate = OrderslistbyModes(
                              mode: pages[index].mode!,
                              pageTitleName: pages[index].pageName!,
                            );
                          } else if (pages[index].pageName == "Add TPC Agent") {
                            navigate = AddtpcagentScreen();
                          } else if (pages[index].pageName ==
                              "TPC Agent List (Admin)") {
                            navigate = Tpcagentlistbymode(
                              mode: pages[index].mode!,
                              pageTitleName: pages[index].pageName!,
                            );
                          } else if (pages[index].pageName ==
                              "Pending TPC Issue List") {
                            navigate = Tpcagentissuelist(
                              mode: pages[index].mode!,
                              pageTitleName: pages[index].pageName!,
                            );
                          }
                          if (navigate != null) {
                            await Navigator.push(
                              context,
                              MaterialPageRoute(builder: (context) => navigate),
                            );
                          }
                        },
                        child: Container(
                          margin: EdgeInsets.symmetric(
                            horizontal: 5,
                            vertical: 5,
                          ),
                          padding: EdgeInsets.symmetric(
                            horizontal: 10,
                            vertical: 15,
                          ),
                          decoration: BoxDecoration(
                            color: Colors.white,
                            borderRadius: BorderRadius.circular(14),
                          ),
                          child: Row(
                            children: [
                              Expanded(flex: 1, child: SvgIcon),
                              Expanded(
                                flex: 5,
                                child: Text("${pages[index].pageName}"),
                              ),
                              Expanded(
                                flex: 1,
                                child: SvgPicture.asset(
                                  "assets/svg/arrow_right_new.svg",
                                ),
                              ),
                            ],
                          ),
                        ),
                      );
                    },
                  ),
                ],
              ),
            ),
          ),
          floatingActionButtonLocation:
              FloatingActionButtonLocation.centerFloat,
          floatingActionButton: InkResponse(
            onTap: () {
              _showPaymentOptionsSheet(context);
            },
            child: Container(
              height: 45,
              alignment: Alignment.center,
              margin: EdgeInsets.symmetric(horizontal: 10),
              padding: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
              decoration: BoxDecoration(
                color: AppColors.app_blue,
                borderRadius: BorderRadius.circular(15),
              ),
              child: Text(
                "Add",
                style: TextStyle(
                  fontSize: 15,
                  fontFamily: "JakartaMedium",
                  color: Colors.white,
                ),
              ),
            ),
          ),
        );
      },
    );
  }

  Future<void> _showPaymentOptionsSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Pagesdashboardprovider>(
                builder: (context, provider, child) {
                  final pages2 = provider.ordersAccessiblePagesList2;
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          SizedBox(height: 15),

                          ...List.generate(pages2.length, (index) {
                            print(pages2[index].mode);
                            // "assets/svg/crm/open_leads_ic.svg"
                            //"assets/svg/finance/fin_receipts_ic.svg"
                            //"assets/svg/finance/fin_payments_ic.svg"
                            final icons = [
                              "assets/svg/finance/other_payment_ic.svg",
                              "assets/svg/finance/fin_accounts_ic.svg",
                              "assets/svg/finance/fin_payments_ic.svg",
                            ];
                            return ListTile(
                              onTap: () async {
                                var res;
                                if (pages2[index].pageName!.contains(
                                  "Add Order",
                                )) {
                                  res = await Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                      builder:
                                          (context) => AddorderScreen(
                                            mode: pages2[index].mode!,
                                            pageTitleName:
                                                pages2[index].pageName!,
                                          ),
                                      settings: RouteSettings(
                                        name: "AddorderScreen",
                                      ),
                                    ),
                                  );
                                } else if (pages2[index].pageName!.contains(
                                  "Add Receipt",
                                )) {
                                  res = await Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                      builder:
                                          (context) => AddpaymentScreen(
                                            mode: pages2[index].mode!,
                                            pageTitleName:
                                                pages2[index].pageName!,
                                          ),
                                      settings: RouteSettings(
                                        name: "AddpaymentScreen",
                                      ),
                                    ),
                                  );
                                } else if (pages2[index].pageName ==
                                    "Add TPC Agent") {
                                  res = await Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                      builder: (context) => AddtpcagentScreen(),
                                      settings: RouteSettings(
                                        name: "AddtpcagentScreen",
                                      ),
                                    ),
                                  );
                                } else {
                                  res = await Navigator.push(
                                    context,
                                    MaterialPageRoute(
                                      builder:
                                          (context) =>
                                              Submitpaymentrequestionlistsbymode(
                                                mode: "${pages2[index].mode}",
                                                pageTitleName:
                                                    "${pages2[index].pageName}",
                                              ),
                                      settings: RouteSettings(
                                        name:
                                            "Submitpaymentrequestionlistsbymode",
                                      ),
                                    ),
                                  );
                                }
                                // switch (routeSettingName) {
                                //   case "Submitpaymentrequestionlistsbymode":
                                //     print("here");
                                //     Provider.of<Requestionlistprovider>(
                                //       context,
                                //       listen: false,
                                //     ).resetForm();
                                //     break;
                                //   case "Addcommonpayment":
                                //     Provider.of<Accountslistprovider>(
                                //       context,
                                //       listen: false,
                                //     ).resetValues();
                                //     break;
                                //   case "Addpaymentreceiptlist":
                                //     Provider.of<Paymentreceiptsprovider>(
                                //       context,
                                //       listen: false,
                                //     ).resetForm();
                                //     break;
                                //   case "Directpaymentrequesitionlist":
                                //     Provider.of<Requestionlistprovider>(
                                //       context,
                                //       listen: false,
                                //     ).resetForm();
                                //     break;
                                // }
                                Navigator.pop(context);
                              },
                              leading: SvgPicture.asset(icons[index]),
                              title: Text(
                                "${pages2[index].pageName}",
                                style: TextStyle(
                                  fontSize: 14,
                                  fontFamily: "JakartaMedium",
                                ),
                              ),
                              trailing: SvgPicture.asset(
                                "assets/svg/arrow_right_new.svg",
                              ),
                            );
                          }),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }
}
