import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:generp/screens/genTracker/ScanEnterGeneratorIDScreen.dart';

import '../../Utils/app_colors.dart';
import '../../Utils/commonServices.dart';

class Gentrackerdashboard extends StatefulWidget {
  const Gentrackerdashboard({super.key});

  @override
  State<Gentrackerdashboard> createState() => _GentrackerdashboardState();
}

class _GentrackerdashboardState extends State<Gentrackerdashboard> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

@override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection=="Online")?Platform.isAndroid
        ? WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(top: false, bottom: true, child: _scaffold(context)),
        )
        : _scaffold(context):NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    final names = [
      "Generator Details",
      // "Register Complaint",
      // "Tag Location",
      "Tag Generator",
    ];
    final icons = [
      "gent_gen_det",
      // "gent_reg_comp",
      // "gent_tag_loc",
      "gent_tag_den",
    ];
    return Scaffold(
      resizeToAvoidBottomInset: true,
      backgroundColor: AppColors.scaffold_bg_color,
      appBar: appbarNew(context, "Gen Tracker",0xFFFFFFFF),
      body: Column(
        children: [
          Expanded(
            flex: 1,
            child: GridView.builder(
              padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
              itemCount: names.length,
              gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                crossAxisCount: 2,
                crossAxisSpacing: 10,
                mainAxisSpacing: 10,
              ),
              physics: NeverScrollableScrollPhysics(),
              itemBuilder: (context, index) {
                return InkResponse(
                  onTap: () {
                    switch (names[index]) {
                      case "Generator Details":
                        Navigator.push(
                          context,
                          MaterialPageRoute(
                            builder:
                                (context) => Scanentergeneratoridscreen(
                                  from: "Generator Details",
                                ),
                          ),
                        );
                        break;
                      case "Register Complaint":
                        Navigator.push(
                          context,
                          MaterialPageRoute(
                            builder:
                                (context) => Scanentergeneratoridscreen(
                                  from: "Register Complaint",
                                ),
                          ),
                        );
                        break;
                      case "Tag Location":
                        Navigator.push(
                          context,
                          MaterialPageRoute(
                            builder:
                                (context) => Scanentergeneratoridscreen(
                                  from: "Tag Location",
                                ),
                          ),
                        );
                        break;
                      case "Tag Generator":
                        Navigator.push(
                          context,
                          MaterialPageRoute(
                            builder:
                                (context) => Scanentergeneratoridscreen(
                                  from: "Tag Generator",
                                ),
                          ),
                        );
                        break;

                      default:
                        print("111");
                        break;
                    }
                  },
                  child: Container(
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.circular(30),
                    ),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.center,
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        SvgPicture.asset("assets/svg/${icons[index]}.svg"),
                        SizedBox(height: 10),
                        Text(names[index]),
                      ],
                    ),
                  ),
                );
              },
            ),
          ),
          SizedBox(height: 10),
          Expanded(
            flex: 3,
            child: Padding(
              padding: const EdgeInsets.all(8.0),
              child: Text(
                "Note: 'Tag Location' and 'Register Complaint' are moved to 'Generator Details'.",
                style: TextStyle(color: AppColors.grey_thick, fontSize: 14),
              ),
            ),
          ),
          SizedBox(height: 10),
        ],
      ),
    );
  }
}
