import 'package:flutter/material.dart';
import 'package:flutter_html/flutter_html.dart';
import 'package:flutter_svg/svg.dart';
import '../../Utils/app_colors.dart';

class JobDescriptionScreen extends StatefulWidget {
  final String htmlData;
  final String title;
  final String designation;

  const JobDescriptionScreen({
    super.key,
    required this.htmlData,
    this.title = "Job Description",
    required this.designation,
  });

  @override
  State<JobDescriptionScreen> createState() => _JobDescriptionScreenState();
}

class _JobDescriptionScreenState extends State<JobDescriptionScreen> {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppColors.scaffold_bg_color,

      /// AppBar
      appBar: AppBar(
        automaticallyImplyLeading: false,
        backgroundColor: Colors.white,
        title: Row(
          children: [
            InkResponse(
              onTap: () => Navigator.pop(context, true),
              child: SvgPicture.asset(
                "assets/svg/appbar_back_button.svg",
                height: 25,
              ),
            ),
            const SizedBox(width: 10),
            Text(
              "Job Description",
              style: TextStyle(
                fontSize: 18,
                fontFamily: "Plus Jakarta Sans",
                fontWeight: FontWeight.w600,
                color: AppColors.semi_black,
              ),
            ),
          ],
        ),
      ),

      /// Body
      body: SafeArea(
        child: SingleChildScrollView(
          padding: const EdgeInsets.symmetric(horizontal: 20, vertical: 18),
          child: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              /// Designation Heading
              Text(
                widget.designation,
                style: TextStyle(
                  color: AppColors.app_blue,
                  fontFamily: "JakartaSemiBold",
                  fontSize: 18,
                  fontWeight: FontWeight.w600,
                ),
              ),
              const SizedBox(height: 12),

              /// HTML Description
              Html(
                data: widget.htmlData,
                style: {
                  "h2": Style(
                    wordSpacing: 0,
                    letterSpacing: 0,
                    fontSize: FontSize(16),
                    fontFamily: "JakartaMedium",
                    color: AppColors.semi_black,
                  ),
                  "h3": Style(
                    wordSpacing: 0,
                    letterSpacing: 0,
                    fontSize: FontSize(12),
                    fontFamily: "JakartaMedium",
                    color: AppColors.semi_black,
                  ),
                  "p": Style(
                    wordSpacing: 0,
                    letterSpacing: 0,
                    fontSize: FontSize(12),
                    fontFamily: "JakartaMedium",
                    color: AppColors.grey_semi,
                    lineHeight: LineHeight.number(2.4),
                  ),
                  "ul": Style(
                    wordSpacing: 0,
                    letterSpacing: 0,
                    fontSize: FontSize(15),
                    fontFamily: "JakartaMedium",
                    color: AppColors.grey_semi,
                    padding: HtmlPaddings.only(left: 12, right: 8),
                    lineHeight: LineHeight.number(1.4),
                  ),
                  "li": Style(
                    wordSpacing: 0,
                    letterSpacing: 0,
                    fontSize: FontSize(14),
                    fontFamily: "JakartaMedium",
                    color: Colors.black,
                    padding: HtmlPaddings.only(left: 4),
                    lineHeight: LineHeight.number(1.4),
                    margin: Margins.only(bottom: 10),
                  ),
                  "a": Style(
                    color: Colors.blue,
                    textDecoration: TextDecoration.underline,
                  ),
                },
                onLinkTap: (url, _, __) {
                  debugPrint("Link tapped: $url");
                  if (url != null) {
                    // launchUrl(Uri.parse(url)); //
                  }
                },
              ),
            ],
          ),
        ),
      ),
    );
  }
}
