import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

import '../../Models/hrmModels/hrmAccessiblePagesResponse.dart';
import '../../services/api_calling.dart';
import '../HomeScreenNotifier.dart';

class HrmAccessiblePagesProvider extends ChangeNotifier {
  hrmAccessiblePagesResponse? _response;
  bool _isLoading = false;
  String? _errorMessage;

  hrmAccessiblePagesResponse? get response => _response;
  bool get isLoading => _isLoading;
  String? get errorMessage => _errorMessage;

  /// Fetch HRM Accessible Pages
  Future<void> fetchAccessiblePages(BuildContext context) async {
    _isLoading = true;
    _errorMessage = null;
    _response = null;
    notifyListeners();

    try {
      final provider = Provider.of<HomescreenNotifier>(context, listen: false);

      final result = await ApiCalling.hrmAccessiblePagesAPI(
        provider.empId,
        provider.session,
      );

      if (result != null) {
        _response = result;
        if (_response?.pagesAccessible == null ||
            _response!.pagesAccessible!.isEmpty) {
          _errorMessage = "No accessible pages found!";
        }
      } else {
        _errorMessage = "No data found!";
      }
    } catch (e) {
      _errorMessage = "Something went wrong: $e";
      debugPrint("Error fetching HRM accessible pages: $e");
    }

    _isLoading = false;
    notifyListeners();
  }

  /// Clear stored data
  void clearData() {
    _response = null;
    _errorMessage = null;
    notifyListeners();
  }
}
