import 'package:flutter/material.dart';
import 'package:generp/services/api_calling.dart';

import '../../Models/financeModels/ValidateBankAccountDetailsResponse.dart';
import '../../Models/financeModels/ValidateGstNumResponse.dart';


class ValidationProvider extends ChangeNotifier {
  bool isLoading = false;

  ValidateGstNumResponse? gstResponse;
  ValidateBankAccountDetailsResponse? bankResponse;

  String? errorMessage;


  /// Validate GST Number
  /// -----------------------------
  Future<void> validateGstNumber(
      String empId, String sessionId, String gstNumber) async {
    try {
      isLoading = true;
      errorMessage = null;
      notifyListeners();

      gstResponse = await ApiCalling.validateGstNumberApi(
        empId,
        sessionId,
        gstNumber,
      );

      if (gstResponse == null) {
        errorMessage = "Failed to validate GST number";
      }

    } catch (e) {
      errorMessage = e.toString();
    }

    isLoading = false;
    notifyListeners();
  }


  /// Validate Bank Account Details
  /// -----------------------------
  Future<void> validateBankDetails(
      String empId, String sessionId, String accountNumber) async {
    try {
      isLoading = true;
      errorMessage = null;
      notifyListeners();

      bankResponse = await ApiCalling.validateBankAccountDetailsApi(
        empId,
        sessionId,
        accountNumber,
        ""
      );

      if (bankResponse == null) {
        errorMessage = "Failed to validate bank account";
      }

    } catch (e) {
      errorMessage = e.toString();
    }

    isLoading = false;
    notifyListeners();
  }

  /// Reset before calling again
  void clear() {
    gstResponse = null;
    bankResponse = null;
    errorMessage = null;
    notifyListeners();
  }
}
