class paymentRequesitionListsResponse {
  List<RequistionList>? requistionList;
  String? error;
  String? message;

  paymentRequesitionListsResponse({
    this.requistionList,
    this.error,
    this.message,
  });

  paymentRequesitionListsResponse.fromJson(Map<String, dynamic> json) {
    if (json['requistion_list'] != null) {
      requistionList = <RequistionList>[];
      json['requistion_list'].forEach((v) {
        requistionList!.add(RequistionList.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (requistionList != null) {
      data['requistion_list'] = requistionList!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class RequistionList {
  String? id;
  String? isProcessedPaymentRequest;
  String? accountId;
  String? accountName;
  String? branch;
  String? requestingPurpose;
  String? transDis;
  String? description;
  String? amount;
  String? requestMode;
  String? status;
  String? createdEmployee;
  String? level1Employee;
  String? level2Employee;
  String? level1ApprovalRemarks;
  String? level2ApprovalRemarks;
  String? attachmentViewFileName;
  String? attachmentDirFilePath;
  String? date;
  String? createdDatetime;
  String? proposedAccount;
  String? proposedAccountId;

  RequistionList({
    this.id,
    this.isProcessedPaymentRequest,
    this.accountId,
    this.accountName,
    this.branch,
    this.requestingPurpose,
    this.transDis,
    this.description,
    this.amount,
    this.requestMode,
    this.status,
    this.createdEmployee,
    this.level1Employee,
    this.level2Employee,
    this.level1ApprovalRemarks,
    this.level2ApprovalRemarks,
    this.attachmentViewFileName,
    this.attachmentDirFilePath,
    this.date,
    this.createdDatetime,
    this.proposedAccount,
    this.proposedAccountId,
  });

  RequistionList.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    isProcessedPaymentRequest = json['is_processed_payment_request'];
    accountId = json['account_id'];
    accountName = json['account_name'];
    branch = json['branch'];
    requestingPurpose = json['requesting_purpose'];
    transDis = json['trans_dis'];
    description = json['description'];
    amount = json['amount'];
    requestMode = json['request_mode'];
    status = json['status'];
    createdEmployee = json['created_employee'];
    level1Employee = json['level1_employee'];
    level2Employee = json['level2_employee'];
    level1ApprovalRemarks = json['level_1_approval_remarks'];
    level2ApprovalRemarks = json['level_2_approval_remarks'];
    attachmentViewFileName = json['attachment_view_file_name'];
    attachmentDirFilePath = json['attachment_dir_file_path'];
    date = json['date'];
    createdDatetime = json['created_datetime'];
    proposedAccount = json['proposed_account'];
    proposedAccountId = json['proposed_account_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['is_processed_payment_request'] = isProcessedPaymentRequest;
    data['account_id'] = accountId;
    data['account_name'] = accountName;
    data['branch'] = branch;
    data['requesting_purpose'] = requestingPurpose;
    data['trans_dis'] = transDis;
    data['description'] = description;
    data['amount'] = amount;
    data['request_mode'] = requestMode;
    data['status'] = status;
    data['created_employee'] = createdEmployee;
    data['level1_employee'] = level1Employee;
    data['level2_employee'] = level2Employee;
    data['level_1_approval_remarks'] = level1ApprovalRemarks;
    data['level_2_approval_remarks'] = level2ApprovalRemarks;
    data['attachment_view_file_name'] = attachmentViewFileName;
    data['attachment_dir_file_path'] = attachmentDirFilePath;
    data['date'] = date;
    data['created_datetime'] = createdDatetime;
    data['proposed_account'] = proposedAccount;
    data['proposed_account_id'] = proposedAccountId;
    return data;
  }
}
