class appointmentCalendarResponse {
  List<Appointments>? appointments;
  String? error;
  String? message;
  int? sessionExists;

  appointmentCalendarResponse({
    this.appointments,
    this.error,
    this.message,
    this.sessionExists,
  });

  appointmentCalendarResponse.fromJson(Map<String, dynamic> json) {
    if (json['appointments'] != null) {
      appointments = <Appointments>[];
      json['appointments'].forEach((v) {
        appointments!.add(Appointments.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (appointments != null) {
      data['appointments'] = appointments!.map((v) => v.toJson()).toList();
    }
    data['error'] = error;
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class Appointments {
  String? empId;
  String? id;
  String? leadId;
  String? appDate;
  String? name;
  String? product;
  String? mob1;

  Appointments({
    this.empId,
    this.id,
    this.leadId,
    this.appDate,
    this.name,
    this.product,
    this.mob1,
  });

  Appointments.fromJson(Map<String, dynamic> json) {
    empId = json['emp_id'];
    id = json['id'];
    leadId = json['lead_id'];
    appDate = json['app_date'];
    name = json['name'];
    product = json['product'];
    mob1 = json['mob1'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['emp_id'] = empId;
    data['id'] = id;
    data['lead_id'] = leadId;
    data['app_date'] = appDate;
    data['name'] = name;
    data['product'] = product;
    data['mob1'] = mob1;
    return data;
  }
}
