class LeadListContactPopUpResponse {
  String? error;
  List<Contacts>? contacts;
  String? message;

  LeadListContactPopUpResponse({this.error, this.contacts, this.message});

  LeadListContactPopUpResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['contacts'] != null) {
      contacts = <Contacts>[];
      json['contacts'].forEach((v) {
        contacts!.add(Contacts.fromJson(v));
      });
    }
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    if (contacts != null) {
      data['contacts'] = contacts!.map((v) => v.toJson()).toList();
    }
    data['message'] = message;
    return data;
  }
}

class Contacts {
  String? id;
  String? accId;
  String? name;
  String? salutationName;
  String? mob1;
  String? mob2;
  String? tel;
  String? email;
  String? type;
  String? designation;
  String? date;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;

  Contacts({
    this.id,
    this.accId,
    this.name,
    this.salutationName,
    this.mob1,
    this.mob2,
    this.tel,
    this.email,
    this.type,
    this.designation,
    this.date,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
  });

  Contacts.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    accId = json['acc_id'];
    name = json['name'];
    salutationName = json['salutation_name'];
    mob1 = json['mob1'];
    mob2 = json['mob2'];
    tel = json['tel'];
    email = json['email'];
    type = json['type'];
    designation = json['designation'];
    date = json['date'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['acc_id'] = accId;
    data['name'] = name;
    data['salutation_name'] = salutationName;
    data['mob1'] = mob1;
    data['mob2'] = mob2;
    data['tel'] = tel;
    data['email'] = email;
    data['type'] = type;
    data['designation'] = designation;
    data['date'] = date;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    return data;
  }
}
