import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/ServiceEngineerDashboardProvider.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:provider/provider.dart';
import 'package:generp/screens/screensExports.dart';

class Serviceengineerdashboard extends StatefulWidget {
  const Serviceengineerdashboard({super.key});

  @override
  State<Serviceengineerdashboard> createState() =>
      _ServiceengineerdashboardState();
}

class _ServiceengineerdashboardState extends State<Serviceengineerdashboard> {
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((_) {
      var serviceProvider = Provider.of<Serviceengineerdashboardprovider>(
        context,
        listen: false,
      );
      serviceProvider.LoadTechnicianDashboard(context);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Serviceengineerdashboardprovider>(
      builder: (context, provider, child) {
        return Scaffold(
          resizeToAvoidBottomInset: true,
          backgroundColor: AppColors.scaffold_bg_color,
          appBar: AppBar(
            automaticallyImplyLeading: false,
            title: SizedBox(
              child: Row(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  InkResponse(
                    onTap: () => Navigator.pop(context, true),
                    child: SvgPicture.asset(
                      "assets/svg/appbar_back_button.svg",
                      height: 25,
                    ),
                  ),
                  SizedBox(width: 10),
                  InkResponse(
                    onTap: () => Navigator.pop(context, true),
                    child: Text(
                      "Service Engineer",
                      style: TextStyle(
                        fontSize: 16,
                        height: 1.1,
                        fontFamily: "JakartaSemiBold",
                        color: AppColors.semi_black,
                      ),
                    ),
                  ),
                  Spacer(),
                  Container(
                    height: 25,
                    width: 45,
                    decoration: BoxDecoration(
                      color: Color(0xFFEDF8FF),
                      borderRadius: BorderRadius.circular(20),
                    ),
                    child: Row(
                      mainAxisAlignment: MainAxisAlignment.center,
                      children: [
                        SvgPicture.asset(
                          'assets/svg/engineer_rating.svg',
                          height: 15,
                        ),
                        SizedBox(width: 5),
                        Text(
                          provider.avgRating.toString(),
                          style: TextStyle(fontSize: 14),
                        ),
                      ],
                    ),
                  ),
                ],
              ),
            ),
            // shape: RoundedRectangleBorder(
            //   borderRadius: BorderRadius.vertical(
            //     bottom: Radius.circular(30), // Adjust the radius as needed
            //   ),
            // ),
          ),
          body: SingleChildScrollView(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Container(
                  decoration: BoxDecoration(
                    color: Colors.white,
                    borderRadius: BorderRadius.vertical(
                      bottom: Radius.circular(20),
                    ),
                  ),
                  child: Column(
                    // crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Container(
                        height: 200,
                        decoration: BoxDecoration(
                          image: DecorationImage(
                            image: AssetImage(
                              "assets/svg/service/service_dashboard.png",
                            ),
                            fit: BoxFit.contain,
                          ),
                          gradient: LinearGradient(
                            colors: [Color(0xFFFFFFFF), AppColors.white],
                            begin: Alignment.topCenter,
                            end: Alignment.bottomCenter,
                          ),
                        ),
                      ),

                      GridView.builder(
                        padding: EdgeInsets.symmetric(
                          vertical: 10,
                          horizontal: 10,
                        ),
                        itemCount: 4,
                        shrinkWrap: true,
                        physics: NeverScrollableScrollPhysics(),
                        gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                          crossAxisCount: 2,
                          crossAxisSpacing: 10,
                          mainAxisSpacing: 10,
                          childAspectRatio: 22 / 12,
                        ),
                        itemBuilder: (context, index) {
                          final numbers = [
                            provider.monthlyPaymentCollectionAmount,
                            provider.paymentCollectionWalletBalanceAmount,
                            provider.thisMonthsVisits,
                            provider.todayVisits,
                          ];
                          final names = [
                            "Month \nCollection",
                            "P.C. \nWallet",
                            "Month \nVisits",
                            "Today \nVisits",
                          ];
                          final List<int> colorCodes = [
                            0xFFE7FFE5,
                            0xFFFFFCD5,
                            0xFFF3EDFF,
                            0xFFFFF6F0,
                          ];
                          final List<int> textColorCodes = [
                            0xFF0D9C00,
                            0xFF605C00,
                            0xFF493272,
                            0xFF91481B,
                          ];

                          final assetNames = [
                            "assets/svg/service/month_coll_ic.svg",
                            "assets/svg/service/pc_wallet_ic.svg",
                            "assets/svg/service/month_visit_ic.svg",
                            "assets/svg/service/today_visit_ic.svg",
                          ];
                          return InkResponse(
                            onTap: () {
                              var route;
                              switch (index) {
                                case 0:
                                  route = Monthlycollection();
                                  break;
                                case 1:
                                  route = Pcwallet();
                                  break;
                                case 2:
                                  route = Todaymontlyvisists(
                                    visitType: "Month",
                                  );
                                  break;
                                case 3:
                                  route = Todaymontlyvisists(
                                    visitType: "Today",
                                  );
                                  break;
                              }

                              Navigator.push(
                                context,
                                MaterialPageRoute(builder: (context) => route),
                              );
                            },
                            child: Container(
                              padding: EdgeInsets.only(
                                left: 10,
                                top: 10,
                                bottom: 10,
                                right: 10,
                              ),
                              decoration: BoxDecoration(
                                color: Color(colorCodes[index]),
                                borderRadius: BorderRadius.circular(20),
                              ),
                              child: Column(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  Row(
                                    children: [
                                      if ([0, 1].contains(index)) ...[
                                        Text(
                                          "₹",
                                          style: TextStyle(
                                            fontSize: 14,
                                            color: Color(textColorCodes[index]),
                                          ),
                                        ),
                                      ],
                                      Padding(
                                        padding: EdgeInsets.only(top: 5),
                                        child: Text(
                                          "${numbers[index].toString()}",
                                          style: TextStyle(
                                            fontSize: 20,
                                            color: Color(textColorCodes[index]),
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                  Row(
                                    children: [
                                      Expanded(
                                        flex: 4,
                                        child: Text(
                                          names[index],
                                          style: TextStyle(
                                            fontSize: 14,
                                            color: AppColors.semi_black,
                                          ),
                                        ),
                                      ),
                                      Expanded(
                                        flex: 1,
                                        child: SvgPicture.asset(
                                          assetNames[index],
                                        ),
                                      ),
                                    ],
                                  ),
                                ],
                              ),
                            ),
                          );
                        },
                      ),
                    ],
                  ),
                ),

                Padding(
                  padding: EdgeInsets.only(top: 10, bottom: 5, left: 10),
                  child: Text(
                    "Complaint Status",
                    style: TextStyle(color: AppColors.grey_thick, fontSize: 14),
                  ),
                ),
                InkResponse(
                  onTap: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                        builder: (context) => Pendingcomplaints(),
                      ),
                    );
                  },
                  child: Container(
                    height: 60,
                    margin: EdgeInsets.only(left: 10, right: 10, bottom: 10),
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.circular(20),
                    ),
                    padding: EdgeInsets.symmetric(horizontal: 10, vertical: 15),
                    child: SizedBox(
                      child: Row(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          Expanded(
                            flex: 1,
                            child: Container(
                              height: 50,
                              width: 50,
                              decoration: BoxDecoration(
                                color: Color(0xFFFFE4E2),
                                shape: BoxShape.circle,
                              ),
                              child: Center(
                                child: Text(
                                  "${provider.pendingComplaints}",
                                  textAlign: TextAlign.center,
                                  style: TextStyle(
                                    fontSize: 14,
                                    color: Color(0xFFED3424),
                                  ),
                                ),
                              ),
                            ),
                          ),
                          SizedBox(width: 10),
                          Expanded(
                            flex: 5,
                            child: Text(
                              "Pending Complaints",
                              style: TextStyle(
                                fontSize: 14,
                                color: AppColors.app_blue,
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                ),
                Padding(
                  padding: EdgeInsets.only(top: 10, bottom: 5, left: 10),
                  child: Text(
                    "Nearby Generators",
                    style: TextStyle(color: AppColors.grey_thick, fontSize: 14),
                  ),
                ),
                InkResponse(
                  onTap: () {
                    Navigator.push(
                      context,
                      MaterialPageRoute(
                        builder: (context) => Nearbygenerators(),
                      ),
                    );
                  },
                  child: Container(
                    height: 60,
                    margin: EdgeInsets.symmetric(horizontal: 10, vertical: 0),
                    decoration: BoxDecoration(
                      color: Colors.white,
                      borderRadius: BorderRadius.circular(20),
                    ),

                    child: Row(
                      children: [
                        Expanded(
                          flex: 1,
                          child: Container(
                            height: 35,
                            width: 35,
                            padding: EdgeInsets.all(8.0),

                            decoration: BoxDecoration(
                              color: Color(0xFFEDF8FF),
                              shape: BoxShape.circle,
                            ),
                            child: SvgPicture.asset(
                              "assets/svg/find_generator.svg",
                            ),
                          ),
                        ),
                        Expanded(
                          flex: 4,
                          child: Text(
                            "Find Nearby Generators",
                            style: TextStyle(
                              fontSize: 14,
                              color: AppColors.app_blue,
                            ),
                          ),
                        ),
                      ],
                    ),
                  ),
                ),
              ],
            ),
          ),
        );
      },
    );
  }
}
