import 'dart:io';

import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

import '../../Models/crmModels/GetSegmentOnTeamResponse.dart';
import '../../Models/crmModels/crmLeadDetailsEditAccountViewResponse.dart';
import '../../Notifiers/crmProvider/editCrmAccountDetailsProvider.dart';
import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';
import '../../Utils/dropdownTheme.dart';

class EditAccountDetails extends StatefulWidget {
  final leadID;
  final mode;
  final accountID;
  final companyName;

  const EditAccountDetails({
    super.key,
    required this.leadID,
    required this.mode,
    required this.accountID,
    required this.companyName,
  });

  @override
  State<EditAccountDetails> createState() => _EditAccountDetailsState();
}

class _EditAccountDetailsState extends State<EditAccountDetails> {
  Dropdowntheme ddtheme = Dropdowntheme();
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      final provider = Provider.of<Editcrmaccountdetailsprovider>(
        context,
        listen: false,
      );
      provider.editCompanyNameController.text = widget.companyName!;
      provider.crmLeadDetailsEditAccountAPIFunction(
        context,
        widget.leadID,
        widget.mode,
      );
    });
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<Editcrmaccountdetailsprovider>(
      builder: (context, provider, child) {
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS ? false : true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              appBar: appbar(context, "Edit Account"),
              backgroundColor: AppColors.scaffold_bg_color,
              body: Container(
                padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                margin: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                decoration: BoxDecoration(
                  color: Colors.white,
                  borderRadius: BorderRadius.circular(12.0),
                ),
                child: SingleChildScrollView(
                  child: Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisSize: MainAxisSize.min,
                    children: [
                      textControllerWidget(
                        context,
                        provider.editCompanyNameController,
                        "Name",
                        "Enter Name",
                        provider.onChangedCompanyName,
                        TextInputType.text,
                        false,
                        null,
                      ),
                      errorWidget(context, provider.companyNameError),

                      TextWidget(context, "Team"),
                      DropdownButtonHideUnderline(
                        child: Row(
                          children: [
                            Expanded(
                              child: DropdownButton2<Teams>(
                                hint: Text(
                                  "Select Team",
                                  style: TextStyle(fontSize: 14),
                                ),
                                items:
                                    provider.teamsList
                                        .map(
                                          (slist) => DropdownMenuItem<Teams>(
                                            value: slist,
                                            child: Text(
                                              slist.name!,
                                              style: TextStyle(fontSize: 14),
                                            ),
                                          ),
                                        )
                                        .toList(),
                                value: provider.selectedTeams,
                                onChanged: (Teams? value) {
                                  if (value != null) {
                                    if (provider.teamsList.isNotEmpty) {
                                      provider.selectedTeams = value;
                                      provider.selectedTeamId = value.id!;
                                      provider.selectedTeamValue = value.name!;
                                      provider
                                          .crmLeadListSegmentOnTeamAPIFunction(
                                            context,
                                            widget.mode,
                                            provider.selectedTeamId,
                                          );
                                    }
                                  }
                                },
                                isExpanded: true,
                                buttonStyleData: ddtheme.buttonStyleData,
                                iconStyleData: ddtheme.iconStyleData,
                                menuItemStyleData: ddtheme.menuItemStyleData,
                                dropdownStyleData: ddtheme.dropdownStyleData,
                              ),
                            ),
                          ],
                        ),
                      ),

                      TextWidget(context, "Segment"),
                      DropdownButtonHideUnderline(
                        child: Row(
                          children: [
                            Expanded(
                              child: DropdownButton2<Segments>(
                                hint: Text(
                                  "Select Segment",
                                  style: TextStyle(fontSize: 14),
                                ),
                                items:
                                    provider.segmentsList
                                        .map(
                                          (slist) => DropdownMenuItem<Segments>(
                                            value: slist,
                                            child: Text(
                                              slist.name!,
                                              style: TextStyle(fontSize: 14),
                                            ),
                                          ),
                                        )
                                        .toList(),
                                value: provider.selectedSegments,
                                onChanged: (Segments? value) {
                                  if (value != null) {
                                    if (provider.segmentsList.isNotEmpty) {
                                      provider.selectedSegments = value;
                                      provider.selectedSegmentId = value.id!;
                                      provider.selectedSegmentValue =
                                          value.name!;
                                    }
                                  }
                                },
                                isExpanded: true,
                                buttonStyleData: ddtheme.buttonStyleData,
                                iconStyleData: ddtheme.iconStyleData,
                                menuItemStyleData: ddtheme.menuItemStyleData,
                                dropdownStyleData: ddtheme.dropdownStyleData,
                              ),
                            ),
                          ],
                        ),
                      ),
                      SizedBox(height: 25),
                      InkWell(
                        onTap:
                            provider.isLoading
                                ? null
                                : () {
                                  provider.isLoading = true;
                                  provider
                                      .crmLeadDetailsEditAccountSubmitAPIFunction(
                                        context,
                                        widget.accountID,
                                        provider.selectedSegmentId,
                                        provider.selectedTeamId,
                                      );
                                },
                        child: Container(
                          alignment: Alignment.center,
                          height: 45,
                          margin: EdgeInsets.only(
                            left: 5.0,
                            right: 5.0,
                            top: 5.0,
                            bottom: 5.0,
                          ),
                          decoration: BoxDecoration(
                            color: AppColors.app_blue, //1487C9
                            borderRadius: BorderRadius.circular(14.0),
                          ),
                          child: Center(
                            child:
                                provider.isLoading
                                    ? CircularProgressIndicator.adaptive(
                                      valueColor: AlwaysStoppedAnimation(
                                        AppColors.white,
                                      ),
                                    )
                                    : Text(
                                      "Submit",
                                      textAlign: TextAlign.center,
                                      style: TextStyle(color: Colors.white),
                                    ),
                          ),
                        ),
                      ),
                    ],
                  ),
                ),
              ),
            ),
          ),
        );
      },
    );
  }
}
