import 'dart:io';

import 'package:dotted_line/dotted_line.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:generp/screens/finance/FileViewer.dart';
import 'package:provider/provider.dart';

import '../../Notifiers/financeProvider/paymentRequisitionPaymentsListProvider.dart';

class Transactiondetails extends StatefulWidget {
  final paymentID;
  final type;
  final description;

  const Transactiondetails({
    super.key,
    this.paymentID,
    this.type,
    this.description,
  });

  @override
  State<Transactiondetails> createState() => _TransactiondetailsState();
}

class _TransactiondetailsState extends State<Transactiondetails> {
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var provider = Provider.of<Paymentrequisitionpaymentslistprovider>(
        context,
        listen: false,
      );
      provider.paymentsListDetailsAPI(context, widget.paymentID);
    });
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<Paymentrequisitionpaymentslistprovider>(
      builder: (context, provider, child) {
        var details = provider.paymentDetails;
        return SafeArea(
          top: false,
          bottom: Platform.isIOS ? false : true,
          child: Scaffold(
            resizeToAvoidBottomInset: true,
            appBar: appbarNew(context, "Details",0xFFFFFFFF),
            backgroundColor: AppColors.scaffold_bg_color,
            body: Container(
              margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
              child: SingleChildScrollView(
                child: Container(
                  padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
                  margin: EdgeInsets.symmetric(vertical: 5),
                  decoration: BoxDecoration(
                    color: Colors.white,
                    borderRadius: BorderRadius.circular(16),
                  ),
                  child: Column(
                    children: [
                      Row(
                        mainAxisAlignment: MainAxisAlignment.start,
                        children: [
                          Expanded(
                            flex: 1,
                            child: SizedBox(
                              child:
                                  widget.type == "Credit"
                                      ? SvgPicture.asset(
                                        "assets/svg/finance/debited_filled_ic.svg",
                                        height: 45,
                                        width: 45,
                                        fit: BoxFit.contain,
                                      )
                                      : SvgPicture.asset(
                                        "assets/svg/finance/credited_filled_ic.svg",
                                        height: 45,
                                        width: 45,
                                        fit: BoxFit.contain,
                                      ),
                            ),
                          ),
                          SizedBox(width: 10),
                          Expanded(
                            flex: 5,
                            child: SizedBox(
                              child: Text(
                                details.description == ""
                                    ? widget.description
                                    : details.description ?? "-",
                                maxLines: 2,
                                overflow: TextOverflow.ellipsis,
                                style: TextStyle(
                                  fontFamily: "JakartaRegular",
                                  fontSize: 14,
                                ),
                              ),
                            ),
                          ),
                          SizedBox(width: 10),
                          Expanded(
                            flex: 3,
                            child: Container(
                              height: 45,
                              decoration: BoxDecoration(
                                borderRadius: BorderRadius.circular(10),
                                color:
                                    widget.type == "Credit"
                                        ? Color(0xFFFFEFEF)
                                        : Color(0xFFE7FFE5),
                              ),
                              child: Center(
                                child: Text(
                                  "₹ ${details.amount ?? "-"}",

                                  maxLines: 2,
                                  overflow: TextOverflow.ellipsis,
                                  style: TextStyle(
                                    fontFamily: "JakartaRegular",
                                    fontSize: 14,
                                    color:
                                        widget.type == "Credited"
                                            ? Color(0xFFEF3739)
                                            : Color(0xFF0D9C00),
                                  ),
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(vertical: 7.5),
                        child: Row(
                          children: [
                            Expanded(
                              flex: 3,
                              child: Text(
                                "Payment Summary",
                                style: TextStyle(
                                  fontSize: 14,
                                  fontFamily: "JakartaSemiBold",
                                ),
                              ),
                            ),
                            Expanded(
                              flex: 5,
                              child: DottedLine(
                                dashGapLength: 4,
                                dashGapColor: Colors.white,
                                dashColor: AppColors.grey_semi,
                                dashLength: 2,
                                lineThickness: 0.5,
                              ),
                            ),
                          ],
                        ),
                      ),
                      ...List.generate(6, (j) {
                        final heads = [
                          "Payment Account",
                          "Payment Employee",
                          "Payment ID",
                          "Payment Reference",
                          "Payment Mode",
                          "Payment Date",
                        ];
                        final subHeads = [
                          details.paymentAccountName ?? "-",
                          details.paymentEmployeeName ?? "-",
                          details.id ?? "-",
                          details.paymentReferenceNumber ?? "-",
                          details.mode ?? "-",
                          details.paymentDate ?? "-",
                        ];
                        return Container(
                          padding: EdgeInsets.symmetric(vertical: 3),
                          child: Row(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Expanded(
                                child: Text(
                                  textAlign: TextAlign.left,
                                  heads[j],
                                  style: TextStyle(
                                    fontFamily: "JakartaRegular",
                                    fontSize: 14,
                                    color: AppColors.semi_black,
                                  ),
                                ),
                              ),
                              Expanded(
                                child: Text(
                                  textAlign: TextAlign.right,
                                  subHeads[j] == "" ? "-" :
                                  "${heads[j]=="Payment ID"?"#":""}${subHeads[j]}",
                                  style: TextStyle(
                                    fontSize: 14,
                                    color: Color(0xFF818181),
                                  ),
                                ),
                              ),
                            ],
                          ),
                        );
                      }),

                      Container(
                        padding: EdgeInsets.symmetric(vertical: 7.5),
                        child: Row(
                          children: [
                            Expanded(
                              flex: 3,
                              child: Text(
                                "Receivers Details",
                                style: TextStyle(
                                  fontSize: 14,
                                  fontFamily: "JakartaSemiBold",
                                ),
                              ),
                            ),
                            Expanded(
                              flex: 5,
                              child: DottedLine(
                                dashGapLength: 4,
                                dashGapColor: Colors.white,
                                dashColor: AppColors.grey_semi,
                                dashLength: 2,
                                lineThickness: 0.5,
                              ),
                            ),
                          ],
                        ),
                      ),
                      ...List.generate(7, (j) {
                        final heads = [
                          "Account Name",
                          "Account Holder",
                          "Account Number",
                          "Bank Name",
                          "Bank Branch Name",
                          "Bank IFSC",
                          "UPI ID",
                        ];
                        final subHeads = [
                          details.accountName ?? "-",
                          details.bankAccountHolderName ?? "-",
                          details.bankAccountNumber ?? "-",
                          details.bankName ?? "-",
                          details.bankBranchName ?? "-",
                          details.bankIfscCode ?? "-",
                          details.bankUpiId ?? "-",
                        ];
                        return Container(
                          padding: EdgeInsets.symmetric(vertical: 3),
                          child: Row(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Expanded(
                                child: Text(
                                  textAlign: TextAlign.left,
                                  heads[j],
                                  style: TextStyle(
                                    fontFamily: "JakartaRegular",
                                    fontSize: 14,
                                    color: AppColors.semi_black,
                                  ),
                                ),
                              ),
                              Expanded(
                                child: Text(
                                  textAlign: TextAlign.right,
                                  subHeads[j] == "" ? "-" : subHeads[j],
                                  style: TextStyle(
                                    fontSize: 14,
                                    color: Color(0xFF818181),
                                  ),
                                ),
                              ),
                            ],
                          ),
                        );
                      }),

                      Container(
                        padding: EdgeInsets.symmetric(vertical: 7.5),
                        child: Row(
                          children: [
                            Expanded(
                              flex: 3,
                              child: Text(
                                "Other Details",
                                style: TextStyle(
                                  fontSize: 14,
                                  fontFamily: "JakartaSemiBold",
                                ),
                              ),
                            ),
                            Expanded(
                              flex: 5,
                              child: DottedLine(
                                dashGapLength: 4,
                                dashGapColor: Colors.white,
                                dashColor: AppColors.grey_semi,
                                dashLength: 2,
                                lineThickness: 0.5,
                              ),
                            ),
                          ],
                        ),
                      ),
                      ...List.generate(3, (j) {
                        final heads = [
                          "Payment Attachment",
                          "Description",
                          "Remarks",
                        ];
                        final subHeads = [
                          "View",
                          details.description ?? "-",
                          details.paymentRemarks ?? "-",
                        ];
                        return Container(
                          padding: EdgeInsets.symmetric(vertical: 3),
                          child: Row(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Expanded(
                                child: Text(
                                  textAlign: TextAlign.left,
                                  heads[j],
                                  style: TextStyle(
                                    fontFamily: "JakartaRegular",
                                    fontSize: 14,
                                    color: AppColors.semi_black,
                                  ),
                                ),
                              ),

                              Expanded(
                                child: InkResponse(
                                  onTap: () async {
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => Fileviewer(
                                              fileName:
                                                  details
                                                      .attachmentViewFileName ??
                                                  "",
                                              fileUrl:
                                                  details
                                                      .attachmentDirFilePath ??
                                                  "",
                                            ),
                                      ),
                                    );
                                  },
                                  child: Padding(
                                    padding: const EdgeInsets.all(3.0),
                                    child: Text(
                                      textAlign: TextAlign.right,
                                      subHeads[j] == "" ? "-" : subHeads[j],
                                      style: TextStyle(
                                        fontSize: 14,
                                        color:
                                            subHeads[j] == "View"
                                                ? AppColors.app_blue
                                                : Color(0xFF818181),
                                        decoration:
                                            subHeads[j] == "View"
                                                ? TextDecoration.underline
                                                : TextDecoration.none,
                                        decorationColor: AppColors.app_blue,
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                            ],
                          ),
                        );
                      }),
                    ],
                  ),
                ),
              ),
            ),
          ),
        );
      },
    );
  }
}

///Container(
//               margin: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
//               child: SingleChildScrollView(
//                 child: Container(
//                   padding: EdgeInsets.symmetric(horizontal: 10, vertical: 10),
//                   margin: EdgeInsets.symmetric(vertical: 5),
//                   decoration: BoxDecoration(
//                     color: Colors.white,
//                     borderRadius: BorderRadius.circular(16),
//                   ),
//                   child: Column(
//                     children: [
//                       Row(
//                         mainAxisAlignment: MainAxisAlignment.start,
//                         children: [
//                           Expanded(
//                             flex: 1,
//                             child: SizedBox(
//                               child:
//                                   widget.type == "Credit"
//                                       ? SvgPicture.asset(
//                                         "assets/svg/finance/debited_filled_ic.svg",
//                                         height: 45,
//                                         width: 45,
//                                         fit: BoxFit.contain,
//                                       )
//                                       : SvgPicture.asset(
//                                         "assets/svg/finance/credited_filled_ic.svg",
//                                         height: 45,
//                                         width: 45,
//                                         fit: BoxFit.contain,
//                                       ),
//                             ),
//                           ),
//                           SizedBox(width: 10),
//                           Expanded(
//                             flex: 5,
//                             child: SizedBox(
//                               child: Column(
//                                 crossAxisAlignment: CrossAxisAlignment.start,
//                                 children: [
//                                   Text(
//                                     widget.type == "Credit"
//                                         ? "Debited Amount"
//                                         : "Credited Amount",
//                                     maxLines: 2,
//                                     overflow: TextOverflow.ellipsis,
//                                     style: TextStyle(
//                                       fontFamily: "JakartaMedium",
//                                       fontSize: 12,
//                                     ),
//                                   ),
//                                   RichText(
//                                     textAlign: TextAlign.right,
//                                     maxLines: 1,
//                                     overflow: TextOverflow.ellipsis,
//                                     text: TextSpan(
//                                       children: [
//                                         TextSpan(
//                                           text:
//                                               widget.type == "Credit"
//                                                   ? "-"
//                                                   : "+",
//                                           style: TextStyle(
//                                             color: Color(0xFF2D2D2D),
//                                             fontSize: 13,
//                                             fontFamily: "JakartaRegular",
//                                           ),
//                                         ),
//                                         TextSpan(
//                                           text: "₹${details.description}",
//                                           style: TextStyle(
//                                             color: Color(0xFF2D2D2D),
//                                             fontSize: 13,
//                                             fontFamily: "JakartaMedium",
//                                           ),
//                                         ),
//                                       ],
//                                     ),
//                                   ),
//                                 ],
//                               ),
//                             ),
//                           ),
//                         ],
//                       ),
//                       Divider(thickness: 0.5, color: Color(0xFFd7d7d7)),
//                       ...List.generate(6, (j) {
//                         final headings = [
//                           "ID",
//                           "Date",
//                           "Account",
//                           "Ref Type",
//                           "Payment Remarks",
//                           "Attachment",
//                         ];
//
//                         final subHeadings = [
//                           details.id ?? "-",
//                           details.createdDatetime ?? "-",
//                           details.accountName ?? "-",
//                           details.refType ?? "-",
//                           details.paymentRemarks ?? "-",
//                           "View",
//                         ];
//                         return Container(
//                           padding: EdgeInsets.symmetric(vertical: 5),
//                           child: Row(
//                             crossAxisAlignment: CrossAxisAlignment.start,
//                             children: [
//                               Expanded(
//                                 child: Text(
//                                   headings[j],
//                                   style: TextStyle(
//                                     fontFamily: "JakartaMedium",
//                                     fontSize: 14,
//                                     color: AppColors.semi_black,
//                                   ),
//                                 ),
//                               ),
//                               SizedBox(width: 15),
//                               if (subHeadings[j] == "View") ...[
//                                 Expanded(
//                                   child: InkResponse(
//                                     onTap: () async {
//                                       Navigator.push(
//                                         context,
//                                         MaterialPageRoute(
//                                           builder:
//                                               (context) => Fileviewer(
//                                                 fileName:
//                                                     details
//                                                         .attachmentViewFileName ??
//                                                     "",
//                                                 fileUrl:
//                                                     details
//                                                         .attachmentDirFilePath ??
//                                                     "",
//                                               ),
//                                         ),
//                                       );
//                                     },
//                                     child: Text(
//                                       "${subHeadings[j]}" == ""
//                                           ? "-"
//                                           : subHeadings[j] ?? "-",
//                                       style: TextStyle(
//                                         fontFamily: "JakartaMedium",
//                                         fontSize: 14,
//                                         color: AppColors.app_blue,
//                                         decorationColor: AppColors.app_blue,
//                                         decoration: TextDecoration.underline,
//                                       ),
//                                     ),
//                                   ),
//                                 ),
//                               ] else ...[
//                                 Expanded(
//                                   child: Text(
//                                     "${subHeadings[j]}" == ""
//                                         ? "-"
//                                         : subHeadings[j] ?? "-",
//                                     style: TextStyle(
//                                       fontFamily: "JakartaMedium",
//                                       fontSize: 14,
//                                       color: AppColors.grey_thick,
//                                     ),
//                                   ),
//                                 ),
//                               ],
//                             ],
//                           ),
//                         );
//                       }),
//                     ],
//                   ),
//                 ),
//               ),
//             ),
