import 'dart:io';

import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Notifiers/commonProvider/commonPagesProvider.dart';
import 'package:generp/screens/screensExports.dart';
import 'package:provider/provider.dart';

import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';

class Commondashboard extends StatefulWidget {
  const Commondashboard({super.key});

  @override
  State<Commondashboard> createState() => _CommondashboardState();
}

class _CommondashboardState extends State<Commondashboard> {
  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      var prov = Provider.of<Commonpagesprovider>(context,listen: false);
      prov.commonAccessPagesAPIFunction(context);
    },);
  }

  @override
  Widget build(BuildContext context) {
    return Consumer<Commonpagesprovider>(
      builder: (context,provider,child) {
        final gridPages = provider.accessPages
            .where((page) => page.id != 292 )
            .toList();

        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: SafeArea(
            top: false,
            bottom: Platform.isIOS?false:true,
            child: Scaffold(
              resizeToAvoidBottomInset: true,
              backgroundColor: AppColors.scaffold_bg_color,
              appBar: appbar(context, "Common"),
              body: GridView.builder(
                padding: EdgeInsets.symmetric(vertical: 10, horizontal: 10),
                itemCount: gridPages.length,
                gridDelegate: SliverGridDelegateWithFixedCrossAxisCount(
                  crossAxisCount: 2,
                  crossAxisSpacing: 10,
                  mainAxisSpacing: 10,
                ),
                itemBuilder: (context, index) {
                  final icons = ["comm_ic_1", "comm_ic_2"];
                  return InkResponse(
                    onTap: () {
                      switch (gridPages[index].pageName!) {
                        case "Account List":
                          Navigator.push(
                            context,
                            MaterialPageRoute(builder: (context) => Accountslist()),
                          );
                          break;
                        case "Account Ledger":
                          Navigator.push(
                            context,
                            MaterialPageRoute(builder: (context) => Accountledger()),
                          );
                          break;

                        default:
                          print("111");
                          break;
                      }
                    },
                    child: Container(
                      decoration: BoxDecoration(
                        color: Colors.white,
                        borderRadius: BorderRadius.circular(30),
                      ),
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.center,
                        mainAxisAlignment: MainAxisAlignment.center,
                        children: [
                          SvgPicture.asset("assets/svg/${icons[index]}.svg"),
                          SizedBox(height: 10),
                          Text(gridPages[index].pageName!),
                        ],
                      ),
                    ),
                  );
                },
              ),
              floatingActionButtonLocation: FloatingActionButtonLocation.centerFloat,
              floatingActionButton:provider.accessPages
                  .any((page) => page.id==292)? InkResponse(
                onTap: () {
                  Navigator.push(
                    context,
                    MaterialPageRoute(builder: (context) => Addcommonpayment(from: "Dashboard",)),
                  );
                },
                child: Container(
                  height: 45,
                  alignment: Alignment.center,
                  margin: EdgeInsets.symmetric(horizontal: 10),
                  padding: EdgeInsets.symmetric(horizontal: 10, vertical: 5),
                  decoration: BoxDecoration(
                    color: AppColors.app_blue,
                    borderRadius: BorderRadius.circular(15),
                  ),
                  child: Text(
                    "Add Account",
                    style: TextStyle(
                      fontSize: 15,
                      fontFamily: "JakartaMedium",
                      color: Colors.white,
                    ),
                  ),
                ),
              ):SizedBox(height: 0,),
            ),
          ),
        );
      }
    );
  }
}
