import 'package:flutter/cupertino.dart';
import 'package:flutter/foundation.dart';
import 'package:provider/provider.dart';

import '../../Models/crmModels/GetSegmentOnTeamResponse.dart';
import '../../Models/crmModels/crmLeadDetailsEditAccountViewResponse.dart';
import '../../services/api_calling.dart';
import '../HomeScreenNotifier.dart';

class Editcrmaccountdetailsprovider extends ChangeNotifier {
  TextEditingController editCompanyNameController = TextEditingController();

  List<Teams> _teamsList = [];
  AccountDetails _accountDetails = AccountDetails();
  List<Segments> _segmentsList = [];
  Teams? _selectedTeams;
  Segments? _selectedSegments;

  String? _selectedSegmentId;
  String? _selectedSegmentValue;

  String? _selectedTeamId;
  String? _selectedTeamValue;

  bool _isLoading = true;
  String? _companyNameError;
  String? _selectedTeamError;
  String? _selectedSegmentError;

  bool get isLoading => _isLoading;
  String? get companyNameError => _companyNameError;
  String? get selectedTeamError => _selectedTeamError;
  String? get selectedSegmentError => _selectedSegmentError;

  List<Teams> get teamsList => _teamsList;
  List<Segments> get segmentsList => _segmentsList;
  Teams? get selectedTeams => _selectedTeams;
  Segments? get selectedSegments => _selectedSegments;
  AccountDetails get accountsDetails => _accountDetails;

  String? get selectedTeamId => _selectedTeamId;

  String? get selectedTeamValue => _selectedTeamValue;

  String? get selectedSegmentId => _selectedSegmentId;

  String? get selectedSegmentValue => _selectedSegmentValue;

  set isLoading(bool value) {
    _isLoading = value;
    notifyListeners();
  }

  set companyNameError(String? value) {
    _companyNameError = value;
    notifyListeners();
  }

  set selectedTeamError(String? value) {
    _selectedTeamError = value;
    notifyListeners();
  }

  set selectedSegmentError(String? value) {
    _selectedSegmentError = value;
    notifyListeners();
  }

  set selectedTeams(Teams? value) {
    _selectedTeams = value;
    _selectedTeamId = value!.id!;
    _selectedTeamValue = value.name;
    notifyListeners();
  }

  set selectedSegments(Segments? value) {
    _selectedSegments = value;
    _selectedSegmentId = value!.id!;
    _selectedSegmentValue = value.name;
    notifyListeners();
  }

  set selectedTeamId(String? value) {
    _selectedTeamId = value;
    notifyListeners();
  }

  set selectedTeamValue(String? value) {
    _selectedTeamValue = value;
    notifyListeners();
  }

  set selectedSegmentId(String? value) {
    _selectedSegmentId = value;
    notifyListeners();
  }

  set selectedSegmentValue(String? value) {
    _selectedSegmentValue = value;
    notifyListeners();
  }

  Future<void> crmLeadDetailsEditAccountAPIFunction(
    context,
    leadID,
    mode,
  ) async {
    try {
      var HomeProv = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmLeadDetailsEditAccountViewAPI(
        HomeProv.empId,
        HomeProv.session,
        leadID,
        mode,
      );
      _isLoading = true;
      notifyListeners();
      if (data != null) {
        if (data.error == "0") {
          _teamsList = data.teams!;
          _accountDetails = data.accountDetails!;
          _isLoading = false;
          notifyListeners();
        } else {
          _isLoading = false;
          notifyListeners();
        }
      } else {
        _isLoading = false;
        notifyListeners();
      }
    } catch (e) {
      _isLoading = false;
      notifyListeners();
    }
  }

  Future<void> crmLeadListSegmentOnTeamAPIFunction(
    context,
    mode,
    teamID,
  ) async {
    try {
      var prov = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmLeadListSegmentOnTeamAPI(
        prov.empId,
        prov.session,
        teamID,
      );
      if (data != null) {
        if (data.error == "0") {
          _segmentsList = data.segments!;
          notifyListeners();
        }
      }
    } catch (e) {}
  }

  Future<void> crmLeadDetailsEditAccountSubmitAPIFunction(
    context,
    accountId,
    segmentId,
    teamId,
  ) async {
    try {
      if (!validateForm(context)) {
        return;
      }
      var HomeProv = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmLeadDetailsEditAccountSubmitAPI(
        HomeProv.empId,
        HomeProv.session,
        accountId,
        segmentId,
        teamId,
        editCompanyNameController.text,
      );
      _isLoading = true;
      notifyListeners();
      if (data != null) {
        if (data.error == "0") {
          Navigator.pop(context, true);
          resetValue();
          _isLoading = false;
          notifyListeners();
        } else {
          _isLoading = false;
          notifyListeners();
        }
      } else {
        _isLoading = false;
        notifyListeners();
      }
    } catch (e) {
      _isLoading = false;
      notifyListeners();
    }
  }

  bool validateForm(BuildContext context) {
    // Reset all errors
    _companyNameError = null;

    bool isValid = true;

    if (_selectedTeams == null || _selectedTeamId!.isEmpty) {
      _selectedTeamError = "Please select an account";
      isValid = false;
    }

    if (_selectedSegments == null || _selectedSegmentId!.isEmpty) {
      _selectedSegmentError = "Please select an account";
      isValid = false;
    }

    if (editCompanyNameController.text.trim().isEmpty) {
      _companyNameError = "Please enter Company name";
      isValid = false;
    }

    notifyListeners();
    return isValid;
  }

  onChangedCompanyName(value) {
    _companyNameError = "";
    notifyListeners();
  }

  void resetValue() {
    _isLoading = false;
    editCompanyNameController.clear();
    _selectedSegments = null;
    _selectedTeams = null;
    _selectedTeamId = null;
    _selectedSegmentId = null;
    _selectedTeamValue = null;
    _selectedSegmentValue = null;
  }

  void checkDropDownValues() {
    if (!_segmentsList.contains(_selectedSegments) &&
        _selectedSegments != null) {
      _selectedTeamId = null;
      _selectedTeamValue = null;
    }
    if (!_teamsList.contains(_selectedTeams) && _selectedTeams != null) {
      _selectedSegmentId = null;
      _selectedSegmentValue = null;
    }
  }
}
