import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:provider/provider.dart';

import '../../Models/crmModels/GetDistrictOnStateResponse.dart';
import '../../Models/crmModels/GetSubLocOnDistrictResponse.dart';
import '../../Models/crmModels/LeadListViewResponse.dart' show Employees;
import '../../Models/crmModels/crmProspectDetailsEditAccountViewResponse.dart';
import '../../Utils/commonServices.dart';
import '../../services/api_calling.dart';
import '../HomeScreenNotifier.dart';

class Crmeditprospectaccountprovider extends ChangeNotifier {
  TextEditingController editCompanyNameController = TextEditingController();
  TextEditingController editSalutationNameController = TextEditingController();
  TextEditingController pincodeController = TextEditingController();
  TextEditingController addressController = TextEditingController();
  TextEditingController searchController = TextEditingController();

  String? salutationError;

  String? companyNameError;

  String? pincodeError;

  String? addressError;
  List<Employees> _employeesList = [];
  List<Districts> _districtsList = [];
  List<SubLocations> _subLocationsList = [];
  List<String> _salutationsList = [];
  List<States> _statesList = [];
  AccountDetails _accountDetails = AccountDetails();
  Employees? _selectedEmployees;
  States? _selectedStates;
  Districts? _selectedDistricts;
  SubLocations? _selectedSubLocations;

  String? _selectedSalutation;

  String? _selectedEmployeeId;
  String? _selectedEmployeeValue;

  String? _selectedStateId;
  String? _selectedStateValue;

  String? _selectedDistrictId;
  String? _selectedDistrictValue;

  String? _selectedSubLocationId;
  String? _selectedSubLocationValue;

  bool _isLoading = false;

  bool get isLoading => _isLoading;

  List<Employees> get employeesList => _employeesList;

  String? get selectedSalutation => _selectedSalutation;

  String? get selectedEmployeeId => _selectedEmployeeId;

  String? get selectedEmployeeValue => _selectedEmployeeValue;
  List<String> get salutationList => _salutationsList;
  List<States> get statesList => _statesList;
  List<Districts> get districtsList => _districtsList;

  List<SubLocations> get subLocationsList => _subLocationsList;
  AccountDetails get accountDetails => _accountDetails;

  Employees? get selectedEmployees => _selectedEmployees;

  States? get selectedStates => _selectedStates;

  Districts? get selectedDistricts => _selectedDistricts;

  SubLocations? get selectedSubLocations => _selectedSubLocations;

  String? get selectedStateId => _selectedStateId;

  String? get selectedStateValue => _selectedStateValue;

  String? get selectedDistrictId => _selectedDistrictId;

  String? get selectedDistrictValue => _selectedDistrictValue;

  String? get selectedSubLocationId => _selectedSubLocationId;

  String? get selectedSubLocationValue => _selectedSubLocationValue;

  set isLoading(bool value) {
    _isLoading = value;
    notifyListeners();
  }

  set selectedEmployees(Employees? value) {
    _selectedEmployees = value;
    _selectedEmployeeId = value!.id!;
    _selectedEmployeeValue = value.name;
    notifyListeners();
  }

  set selectedStates(States? value) {
    _selectedStates = value;
    _selectedStateId = value!.id!;
    _selectedStateValue = value.name;
    notifyListeners();
  }

  set selectedDistricts(Districts? value) {
    _selectedDistricts = value;
    _selectedDistrictId = value!.id!;
    _selectedDistrictValue = value.district;
    notifyListeners();
  }

  set selectedSubLocations(SubLocations? value) {
    _selectedSubLocations = value;
    _selectedSubLocationId = value!.id!;
    _selectedSubLocationValue = value.subLocality;
    notifyListeners();
  }

  set selectedSalutation(String? value) {
    _selectedSalutation = value;
    notifyListeners();
  }

  set selectedStateId(String? value) {
    _selectedStateId = value;
    notifyListeners();
  }

  set selectedStateValue(String? value) {
    _selectedStateValue = value;
    notifyListeners();
  }

  set selectedEmployeeId(String? value) {
    _selectedEmployeeId = value;
    notifyListeners();
  }

  set selectedEmployeeValue(String? value) {
    _selectedEmployeeValue = value;
    notifyListeners();
  }

  set selectedDistrictId(String? value) {
    _selectedDistrictId = value;
    notifyListeners();
  }

  set selectedDistrictValue(String? value) {
    _selectedDistrictValue = value;
    notifyListeners();
  }

  set selectedSubLocationId(String? value) {
    _selectedSubLocationId = value;
    notifyListeners();
  }

  set selectedSubLocationValue(String? value) {
    _selectedSubLocationValue = value;
    notifyListeners();
  }

  Future<void> crmLeadListViewAPIFunction(context, mode) async {
    try {
      var HomeProv = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmLeadListViewAPI(
        HomeProv.empId,
        HomeProv.session,
        mode,
      );
      if (data != null) {
        print(data.error);
        if (data.error == "0") {
          _employeesList = data.employees!;
          notifyListeners();
        }
      }
    } catch (e) {}
  }

  Future<void> crmProspectDetailsEditAccountViewAPIFunction(
    context,
    accID,
  ) async {
    try {
      var prov = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmProspectDetailsEditAccountViewAPI(
        prov.empId,
        prov.session,
        accID,
      );
      _isLoading = true;
      notifyListeners();
      if (data != null) {
        if (data.error == "0") {
          _accountDetails = data.accountDetails!;
          _statesList = data.states ?? [];
          _salutationsList = data.salutations ?? [];
          _isLoading = false;
          notifyListeners();
        } else {
          _isLoading = false;
          notifyListeners();
        }
      } else {
        _isLoading = false;
        notifyListeners();
      }
    } catch (e) {
      _isLoading = false;
      notifyListeners();
    }
  }

  Future<void> crmProspectDetailsEditAccountSubmitAPIFunction(
    context,

    accID,
    salutation,
    stateID,
    districtID,
    subLocalityID,
  ) async {
    try {
      var prov = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmProspectDetailsEditAccountSubmitAPI(
        prov.empId,
        prov.session,
        accID,
        editCompanyNameController.text,
        salutation,
        stateID,
        districtID,
        subLocalityID,
        pincodeController.text,
        addressController.text,
      );
      _isLoading = true;
      notifyListeners();
      if (data != null) {
        if (data.error == "0") {
          _isLoading = false;
          Navigator.pop(context, true);
          toast(context, data.message);
          resetAll();
          _isLoading = false;
          notifyListeners();
        } else {
          _isLoading = false;
          notifyListeners();
        }
      } else {
        _isLoading = false;
        notifyListeners();
      }
    } catch (e) {
      _isLoading = false;
      notifyListeners();
    }
  }

  Future<void> crmLeadListDistrictsOnStateAPIFunction(
    context,
    mode,
    stateID,
  ) async {
    try {
      var prov = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmDistrictsOnStateAPI(
        prov.empId,
        prov.session,
        stateID,
      );
      if (data != null) {
        if (data.error == "0") {
          _districtsList = data.districts!;
          notifyListeners();
        }
      }
    } catch (e) {}
  }

  Future<void> crmLeadListSubLocOnDistrictAPIFunction(
    context,
    mode,
    districtID,
  ) async {
    try {
      var prov = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmSubLocOnDistrictAPI(
        prov.empId,
        prov.session,
        districtID,
      );
      if (data != null) {
        if (data.error == "0") {
          _subLocationsList = data.subLocations!;
          notifyListeners();
        }
      }
    } catch (e) {}
  }

  Future<void> crmProspectDetailsTransferAccountAPIFunction(
    context,
    accID,
    transferEmpID,
  ) async {
    try {
      var prov = Provider.of<HomescreenNotifier>(context, listen: false);
      final data = await ApiCalling.crmProspectDetailsTransferAccountAPI(
        prov.empId,
        prov.session,
        accID,
        transferEmpID,
      );
      _isLoading = true;
      notifyListeners();
      if (data != null) {
        if (data.error == "0") {
          _isLoading = false;
          Navigator.pop(context, true);
          toast(context, data.message);
          resetAll();
          _isLoading = false;
          notifyListeners();
        } else {
          _isLoading = false;
          notifyListeners();
        }
      } else {
        _isLoading = false;
        notifyListeners();
      }
    } catch (e) {
      _isLoading = false;
      notifyListeners();
    }
  }

  void onChangeSalutation(value) {
    salutationError = "";
    notifyListeners();
  }

  void onChangeCompanyName(value) {
    companyNameError = "";
    notifyListeners();
  }

  void onChangePincode(value) {
    pincodeError = "";
    notifyListeners();
  }

  void onChangeAddress(value) {
    addressError = "";
    notifyListeners();
  }

  void resetAll() {
    editCompanyNameController.clear();
    editSalutationNameController.clear();
    pincodeController.clear();
    addressController.clear();
    searchController.clear();
    salutationError = null;

    companyNameError = null;

    pincodeError = null;

    addressError = null;
    notifyListeners();
    _selectedEmployees = null;
    _selectedEmployeeId = null;
    _selectedEmployeeValue = null;
    _selectedStates = null;
    _selectedDistricts = null;
    _selectedSubLocations = null;
    _selectedStateId = null;
    _selectedDistrictId = null;
    _selectedSubLocationId = null;
    _selectedDistrictValue = null;
    _selectedStateValue = null;
    _selectedSubLocationValue = null;
    _selectedSalutation = null;
    checkDropDownValues();
    notifyListeners();
  }

  void checkDropDownValues() {
    if (!_salutationsList.contains(_selectedSalutation) &&
        _selectedSalutation != null) {
      _selectedSalutation = null;
    }
    if (!_employeesList.contains(_selectedEmployees) &&
        _selectedEmployees != null) {
      _selectedEmployeeId = null;
      _selectedEmployeeValue = null;
    }
    if (!_districtsList.contains(_selectedDistricts) &&
        _selectedDistricts != null) {
      _selectedDistrictId = null;
      _selectedDistrictValue = null;
    }
    if (!_statesList.contains(_selectedStates) && _selectedStates != null) {
      _selectedStateId = null;
      _selectedStateValue = null;
    }
    if (!_subLocationsList.contains(_selectedSubLocations) &&
        _selectedSubLocations != null) {
      _selectedSubLocationId = null;
      _selectedSubLocationValue = null;
    }
    notifyListeners();
  }
}
