class CasualLeaveHistoryResponse {
  List<CasualLeaveHistory>? casualLeaveHistory;
  String? error;
  String? message;
  int? sessionExists;

  CasualLeaveHistoryResponse(
      {this.casualLeaveHistory, this.error, this.message, this.sessionExists});

  CasualLeaveHistoryResponse.fromJson(Map<String, dynamic> json) {
    if (json['casual_leave_history'] != null) {
      casualLeaveHistory = <CasualLeaveHistory>[];
      json['casual_leave_history'].forEach((v) {
        casualLeaveHistory!.add(new CasualLeaveHistory.fromJson(v));
      });
    }
    error = json['error'];
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    if (this.casualLeaveHistory != null) {
      data['casual_leave_history'] =
          this.casualLeaveHistory!.map((v) => v.toJson()).toList();
    }
    data['error'] = this.error;
    data['message'] = this.message;
    data['session_exists'] = this.sessionExists;
    return data;
  }
}

class CasualLeaveHistory {
  String? des;
  String? type;
  String? cnt;
  String? year;

  CasualLeaveHistory({this.des, this.type, this.cnt, this.year});

  CasualLeaveHistory.fromJson(Map<String, dynamic> json) {
    des = json['des'];
    type = json['type'];
    cnt = json['cnt'];
    year = json['year'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = new Map<String, dynamic>();
    data['des'] = this.des;
    data['type'] = this.type;
    data['cnt'] = this.cnt;
    data['year'] = this.year;
    return data;
  }
}
