class paymentRequisitionDetailsResponse {
  RequestDetails? requestDetails;
  PaymentDetails? paymentDetails;
  String? error;
  String? message;

  paymentRequisitionDetailsResponse({
    this.requestDetails,
    this.paymentDetails,
    this.error,
    this.message,
  });

  paymentRequisitionDetailsResponse.fromJson(Map<String, dynamic> json) {
    requestDetails =
        json['request_details'] != null
            ? RequestDetails.fromJson(json['request_details'])
            : null;
    paymentDetails =
        json['payment_details'] != null
            ? PaymentDetails.fromJson(json['payment_details'])
            : null;
    error = json['error'];
    message = json['message'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    if (requestDetails != null) {
      data['request_details'] = requestDetails!.toJson();
    }
    if (paymentDetails != null) {
      data['payment_details'] = paymentDetails!.toJson();
    }
    data['error'] = error;
    data['message'] = message;
    return data;
  }
}

class RequestDetails {
  String? id;
  String? isProcessedPaymentRequest;
  String? accountId;
  String? accountName;
  String? branch;
  String? requestingPurpose;
  String? transDis;
  String? description;
  String? amount;
  String? formattedAmount;
  String? requestedAmount;
  String? requestMode;
  String? status;
  String? createdEmployee;
  String? level1Employee;
  String? level2Employee;
  String? level1ApprovalRemarks;
  String? level2ApprovalRemarks;
  String? attachmentViewFileName;
  String? attachmentDirFilePath;
  String? date;
  String? createdDatetime;
  String? updatedDatetime;
  String? proposedAccount;
  String? proposedAccountId;
  String? bankName;
  String? bankBranchname;
  String? bankIfscCode;
  String? bankAccountHolderName;
  String? bankAccountNumber;
  String? bankUpiId;

  RequestDetails({
    this.id,
    this.isProcessedPaymentRequest,
    this.accountId,
    this.accountName,
    this.branch,
    this.requestingPurpose,
    this.transDis,
    this.description,
    this.amount,
    this.formattedAmount,
    this.requestedAmount,
    this.requestMode,
    this.status,
    this.createdEmployee,
    this.level1Employee,
    this.level2Employee,
    this.level1ApprovalRemarks,
    this.level2ApprovalRemarks,
    this.attachmentViewFileName,
    this.attachmentDirFilePath,
    this.date,
    this.createdDatetime,
    this.updatedDatetime,
    this.proposedAccount,
    this.proposedAccountId,
    this.bankName,
    this.bankBranchname,
    this.bankIfscCode,
    this.bankAccountHolderName,
    this.bankAccountNumber,
    this.bankUpiId,
  });

  RequestDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    isProcessedPaymentRequest = json['is_processed_payment_request'];
    accountId = json['account_id'];
    accountName = json['account_name'];
    branch = json['branch'];
    requestingPurpose = json['requesting_purpose'];
    transDis = json['trans_dis'];
    description = json['description'];
    amount = json['amount'];
    formattedAmount = json['formatted_amount'];
    requestedAmount = json['requested_amount'];
    requestMode = json['request_mode'];
    status = json['status'];
    createdEmployee = json['created_employee'];
    level1Employee = json['level1_employee'];
    level2Employee = json['level2_employee'];
    level1ApprovalRemarks = json['level_1_approval_remarks'];
    level2ApprovalRemarks = json['level_2_approval_remarks'];
    attachmentViewFileName = json['attachment_view_file_name'];
    attachmentDirFilePath = json['attachment_dir_file_path'];
    date = json['date'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    proposedAccount = json['proposed_account'];
    proposedAccountId = json['proposed_account_id'];
    bankName = json['bank_name'];
    bankBranchname = json['bank_branch_name'];
    bankIfscCode = json['bank_ifsc_code'];
    bankAccountHolderName = json['bank_account_holder_name'];
    bankAccountNumber = json['bank_account_number'];
    bankUpiId = json['bank_upi_id'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['is_processed_payment_request'] = isProcessedPaymentRequest;
    data['account_id'] = accountId;
    data['account_name'] = accountName;
    data['branch'] = branch;
    data['requesting_purpose'] = requestingPurpose;
    data['trans_dis'] = transDis;
    data['description'] = description;
    data['amount'] = amount;
    data['formatted_amount'] = formattedAmount;
    data['requested_amount'] = requestedAmount;
    data['request_mode'] = requestMode;
    data['status'] = status;
    data['created_employee'] = createdEmployee;
    data['level1_employee'] = level1Employee;
    data['level2_employee'] = level2Employee;
    data['level_1_approval_remarks'] = level1ApprovalRemarks;
    data['level_2_approval_remarks'] = level2ApprovalRemarks;
    data['attachment_view_file_name'] = attachmentViewFileName;
    data['attachment_dir_file_path'] = attachmentDirFilePath;
    data['date'] = date;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['proposed_account'] = proposedAccount;
    data['proposed_account_id'] = proposedAccountId;
    data['bank_name'] = bankName;
    data['bank_branch_name'] = bankBranchname;
    data['bank_ifsc_code'] = bankIfscCode;
    data['bank_account_holder_name'] = bankAccountHolderName;
    data['bank_account_number'] = bankAccountNumber;
    data['bank_upi_id'] = bankUpiId;
    return data;
  }
}

class PaymentDetails {
  String? id;
  String? refType;
  String? refId;
  String? paymentAccountId;
  String? accountId;
  String? paymentModeId;
  String? amount;

  String? bankName;
  String? bankBranchName;
  String? bankIfscCode;
  String? bankAccountHolderName;
  String? bankAccountNumber;
  String? bankUpiId;
  String? attachmentDirFilePath;
  String? attachmentViewFileName;
  String? description;
  String? paymentReferenceNumber;
  String? createdEmployeeId;
  String? paymentDate;
  String? paymentRemarks;
  String? isExists;
  String? createdDatetime;
  String? updatedDatetime;
  String? accountName;
  String? paymentAccountName;
  String? paymentEmployeeName;
  String? mode;

  PaymentDetails({
    this.id,
    this.refType,
    this.refId,
    this.paymentAccountId,
    this.accountId,
    this.paymentModeId,
    this.amount,

    this.bankName,
    this.bankBranchName,
    this.bankIfscCode,
    this.bankAccountHolderName,
    this.bankAccountNumber,
    this.bankUpiId,
    this.attachmentDirFilePath,
    this.attachmentViewFileName,
    this.description,
    this.paymentReferenceNumber,
    this.createdEmployeeId,
    this.paymentDate,
    this.paymentRemarks,
    this.isExists,
    this.createdDatetime,
    this.updatedDatetime,
    this.accountName,
    this.paymentAccountName,
    this.paymentEmployeeName,
    this.mode,
  });

  PaymentDetails.fromJson(Map<String, dynamic> json) {
    id = json['id'];
    refType = json['ref_type'];
    refId = json['ref_id'];
    paymentAccountId = json['payment_account_id'];
    accountId = json['account_id'];
    paymentModeId = json['payment_mode_id'];
    amount = json['amount'];

    bankName = json['bank_name'];
    bankBranchName = json['bank_branch_name'];
    bankIfscCode = json['bank_ifsc_code'];
    bankAccountHolderName = json['bank_account_holder_name'];
    bankAccountNumber = json['bank_account_number'];
    bankUpiId = json['bank_upi_id'];
    attachmentDirFilePath = json['attachment_dir_file_path'];
    attachmentViewFileName = json['attachment_view_file_name'];
    description = json['description'];
    paymentReferenceNumber = json['payment_reference_number'];
    createdEmployeeId = json['created_employee_id'];
    paymentDate = json['payment_date'];
    paymentRemarks = json['payment_remarks'];
    isExists = json['is_exists'];
    createdDatetime = json['created_datetime'];
    updatedDatetime = json['updated_datetime'];
    accountName = json['account_name'];
    paymentAccountName = json['payment_account_name'];
    paymentEmployeeName = json['payment_employee_name'];
    mode = json['mode'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['id'] = id;
    data['ref_type'] = refType;
    data['ref_id'] = refId;
    data['payment_account_id'] = paymentAccountId;
    data['account_id'] = accountId;
    data['payment_mode_id'] = paymentModeId;
    data['amount'] = amount;
    data['bank_name'] = bankName;
    data['bank_branch_name'] = bankBranchName;
    data['bank_ifsc_code'] = bankIfscCode;
    data['bank_account_holder_name'] = bankAccountHolderName;
    data['bank_account_number'] = bankAccountNumber;
    data['bank_upi_id'] = bankUpiId;
    data['attachment_dir_file_path'] = attachmentDirFilePath;
    data['attachment_view_file_name'] = attachmentViewFileName;
    data['description'] = description;
    data['payment_reference_number'] = paymentReferenceNumber;
    data['created_employee_id'] = createdEmployeeId;
    data['payment_date'] = paymentDate;
    data['payment_remarks'] = paymentRemarks;
    data['is_exists'] = isExists;
    data['created_datetime'] = createdDatetime;
    data['updated_datetime'] = updatedDatetime;
    data['account_name'] = accountName;
    data['payment_account_name'] = paymentAccountName;
    data['payment_employee_name'] = paymentEmployeeName;
    data['mode'] = mode;
    return data;
  }
}
