class crmDashboardFollowUpResponse {
  String? error;
  List<FollowupLists>? followupLists;
  String? message;
  int? sessionExists;

  crmDashboardFollowUpResponse({
    this.error,
    this.followupLists,
    this.message,
    this.sessionExists,
  });

  crmDashboardFollowUpResponse.fromJson(Map<String, dynamic> json) {
    error = json['error'];
    if (json['followup_lists'] != null) {
      followupLists = <FollowupLists>[];
      json['followup_lists'].forEach((v) {
        followupLists!.add(FollowupLists.fromJson(v));
      });
    }
    message = json['message'];
    sessionExists = json['session_exists'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['error'] = error;
    if (followupLists != null) {
      data['followup_lists'] = followupLists!.map((v) => v.toJson()).toList();
    }
    data['message'] = message;
    data['session_exists'] = sessionExists;
    return data;
  }
}

class FollowupLists {
  String? aname;
  String? appdate;
  String? atype;
  String? anote;
  String? leadid;
  String? lstatus;
  String? lempid;
  String? aid;

  FollowupLists({
    this.aname,
    this.appdate,
    this.atype,
    this.anote,
    this.leadid,
    this.lstatus,
    this.lempid,
    this.aid,
  });

  FollowupLists.fromJson(Map<String, dynamic> json) {
    aname = json['aname'];
    appdate = json['appdate'];
    atype = json['atype'];
    anote = json['anote'];
    leadid = json['leadid'];
    lstatus = json['lstatus'];
    lempid = json['lempid'];
    aid = json['aid'];
  }

  Map<String, dynamic> toJson() {
    final Map<String, dynamic> data = <String, dynamic>{};
    data['aname'] = aname;
    data['appdate'] = appdate;
    data['atype'] = atype;
    data['anote'] = anote;
    data['leadid'] = leadid;
    data['lstatus'] = lstatus;
    data['lempid'] = lempid;
    data['aid'] = aid;
    return data;
  }
}
