import 'dart:io';

import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dropdown_button2/dropdown_button2.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/Models/crmModels/GetDistrictOnStateResponse.dart';
import 'package:generp/Models/crmModels/GetSegmentOnTeamResponse.dart';
import 'package:generp/Models/crmModels/GetSourceOnReferenceResponse.dart';
import 'package:generp/Models/crmModels/GetSubLocOnDistrictResponse.dart';
import 'package:generp/Models/crmModels/LeadListViewResponse.dart';
import 'package:generp/Notifiers/crmProvider/LeadListProvider.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:provider/provider.dart';
import 'package:generp/screens/screensExports.dart';

import '../../Utils/app_colors.dart';
import '../../Utils/commonWidgets.dart';
import '../../Utils/dropdownTheme.dart';
import '../commonDateRangeFilter.dart';

class LeadlistbymodeOld extends StatefulWidget {
  final pageTitleName;
  final mode;
  final filter;

  const LeadlistbymodeOld({
    super.key,
    required this.pageTitleName,
    required this.mode,
    this.filter,
  });

  @override
  State<LeadlistbymodeOld> createState() => _LeadlistbymodeOldState();
}

class _LeadlistbymodeOldState extends State<LeadlistbymodeOld> {
  Dropdowntheme ddtheme = Dropdowntheme();
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((timeStamp) {
      final provider = Provider.of<Leadlistprovider>(context, listen: false);
      provider.crmLeadListViewAPIFunction(context, widget.mode);
      if (widget.filter != null) {
        provider.crmLeadListAPIFunction(
          context,
          widget.mode,
          "",
          widget.filter!.status,
          widget.filter!.openStatus,
          "",
          "",
          "",
          "",
        );
      } else {
        provider.crmLeadListAPIFunction(
          context,
          widget.mode,
          "",
          "",
          "",
          "",
          "",
          "",
          "",
        );
      }
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () => onBackPressed(context),
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer<Leadlistprovider>(
      builder: (context, provider, child) {
        final crmLists = provider.crmLeadList;
        return Scaffold(
          resizeToAvoidBottomInset: true,
          appBar: appbar2(
            context,
            widget.pageTitleName,
            provider.resetForm,
            Row(
              children: [
                InkResponse(
                  onTap: () async {
                    _showFilterSheet(context);
                  },
                  child: SvgPicture.asset(
                    "assets/svg/filter_ic.svg",
                    height: 25,
                  ),
                ),
              ],
            ),
          ),
          backgroundColor: AppColors.scaffold_bg_color,
          body:
              provider.isLoading
                  ? Center(
                    child: CircularProgressIndicator.adaptive(
                      valueColor: AlwaysStoppedAnimation<Color>(
                        AppColors.app_blue,
                      ),
                    ),
                  )
                  : crmLists.isNotEmpty
                  ? SizedBox(
                    child: Scrollbar(
                      thumbVisibility: false,
                      child: ListView.builder(
                        itemCount: crmLists.length,
                        shrinkWrap: true,
                        physics: AlwaysScrollableScrollPhysics(),
                        itemBuilder: (context, index) {
                          if (crmLists.isEmpty) {
                            return SizedBox(
                              child: Center(child: Text("No Data Available")),
                            );
                          }
                          return Container(
                            padding: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 10,
                            ),
                            margin: EdgeInsets.symmetric(
                              horizontal: 10,
                              vertical: 10,
                            ),
                            decoration: BoxDecoration(
                              color: Colors.white,
                              borderRadius: BorderRadius.circular(16),
                            ),
                            child: Column(
                              children: [
                                Row(
                                  children: [
                                    Expanded(
                                      flex: 1,
                                      child: Container(
                                        height: 50,
                                        width: 35,
                                        padding: EdgeInsets.all(8.0),
                                        decoration: BoxDecoration(
                                          color: Color(0xFFE6F6FF),
                                          borderRadius: BorderRadius.circular(
                                            8,
                                          ),
                                        ),
                                        child: SvgPicture.asset(
                                          "assets/svg/se_block_head.svg",
                                        ),
                                      ),
                                    ),
                                    SizedBox(width: 10),
                                    Expanded(
                                      flex: 4,
                                      child: SizedBox(
                                        child: Column(
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            Text(
                                              crmLists[index].company!,
                                              style: TextStyle(
                                                fontFamily: "JakartaMedium",
                                                fontSize: 14,
                                                color: AppColors.semi_black,
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                    Expanded(
                                      flex: 2,
                                      child: Container(
                                        padding: EdgeInsets.symmetric(
                                          horizontal: 5,
                                          vertical: 10,
                                        ),
                                        decoration: BoxDecoration(
                                          borderRadius: BorderRadius.circular(
                                            8,
                                          ),
                                          color: Color(0xFFE3FFE0),
                                        ),
                                        child: Center(
                                          child: Text(
                                            crmLists[index].status!,
                                            textAlign: TextAlign.center,
                                            style: TextStyle(
                                              fontFamily: "JakartaMedium",
                                              fontSize: 14,
                                              color: Color(0xFF0D9C00),
                                            ),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                                Divider(
                                  thickness: 0.5,
                                  color: Color(0xFFD7D7D7),
                                ),
                                ...List.generate(4, (j) {
                                  final headings = [
                                    "Account Manager",
                                    "Contact Person",
                                    "Product",
                                    "Open Status",
                                  ];

                                  final subHeadings = [
                                    crmLists[index].accman,
                                    crmLists[index].cname,
                                    crmLists[index].product,
                                    crmLists[index].openStatus,
                                  ];
                                  return Container(
                                    padding: EdgeInsets.symmetric(vertical: 5),
                                    child: Row(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.start,
                                      children: [
                                        Expanded(
                                          child: Text(
                                            headings[j],
                                            style: TextStyle(
                                              fontFamily: "JakartaMedium",
                                              fontSize: 14,
                                              color: AppColors.semi_black,
                                            ),
                                          ),
                                        ),
                                        Expanded(
                                          child: Text(
                                            subHeadings[j] ?? "-",
                                            style: TextStyle(
                                              fontSize: 14,
                                              color: Color(0xFF818181),
                                            ),
                                          ),
                                        ),
                                      ],
                                    ),
                                  );
                                }),
                                InkResponse(
                                  onTap: () async {
                                    Navigator.push(
                                      context,
                                      MaterialPageRoute(
                                        builder:
                                            (context) => LeadDetailsByMode(
                                              pageTitleName:
                                                  widget.pageTitleName,
                                              mode: widget.mode,
                                              leadId:
                                                  provider
                                                      .crmLeadList[index]
                                                      .leadid,
                                            ),
                                      ),
                                    );
                                  },
                                  child: Container(
                                    padding: EdgeInsets.symmetric(vertical: 5),
                                    child: Row(
                                      crossAxisAlignment:
                                          CrossAxisAlignment.center,
                                      mainAxisAlignment:
                                          MainAxisAlignment.start,
                                      children: [
                                        Text(
                                          "View Details",
                                          style: TextStyle(
                                            fontFamily: "JakartaMedium",
                                            fontSize: 14,
                                            color: AppColors.app_blue,
                                          ),
                                        ),
                                        SizedBox(width: 5),
                                        SvgPicture.asset(
                                          "assets/svg/next_button.svg",
                                        ),
                                      ],
                                    ),
                                  ),
                                ),
                              ],
                            ),
                          );
                        },
                      ),
                    ),
                  )
                  : Emptywidget(context),
        );
      },
    );
  }

  Future<void> _showFilterSheet(BuildContext context) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      backgroundColor: Colors.white,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Consumer<Leadlistprovider>(
                builder: (context, provider, child) {
                  return Container(
                    margin: EdgeInsets.only(
                      bottom: 15,
                      left: 15,
                      right: 15,
                      top: 10,
                    ),
                    padding: EdgeInsets.only(
                      bottom: MediaQuery.of(context).viewInsets.bottom,
                    ),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        mainAxisSize: MainAxisSize.min,
                        children: [
                          SizedBox(height: 15),
                          Row(
                            children: [
                              Expanded(
                                child: Text(
                                  "Filter",
                                  style: TextStyle(
                                    color: AppColors.app_blue,
                                    fontSize: 14,
                                  ),
                                ),
                              ),
                            ],
                          ),
                          textControllerWidget(
                            context,
                            provider.sLeadIDController,
                            "Lead ID",
                            "Enter Lead ID",
                            provider.onChangedLeadId,
                            TextInputType.text,
                            false,
                            null,
                          ),
                          if (widget.mode != "executive") ...[
                            TextWidget(context, "Employee"),
                            DropdownButtonHideUnderline(
                              child: Row(
                                children: [
                                  Expanded(
                                    child: DropdownButton2<Employees>(
                                      hint: Text(
                                        "Select Source",
                                        style: TextStyle(fontSize: 14),
                                      ),
                                      items:
                                          provider.employeesList
                                              .map(
                                                (slist) =>
                                                    DropdownMenuItem<Employees>(
                                                      value: slist,
                                                      child: Text(
                                                        slist.name!,
                                                        style: TextStyle(
                                                          fontSize: 14,
                                                        ),
                                                      ),
                                                    ),
                                              )
                                              .toList(),
                                      value:
                                          provider.employeesList.contains(
                                                provider.selectedEmployee,
                                              )
                                              ? provider.selectedEmployee
                                              : null,

                                      // value: provider.selectedEmployees,
                                      onChanged: (Employees? value) {
                                        if (value != null) {
                                          if (provider
                                              .employeesList
                                              .isNotEmpty) {
                                            provider.selectedEmployee = value;
                                            provider.selectedEmployeeId =
                                                value.id!;
                                            provider.selectedEmployeeValue =
                                                value.name!;
                                            provider
                                                .crmLeadListSourceOnReferenceAPIFunction(
                                                  context,
                                                  widget.mode,
                                                  provider.selectedSourceId,
                                                );
                                          }
                                        }
                                      },
                                      isExpanded: true,
                                      buttonStyleData: ddtheme.buttonStyleData,
                                      iconStyleData: ddtheme.iconStyleData,
                                      menuItemStyleData:
                                          ddtheme.menuItemStyleData,
                                      dropdownStyleData:
                                          ddtheme.dropdownStyleData,
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                          TextWidget(context, "Lead Status"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<String>(
                                    hint: Text(
                                      "Select Lead Status",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.leadStatusList
                                            .map(
                                              (leadStatus) =>
                                                  DropdownMenuItem<String>(
                                                    value: leadStatus,
                                                    child: Text(
                                                      leadStatus!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value: provider.selectedLeadStatus,
                                    onChanged: (String? value) {
                                      if (value != null) {
                                        provider.selectedLeadStatus = value;
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          TextWidget(context, "Open/Close Status"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<String>(
                                    hint: Text(
                                      "Select Open/Close Status",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.openStatusList
                                            .map(
                                              (leadStatus) =>
                                                  DropdownMenuItem<String>(
                                                    value: leadStatus,
                                                    child: Text(
                                                      leadStatus!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value: provider.selectedOpenStatus,
                                    onChanged: (String? value) {
                                      if (value != null) {
                                        provider.selectedOpenStatus = value;
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),
                          textControllerWidget(
                            context,
                            provider.mobileNumberController,
                            "Mobile Number",
                            "Enter Mobile Number",
                            provider.onChangedMobileNum,
                            TextInputType.number,
                            false,
                            FilteringTextInputFormatter.digitsOnly,
                          ),
                          textControllerWidget(
                            context,
                            provider.companyNameController,
                            "Company Name",
                            "Enter Company Name",
                            provider.onChangedCompanyName,
                            TextInputType.text,
                            false,
                            null,
                          ),

                          TextWidget(context, "Source"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<Sources>(
                                    hint: Text(
                                      "Select Source",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.sourcesList
                                            .map(
                                              (slist) =>
                                                  DropdownMenuItem<Sources>(
                                                    value: slist,
                                                    child: Text(
                                                      slist.name!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value: provider.selectedSource,
                                    onChanged: (Sources? value) {
                                      if (value != null) {
                                        if (provider.sourcesList.isNotEmpty) {
                                          provider.selectedSource = value;
                                          provider.selectedSourceId = value.id!;
                                          provider.selectedSourceValue =
                                              value.name!;
                                          provider
                                              .crmLeadListSourceOnReferenceAPIFunction(
                                                context,
                                                widget.mode,
                                                provider.selectedSourceId,
                                              );
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          TextWidget(context, "Reference"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<References>(
                                    hint: Text(
                                      "Select Reference",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.referencesList
                                            .map(
                                              (slist) =>
                                                  DropdownMenuItem<References>(
                                                    value: slist,
                                                    child: Text(
                                                      slist.name!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value: provider.selectedReference,
                                    onChanged: (References? value) {
                                      if (value != null) {
                                        if (provider
                                            .referencesList
                                            .isNotEmpty) {
                                          provider.selectedReference = value;
                                          provider.selectedReferenceId =
                                              value.id!;
                                          provider.selectedReferenceValue =
                                              value.name!;
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          TextWidget(context, "Team"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<Teams>(
                                    hint: Text(
                                      "Select Team",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.teamsList
                                            .map(
                                              (slist) =>
                                                  DropdownMenuItem<Teams>(
                                                    value: slist,
                                                    child: Text(
                                                      slist.name!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value: provider.selectedTeam,
                                    onChanged: (Teams? value) {
                                      if (value != null) {
                                        if (provider.teamsList.isNotEmpty) {
                                          provider.selectedTeam = value;
                                          provider.selectedTeamId = value.id!;
                                          provider.selectedTeamValue =
                                              value.name!;
                                          provider
                                              .crmLeadListSegmentOnTeamAPIFunction(
                                                context,
                                                widget.mode,
                                                provider.selectedTeamId,
                                              );
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          TextWidget(context, "Segment"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<Segments>(
                                    hint: Text(
                                      "Select Segment",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.segmentsList
                                            .map(
                                              (slist) =>
                                                  DropdownMenuItem<Segments>(
                                                    value: slist,
                                                    child: Text(
                                                      slist.name!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value: provider.selectedSegment,
                                    onChanged: (Segments? value) {
                                      if (value != null) {
                                        if (provider.segmentsList.isNotEmpty) {
                                          provider.selectedSegment = value;
                                          provider.selectedSegmentId =
                                              value.id!;
                                          provider.selectedSegmentValue =
                                              value.name!;
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          TextWidget(context, "State"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<States>(
                                    hint: Text(
                                      "Select State",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.statesList
                                            .map(
                                              (slist) =>
                                                  DropdownMenuItem<States>(
                                                    value: slist,
                                                    child: Text(
                                                      slist.name!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value: provider.selectedStates,
                                    onChanged: (States? value) {
                                      if (value != null) {
                                        if (provider.statesList.isNotEmpty) {
                                          provider.selectedStates = value;
                                          provider.selectedStateId = value.id!;
                                          provider.selectedStateValue =
                                              value.name!;
                                          if (provider
                                              .districtsList
                                              .isNotEmpty) {
                                            provider.districtsList.clear();
                                            // provider.selectedDistricts = null;
                                            provider.selectedDistrictId = null;
                                            provider.selectedDistrictValue = "";
                                          }
                                          provider
                                              .crmLeadListDistrictsOnStateAPIFunction(
                                                context,
                                                widget.mode,
                                                provider.selectedStateId,
                                              );
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          TextWidget(context, "District"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<Districts>(
                                    hint: Text(
                                      "Select District",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.districtsList
                                            .map(
                                              (slist) =>
                                                  DropdownMenuItem<Districts>(
                                                    value: slist,
                                                    child: Text(
                                                      slist.district!,
                                                      style: TextStyle(
                                                        fontSize: 14,
                                                      ),
                                                    ),
                                                  ),
                                            )
                                            .toList(),
                                    value: provider.selectedDistricts,
                                    onChanged: (Districts? value) {
                                      if (value != null) {
                                        if (provider.districtsList.isNotEmpty) {
                                          provider.selectedDistricts = value;
                                          provider.selectedDistrictId =
                                              value.id!;
                                          provider.selectedDistrictValue =
                                              value.district!;
                                          if (provider
                                              .subLocationsList
                                              .isNotEmpty) {
                                            provider.subLocationsList.clear();
                                            // provider.selectedSubLocations =
                                            //     null;
                                            provider.selectedSubLocationId =
                                                null;
                                            provider.selectedSubLocationValue =
                                                "";
                                          }
                                          provider
                                              .crmLeadListSubLocOnDistrictAPIFunction(
                                                context,
                                                widget.mode,
                                                provider.selectedDistrictId,
                                              );
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          TextWidget(context, "Sub Location"),
                          DropdownButtonHideUnderline(
                            child: Row(
                              children: [
                                Expanded(
                                  child: DropdownButton2<SubLocations>(
                                    hint: Text(
                                      "Select Sub Location",
                                      style: TextStyle(fontSize: 14),
                                    ),
                                    items:
                                        provider.subLocationsList
                                            .map(
                                              (slist) => DropdownMenuItem<
                                                SubLocations
                                              >(
                                                value: slist,
                                                child: Text(
                                                  slist.subLocality!,
                                                  style: TextStyle(
                                                    fontSize: 14,
                                                  ),
                                                ),
                                              ),
                                            )
                                            .toList(),
                                    value: provider.selectedSubLocations,
                                    onChanged: (SubLocations? value) {
                                      if (value != null) {
                                        if (provider
                                            .subLocationsList
                                            .isNotEmpty) {
                                          provider.selectedSubLocations = value;
                                          provider.selectedSubLocationId =
                                              value.id!;
                                          provider.selectedSubLocationValue =
                                              value.subLocality!;
                                        }
                                      }
                                    },
                                    isExpanded: true,
                                    buttonStyleData: ddtheme.buttonStyleData,
                                    iconStyleData: ddtheme.iconStyleData,
                                    menuItemStyleData:
                                        ddtheme.menuItemStyleData,
                                    dropdownStyleData:
                                        ddtheme.dropdownStyleData,
                                  ),
                                ),
                              ],
                            ),
                          ),

                          InkResponse(
                            onTap: () {
                              provider.crmLeadListAPIFunction(
                                context,
                                widget.mode,
                                provider.selectedLeadStatus,
                                provider.selectedOpenStatus,
                                provider.selectedSourceId,
                                provider.selectedReferenceId,
                                provider.selectedTeamId,
                                provider.selectedSegmentId,
                                "",
                              );
                              Navigator.pop(context);
                            },
                            child: Container(
                              height: 45,
                              alignment: Alignment.center,
                              margin: EdgeInsets.symmetric(horizontal: 10),
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 5,
                              ),
                              decoration: BoxDecoration(
                                color: AppColors.app_blue,
                                borderRadius: BorderRadius.circular(15),
                              ),
                              child: Text(
                                "Submit",
                                style: TextStyle(
                                  fontSize: 15,
                                  fontFamily: "JakartaMedium",
                                  color: Colors.white,
                                ),
                              ),
                            ),
                          ),
                        ],
                      ),
                    ),
                  );
                },
              ),
            );
          },
        );
      },
    );
  }
}
