import 'dart:io';

import 'package:cached_network_image/cached_network_image.dart';
import 'package:connectivity_plus/connectivity_plus.dart';
import 'package:dotted_line/dotted_line.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/svg.dart';
import 'package:generp/screens/finance/FileViewer.dart';
import 'package:generp/screens/notifierExports.dart';
import 'package:generp/Utils/app_colors.dart';
import 'package:generp/Utils/commonServices.dart';
import 'package:generp/Utils/commonWidgets.dart';
import 'package:get/get.dart';
import 'package:provider/provider.dart';

class GeneratorPartDetailsScreen extends StatefulWidget {
  const GeneratorPartDetailsScreen({super.key});

  @override
  State<GeneratorPartDetailsScreen> createState() =>
      _GeneratorPartDetailsScreenState();
}

class _GeneratorPartDetailsScreenState
    extends State<GeneratorPartDetailsScreen> {
  FocusNode descriptionFocusNode = FocusNode();
  FocusNode quantityFocusNode = FocusNode();

  TextEditingController descriptioncontroller = TextEditingController();
  TextEditingController quantitycontroller = TextEditingController();
  Map _source = {ConnectivityResult.mobile: true};
  final MyConnectivity _connectivity = MyConnectivity.instance;

  @override
  void initState() {
    // TODO: implement initState
    super.initState();
    _connectivity.initialise();
    _connectivity.myStream.listen((source) {
      setState(() => _source = source);
    });
    WidgetsBinding.instance.addPostFrameCallback((_) {
      var homeProvider = Provider.of<HomescreenNotifier>(
        context,
        listen: false,
      );
      initialiseFunction(context, homeProvider);
    });
  }

  @override
  void dispose() {
    // TODO: implement dispose
    super.dispose();
    _connectivity.disposeStream();
  }

  void initialiseFunction(BuildContext context, homeProvider) async {
    var inventoryProvider = Provider.of<InventoryProvider>(
      context,
      listen: false,
    );
    inventoryProvider.LoadPartDetailsApifunction(
      homeProvider,
      context,
      "",
      inventoryProvider.partID,
    );
  }

  @override
  Widget build(BuildContext context) {
    switch (_source.keys.toList()[0]) {
      case ConnectivityResult.mobile:
        connection = 'Online';
        break;
      case ConnectivityResult.wifi:
        connection = 'Online';
        break;
      case ConnectivityResult.none:
      default:
        connection = 'Offline';
    }
    return (connection == "Online")
        ? Platform.isAndroid
            ? WillPopScope(
              onWillPop: () async {
                Provider.of<Editproductlistprovider>(
                  context,
                  listen: false,
                ).resetForm();
                Provider.of<crmLeadDetailsProvider>(
                  context,
                  listen: false,
                ).resetAll();

                return onBackPressed(context);
              },
              child: SafeArea(
                top: false,
                bottom: true,
                child: _scaffold(context),
              ),
            )
            : _scaffold(context)
        : NoNetwork(context);
  }

  Widget _scaffold(BuildContext context) {
    return Consumer2<InventoryProvider, HomescreenNotifier>(
      builder: (context, provider, homeProvider, child) {
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: RefreshIndicator.adaptive(
            onRefresh: () async {
              initialiseFunction(context, homeProvider);
            },
            child: SafeArea(
              top: false,
              bottom: Platform.isIOS ? false : true,
              child: Scaffold(
                resizeToAvoidBottomInset: true,
                backgroundColor: AppColors.scaffold_bg_color,
                appBar: appbarNew(context, "Inventory", 0xFFFFFFFF),
                body: SingleChildScrollView(
                  child: Column(
                    children: [
                      Card(
                        margin: EdgeInsets.symmetric(
                          horizontal: 0,
                          vertical: 2,
                        ),
                        shape: RoundedRectangleBorder(
                          borderRadius: BorderRadius.only(
                            bottomLeft: Radius.circular(30),
                            bottomRight: Radius.circular(30),
                          ),
                        ),
                        elevation: 2,
                        child: Column(
                          children: [
                            Container(
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 15,
                              ),
                              margin: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 15,
                              ),
                              decoration: BoxDecoration(
                                color: Color(0xFFE6F6FF),
                                borderRadius: BorderRadius.circular(16),
                              ),
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  Expanded(
                                    child: SizedBox(
                                      child: Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.start,
                                        children: [
                                          Text(
                                            "${provider.partData.remainingQuantity}",
                                            style: TextStyle(
                                              color: AppColors.app_blue,
                                              fontSize: 20,
                                              height: 1,
                                              fontFamily: "JakartaMedium",
                                            ),
                                          ),
                                          Row(
                                            children: [
                                              Expanded(
                                                flex: 8,
                                                child: Text(
                                                  "Remaining Quantity",
                                                  style: TextStyle(
                                                    color: AppColors.semi_black,
                                                    fontSize: 14,
                                                    height: 1,
                                                    fontFamily:
                                                        "JakartaRegular",
                                                  ),
                                                ),
                                              ),
                                              Spacer(),
                                              Expanded(
                                                child: Container(
                                                  height: 40,
                                                  width: 40,
                                                  decoration: BoxDecoration(
                                                    shape: BoxShape.circle,
                                                    color: Colors.white,
                                                  ),
                                                  child: SvgPicture.asset(
                                                    "assets/svg/service/inventory_det_ic.svg",
                                                    fit: BoxFit.scaleDown,
                                                  ),
                                                ),
                                              ),
                                            ],
                                          ),
                                        ],
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            SizedBox(
                              height: 60,
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  Expanded(
                                    child: InkResponse(
                                      onTap: () {
                                        _showStockIssueBottomSheet(
                                          context,
                                          "Issue",
                                        );
                                      },
                                      child: Row(
                                        mainAxisAlignment:
                                            MainAxisAlignment.center,
                                        children: [
                                          SvgPicture.asset(
                                            "assets/svg/service/stock_issue_ic.svg",
                                          ),
                                          SizedBox(width: 10),
                                          Text(
                                            "Issue",
                                            style: TextStyle(
                                              color: Color(0xFFED3424),
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                  ),
                                  SvgPicture.asset(
                                    "assets/svg/crm/vertical_line_ic.svg",
                                  ),
                                  Expanded(
                                    child: InkResponse(
                                      onTap: () {
                                        _showStockIssueBottomSheet(
                                          context,
                                          "Recieve",
                                        );
                                      },
                                      child: Row(
                                        mainAxisAlignment:
                                            MainAxisAlignment.center,
                                        children: [
                                          SvgPicture.asset(
                                            "assets/svg/service/stock_recieve_ic.svg",
                                          ),
                                          SizedBox(width: 10),
                                          Text(
                                            "Recieve",
                                            style: TextStyle(
                                              color: Color(0xFF0D9C00),
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),

                      Container(
                        padding: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 10,
                        ),
                        margin: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 10,
                        ),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(16),
                        ),
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.center,
                          children: [
                            if (provider.partData.imageDirFilePath!
                                .trim()
                                .isNotEmpty) ...[
                              ClipRRect(
                                borderRadius: BorderRadius.circular(16),
                                child: CachedNetworkImage(
                                  height: 100,
                                  imageUrl: provider.partData.imageDirFilePath!,
                                  fit: BoxFit.cover,
                                ),
                              ),
                            ],

                            ...List.generate(2, (index) {
                              final values = [
                                provider.partData.prodName,
                                provider.partData.project,
                              ];
                              return Container(
                                padding: EdgeInsets.symmetric(
                                  horizontal: 10,
                                  vertical: 3,
                                ),
                                child: Row(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  mainAxisAlignment: MainAxisAlignment.center,
                                  children: [
                                    Expanded(
                                      flex: 2,
                                      child: Text(
                                        "${values[index]}",
                                        textAlign: TextAlign.center,
                                        style: TextStyle(
                                          color:
                                              index == 0
                                                  ? AppColors.semi_black
                                                  : AppColors.grey_semi,
                                          fontSize: 14,
                                          fontFamily:
                                              index == 0
                                                  ? "JakartaMedium"
                                                  : "JakartaRegular",
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              );
                            }),
                          ],
                        ),
                      ),

                      Container(
                        alignment: Alignment.topLeft,
                        padding: EdgeInsets.only(left: 10, top: 10),
                        child: Text(
                          "Product Details",
                          style: TextStyle(
                            color: AppColors.grey_thick,
                            fontFamily: "JakartaMedium",
                            fontSize: 14,
                          ),
                        ),
                      ),

                      Container(
                        padding: EdgeInsets.symmetric(
                          vertical: 10,
                          horizontal: 10,
                        ),
                        margin: EdgeInsets.symmetric(
                          vertical: 10,
                          horizontal: 10,
                        ),
                        decoration: BoxDecoration(
                          color: AppColors.white,
                          borderRadius: BorderRadius.circular(16),
                        ),
                        child: Column(
                          children: [
                            Container(
                              padding: EdgeInsets.symmetric(vertical: 4),
                              child: Row(
                                children: [
                                  Expanded(
                                    flex: 3,
                                    child: Text(
                                      "Vendor Details",
                                      style: TextStyle(
                                        fontSize: 14,
                                        fontFamily: "JakartaSemiBold",
                                      ),
                                    ),
                                  ),
                                  Expanded(
                                    flex: 6,
                                    child: DottedLine(
                                      dashGapLength: 4,
                                      dashGapColor: Colors.white,
                                      dashColor: AppColors.grey_semi,
                                      dashLength: 2,
                                      lineThickness: 0.5,
                                    ),
                                  ),
                                ],
                              ),
                            ),

                            Column(
                              children: List.generate(2, (j) {
                                final headings = ["Vendor 1", "Vendor 2"];

                                final values = [
                                  provider.partData.vendor1 ?? "-",
                                  provider.partData.vendor2 ?? "-",
                                ];
                                return Container(
                                  padding: EdgeInsets.symmetric(vertical: 7),
                                  child: Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        child: Text(
                                          headings[j],
                                          style: TextStyle(
                                            fontFamily: "JakartaRegular",
                                            fontSize: 14,
                                            color: AppColors.semi_black,
                                          ),
                                        ),
                                      ),
                                      Expanded(
                                        child: Text(
                                          values[j] == "" ? "-" : values[j],
                                          textAlign: TextAlign.right,
                                          style: TextStyle(
                                            fontSize: 14,
                                            color: AppColors.grey_semi,
                                            fontFamily: "JakartaRegular",
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                );
                              }),
                            ),

                            Container(
                              padding: EdgeInsets.symmetric(vertical: 4),
                              child: Row(
                                children: [
                                  Expanded(
                                    flex: 3,
                                    child: Text(
                                      "Other Details",
                                      style: TextStyle(
                                        fontSize: 14,
                                        fontFamily: "JakartaSemiBold",
                                      ),
                                    ),
                                  ),
                                  Expanded(
                                    flex: 6,
                                    child: DottedLine(
                                      dashGapLength: 4,
                                      dashGapColor: Colors.white,
                                      dashColor: AppColors.grey_semi,
                                      dashLength: 2,
                                      lineThickness: 0.5,
                                    ),
                                  ),
                                ],
                              ),
                            ),

                            Column(
                              children: List.generate(3, (j) {
                                final headings = ["Sub Group", "Units", "MSL"];

                                final values = [
                                  provider.partData.subGroup ?? "-",
                                  provider.partData.units ?? "-",
                                  provider.partData.msl ?? "-",
                                ];
                                return Container(
                                  padding: EdgeInsets.symmetric(vertical: 7),
                                  child: Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.start,
                                    children: [
                                      Expanded(
                                        child: Text(
                                          headings[j],
                                          style: TextStyle(
                                            fontFamily: "JakartaRegular",
                                            fontSize: 14,
                                            color: AppColors.semi_black,
                                          ),
                                        ),
                                      ),
                                      Expanded(
                                        child: Text(
                                          values[j] == "" ? "-" : values[j],
                                          textAlign: TextAlign.right,
                                          style: TextStyle(
                                            fontSize: 14,
                                            fontFamily: "JakartaRegular",
                                            color: AppColors.grey_semi,
                                          ),
                                        ),
                                      ),
                                    ],
                                  ),
                                );
                              }),
                            ),
                          ],
                        ),
                      ),

                      Container(
                        padding: EdgeInsets.symmetric(
                          vertical: 10,
                          horizontal: 10,
                        ),
                        margin: EdgeInsets.symmetric(
                          vertical: 10,
                          horizontal: 10,
                        ),
                        decoration: BoxDecoration(
                          color: AppColors.white,
                          borderRadius: BorderRadius.circular(16),
                        ),
                        child: Column(
                          children: [
                            Container(
                              padding: EdgeInsets.symmetric(vertical: 4),
                              child: Row(
                                children: [
                                  Expanded(
                                    flex: 3,
                                    child: Text(
                                      "Description",
                                      style: TextStyle(
                                        fontSize: 14,
                                        fontFamily: "JakartaSemiBold",
                                      ),
                                    ),
                                  ),
                                  Expanded(
                                    flex: 6,
                                    child: DottedLine(
                                      dashGapLength: 4,
                                      dashGapColor: Colors.white,
                                      dashColor: AppColors.grey_semi,
                                      dashLength: 2,
                                      lineThickness: 0.5,
                                    ),
                                  ),
                                ],
                              ),
                            ),

                            Container(
                              padding: EdgeInsets.symmetric(vertical: 7),
                              child: Row(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Expanded(
                                    child: Text(
                                      provider.partData.prodDesc == ""
                                          ? "-"
                                          : provider.partData.prodDesc ?? "-",
                                      style: TextStyle(
                                        fontSize: 14,
                                        color: AppColors.grey_semi,
                                        fontFamily: "JakartaRegular",
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),

                      SizedBox(height: 150),
                    ],
                  ),
                ),
              ),
            ),
          ),
        );
      },
    );
  }

  Widget _scaffold1(BuildContext context) {
    return Consumer2<InventoryProvider, HomescreenNotifier>(
      builder: (context, provider, homeProvider, child) {
        return WillPopScope(
          onWillPop: () => onBackPressed(context),
          child: RefreshIndicator.adaptive(
            onRefresh: () async {
              initialiseFunction(context, homeProvider);
            },
            child: SafeArea(
              top: false,
              bottom: Platform.isIOS ? false : true,
              child: Scaffold(
                resizeToAvoidBottomInset: true,
                backgroundColor: AppColors.scaffold_bg_color,
                appBar: appbarNew(context, "Gen Inventory", 0xFFFFFFFF),
                body: SingleChildScrollView(
                  child: Column(
                    children: [
                      Container(
                        margin: EdgeInsets.only(top: 15, bottom: 15),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(16),
                        ),
                        child: Column(
                          children: [
                            Container(
                              padding: EdgeInsets.only(
                                left: 10,
                                right: 10,
                                top: 15,
                              ),
                              child: Row(
                                children: [
                                  Expanded(
                                    child: Text(
                                      "${provider.partData.prodName}",
                                      style: TextStyle(
                                        color: AppColors.app_blue,
                                        fontFamily: "JakartaMedium",
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            Container(
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 15,
                              ),
                              margin: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 15,
                              ),
                              decoration: BoxDecoration(
                                color: Color(0xFFE6F6FF),
                                borderRadius: BorderRadius.circular(16),
                              ),
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  Expanded(
                                    child: SizedBox(
                                      child: Column(
                                        crossAxisAlignment:
                                            CrossAxisAlignment.center,
                                        children: [
                                          RichText(
                                            text: TextSpan(
                                              children: [
                                                TextSpan(
                                                  text:
                                                      "${provider.partData.remainingQuantity}",
                                                  style: TextStyle(
                                                    color: AppColors.app_blue,
                                                    fontSize: 30,
                                                  ),
                                                ),
                                              ],
                                            ),
                                          ),
                                          Text(
                                            "Remaining Quantity",
                                            style: TextStyle(
                                              color: AppColors.grey_semi,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            Container(
                              padding: EdgeInsets.symmetric(
                                horizontal: 15,
                                vertical: 15,
                              ),
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.center,
                                children: [
                                  Expanded(
                                    child: InkResponse(
                                      onTap: () {
                                        _showStockIssueBottomSheet(
                                          context,
                                          "Issue",
                                        );
                                      },
                                      child: Container(
                                        height: 45,
                                        decoration: BoxDecoration(
                                          color: Color(0xFFFFEFEF),
                                          border: Border.all(
                                            color: Color(0xFFED3424),
                                            width: 0.5,
                                          ),
                                          borderRadius: BorderRadius.circular(
                                            12,
                                          ),
                                        ),
                                        child: Center(
                                          child: Text(
                                            "- Issue",
                                            style: TextStyle(
                                              color: Color(0xFFED3424),
                                            ),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ),
                                  SizedBox(width: 10),
                                  Expanded(
                                    child: InkResponse(
                                      onTap: () {
                                        _showStockIssueBottomSheet(
                                          context,
                                          "Recieve",
                                        );
                                      },
                                      child: Container(
                                        height: 45,
                                        decoration: BoxDecoration(
                                          color: Color(0xFFE7FFE5),
                                          border: Border.all(
                                            color: Color(0xFF0D9C00),
                                            width: 0.5,
                                          ),
                                          borderRadius: BorderRadius.circular(
                                            12,
                                          ),
                                        ),
                                        child: Center(
                                          child: Text(
                                            "+ Recieve",
                                            style: TextStyle(
                                              color: Color(0xFF0D9C00),
                                            ),
                                          ),
                                        ),
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                          ],
                        ),
                      ),

                      Container(
                        alignment: Alignment.topLeft,
                        padding: EdgeInsets.symmetric(horizontal: 10),
                        child: Text(
                          "Product Details",
                          style: TextStyle(
                            color: AppColors.grey_semi,
                            fontFamily: "JakartaMedium",
                          ),
                        ),
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 10,
                        ),
                        margin: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 10,
                        ),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(16),
                        ),
                        child: Column(
                          children: List.generate(2, (index) {
                            final headings = [
                              "Product Name",
                              // "Product ID",
                              "Project",
                            ];

                            final values = [
                              provider.partData.prodName,
                              // provider.partData.id,
                              provider.partData.project,
                            ];
                            return Container(
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              child: Row(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Expanded(
                                    flex: 1,
                                    child: Text(
                                      headings[index],
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                      ),
                                    ),
                                  ),
                                  Expanded(
                                    flex: 2,
                                    child: Text(
                                      "${values[index]}",
                                      style: TextStyle(
                                        color: AppColors.grey_semi,
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            );
                          }),
                        ),
                      ),

                      Container(
                        alignment: Alignment.topLeft,
                        padding: EdgeInsets.symmetric(horizontal: 10),
                        child: Text(
                          "Vendor Details",
                          style: TextStyle(
                            fontFamily: "JakartaMedium",
                            color: AppColors.grey_semi,
                          ),
                        ),
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 10,
                        ),
                        margin: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 10,
                        ),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(16),
                        ),
                        child: Column(
                          children: List.generate(2, (index) {
                            final headings = ["Vendor 1", "Vendor 2"];

                            final values = [
                              provider.partData.vendor1,
                              provider.partData.vendor2,
                            ];
                            return Container(
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              child: Row(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Expanded(
                                    flex: 1,
                                    child: Text(
                                      headings[index],
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                      ),
                                    ),
                                  ),
                                  Expanded(
                                    flex: 2,
                                    child: Text(
                                      "${values[index]}",
                                      style: TextStyle(
                                        color: AppColors.grey_semi,
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            );
                          }),
                        ),
                      ),

                      Container(
                        alignment: Alignment.topLeft,
                        padding: EdgeInsets.symmetric(horizontal: 10),
                        child: Text(
                          "Other Details",
                          style: TextStyle(
                            fontFamily: "JakartaMedium",
                            color: AppColors.grey_semi,
                          ),
                        ),
                      ),
                      Container(
                        padding: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 10,
                        ),
                        margin: EdgeInsets.symmetric(
                          horizontal: 10,
                          vertical: 10,
                        ),
                        decoration: BoxDecoration(
                          color: Colors.white,
                          borderRadius: BorderRadius.circular(16),
                        ),
                        child: Column(
                          children: List.generate(5, (index) {
                            final headings = [
                              "Sub Group",
                              "Units",
                              "MSL",
                              "Description",
                              "Image",
                            ];

                            final values = [
                              provider.partData.subGroup,
                              provider.partData.units,
                              provider.partData.msl,
                              provider.partData.prodDesc,
                              "View",
                            ];
                            if (index == 4 &&
                                provider.partData.imageDirFilePath == "") {
                              return SizedBox.shrink();
                            }
                            return Container(
                              padding: EdgeInsets.symmetric(
                                horizontal: 10,
                                vertical: 10,
                              ),
                              child: Row(
                                crossAxisAlignment: CrossAxisAlignment.start,
                                mainAxisAlignment: MainAxisAlignment.start,
                                children: [
                                  Expanded(
                                    flex: 1,
                                    child: Text(
                                      headings[index],
                                      style: TextStyle(
                                        fontFamily: "JakartaMedium",
                                      ),
                                    ),
                                  ),
                                  if (values[index] == "View") ...[
                                    Expanded(
                                      flex: 2,
                                      child: InkResponse(
                                        onTap: () {
                                          Navigator.push(
                                            context,
                                            MaterialPageRoute(
                                              builder:
                                                  (context) => Fileviewer(
                                                    fileName:
                                                        provider
                                                            .partData
                                                            .imageViewFileName!,
                                                    fileUrl:
                                                        provider
                                                            .partData
                                                            .imageDirFilePath!,
                                                    downloadEnable: false,
                                                  ),
                                            ),
                                          );
                                        },
                                        child: Text(
                                          "${values[index]}",
                                          style: TextStyle(
                                            color: AppColors.app_blue,
                                            decoration:
                                                TextDecoration.underline,
                                            decorationColor: AppColors.app_blue,
                                          ),
                                        ),
                                      ),
                                    ),
                                  ] else ...[
                                    Expanded(
                                      flex: 2,
                                      child: Text(
                                        "${values[index]}",
                                        style: TextStyle(
                                          color: AppColors.grey_semi,
                                        ),
                                      ),
                                    ),
                                  ],
                                ],
                              ),
                            );
                          }),
                        ),
                      ),

                      // Container(
                      //   alignment: Alignment.topLeft,
                      //   padding: EdgeInsets.symmetric(horizontal: 10),
                      //   child: Text(
                      //     "Description",
                      //     style: TextStyle(
                      //       fontFamily: "JakartaMedium",
                      //       color: AppColors.grey_semi,
                      //     ),
                      //   ),
                      // ),
                      // Container(
                      //   padding: EdgeInsets.symmetric(
                      //     horizontal: 10,
                      //     vertical: 10,
                      //   ),
                      //   margin: EdgeInsets.symmetric(
                      //     horizontal: 10,
                      //     vertical: 10,
                      //   ),
                      //   decoration: BoxDecoration(
                      //     color: Colors.white,
                      //     borderRadius: BorderRadius.circular(16),
                      //   ),
                      //   child: Container(
                      //     padding: EdgeInsets.symmetric(
                      //       horizontal: 10,
                      //       vertical: 10,
                      //     ),
                      //     child: Row(
                      //       children: [
                      //         Expanded(
                      //           child: SizedBox(
                      //             child: Column(
                      //               crossAxisAlignment: CrossAxisAlignment.start,
                      //               mainAxisAlignment: MainAxisAlignment.start,
                      //               children: [
                      //                 Text(
                      //                   "Description",
                      //                   style: TextStyle(
                      //                     fontFamily: "JakartaMedium",
                      //                   ),
                      //                 ),
                      //                 Text(
                      //
                      //                   style: TextStyle(
                      //                     color: AppColors.grey_semi,
                      //                   ),
                      //                 ),
                      //               ],
                      //             ),
                      //           ),
                      //         ),
                      //       ],
                      //     ),
                      //   ),
                      // ),
                      SizedBox(height: 150),
                    ],
                  ),
                ),
              ),
            ),
          ),
        );
      },
    );
  }

  Future<void> _showStockIssueBottomSheet(BuildContext context, type) {
    return showModalBottomSheet(
      useSafeArea: true,
      isDismissible: true,
      isScrollControlled: true,
      showDragHandle: true,
      useRootNavigator: true,
      enableDrag: true,
      context: context,
      builder: (context) {
        return StatefulBuilder(
          builder: (context, setState) {
            return SafeArea(
              child: Padding(
                padding: EdgeInsets.only(
                  bottom:
                      MediaQuery.of(
                        context,
                      ).viewInsets.bottom, // This handles keyboard
                ),
                child: Container(
                  margin: EdgeInsets.only(
                    bottom: 15,
                    left: 15,
                    right: 15,
                    top: 30,
                  ),

                  child: Consumer2<InventoryProvider, HomescreenNotifier>(
                    builder: (context, provider, homeProvider, child) {
                      return SingleChildScrollView(
                        child: Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Text(
                              "Inventory $type",
                              style: TextStyle(
                                color: AppColors.app_blue,
                                fontWeight: FontWeight.w600,
                                fontSize: 16,
                              ),
                            ),
                            SizedBox(height: 10),
                            Container(
                              alignment: Alignment.topLeft,
                              child: Text(
                                "Quantity",
                                style: TextStyle(
                                  color: AppColors.semi_black,
                                  fontSize: 14,
                                ),
                              ),
                            ),
                            SizedBox(height: 5),
                            Container(
                              height: 48,
                              alignment: Alignment.center,
                              decoration: BoxDecoration(
                                color: AppColors.text_field_color,
                                borderRadius: BorderRadius.circular(16),
                                border:
                                    quantityFocusNode.hasFocus
                                        ? Border.all(
                                          color: AppColors.app_blue,
                                          width: 0.5,
                                        )
                                        : null,
                              ),
                              //  alignment: Alignment.center,
                              margin: EdgeInsets.only(left: 5.0, right: 5.0),
                              child: Padding(
                                padding: const EdgeInsets.fromLTRB(
                                  10.0,
                                  0.0,
                                  15,
                                  0,
                                ),
                                child: TextField(
                                  controller: quantitycontroller,
                                  keyboardType: TextInputType.numberWithOptions(
                                    decimal: true,
                                    signed: true,
                                  ),
                                  focusNode: quantityFocusNode,
                                  style: TextStyle(fontSize: 14),

                                  onChanged: (value) {
                                    provider.updateQuantity(
                                      quantitycontroller.text,
                                    );
                                  },
                                  onTapOutside: (event) {
                                    // Handle onTapOutside
                                    FocusScope.of(context).unfocus();
                                  },
                                  decoration: InputDecoration(
                                    isDense: true,
                                    hintStyle: TextStyle(
                                      color: AppColors.grey_semi,
                                      fontSize: 14,
                                    ),

                                    //contentPadding: EdgeInsets.fromLTRB(5.0, 10.0, 5.0, 10.0),
                                    enabledBorder: InputBorder.none,
                                    focusedBorder: InputBorder.none,
                                    hintText: 'Enter Quantity',
                                  ),
                                ),
                              ),
                            ),
                            SizedBox(height: 10),
                            Container(
                              alignment: Alignment.topLeft,
                              child: Text(
                                "Description",
                                style: TextStyle(
                                  color: AppColors.semi_black,
                                  fontSize: 14,
                                ),
                              ),
                            ),
                            SizedBox(height: 5),
                            Container(
                              height: 180,
                              alignment: Alignment.center,
                              decoration: BoxDecoration(
                                color: AppColors.text_field_color,
                                borderRadius: BorderRadius.circular(20),
                                border:
                                    descriptionFocusNode.hasFocus
                                        ? Border.all(
                                          color: AppColors.app_blue,
                                          width: 0.5,
                                        )
                                        : null,
                              ),
                              //  alignment: Alignment.center,
                              margin: EdgeInsets.only(left: 5.0, right: 5.0),
                              child: Padding(
                                padding: const EdgeInsets.fromLTRB(
                                  10.0,
                                  0.0,
                                  15,
                                  0,
                                ),
                                child: TextField(
                                  controller: descriptioncontroller,
                                  maxLines: 100,
                                  keyboardType: TextInputType.text,
                                  focusNode: descriptionFocusNode,
                                  style: TextStyle(fontSize: 14),
                                  onChanged: (value) {
                                    provider.updateQuantity(
                                      descriptioncontroller.text,
                                    );
                                  },
                                  onTapOutside: (event) {
                                    // Handle onTapOutside
                                    FocusScope.of(context).unfocus();
                                  },
                                  decoration: InputDecoration(
                                    isDense: true,
                                    hintStyle: TextStyle(
                                      color: AppColors.grey_semi,
                                      fontSize: 14,
                                    ),
                                    contentPadding: EdgeInsets.fromLTRB(
                                      5.0,
                                      10.0,
                                      5.0,
                                      10.0,
                                    ),
                                    enabledBorder: InputBorder.none,
                                    focusedBorder: InputBorder.none,
                                    hintText: 'Enter Description',
                                  ),
                                ),
                              ),
                            ),
                            InkWell(
                              onTap: () {
                                print(provider.isButtonEnabled);
                                if (type == "Recieve") {
                                  provider.issuetype = "Recieved";
                                } else {
                                  provider.issuetype = "Issued";
                                }

                                provider.StockRecieveIssueAPI(
                                  homeProvider,
                                  context,
                                  quantitycontroller.text,
                                  descriptioncontroller.text,
                                  provider.partID,
                                  provider.issuetype,
                                );
                                quantitycontroller.clear();
                                descriptioncontroller.clear();
                              },

                              child: Container(
                                alignment: Alignment.center,
                                height: 45,
                                margin: EdgeInsets.only(
                                  left: 5.0,
                                  right: 5.0,
                                  top: 5.0,
                                  bottom: 5.0,
                                ),
                                decoration: BoxDecoration(
                                  color:
                                      quantitycontroller.text.isEmpty ||
                                              descriptioncontroller.text.isEmpty
                                          ? AppColors.button_disabled
                                          : AppColors.app_blue, //1487C9
                                  borderRadius: BorderRadius.circular(12.0),
                                ),
                                child: Center(
                                  child: Text(
                                    "Submit",
                                    textAlign: TextAlign.center,
                                    style: TextStyle(color: Colors.white),
                                  ),
                                ),
                              ),
                            ),
                          ],
                        ),
                      );
                    },
                  ),
                ),
              ),
            );
          },
        );
      },
    );
  }
}
